/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.IntStream;
import net.algart.contours.ContourHeader;
import net.algart.contours.ContourNestingAnalyser;
import net.algart.contours.Contours;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryParameter;
import net.algart.math.IRectangularArea;

public final class MeasureContours
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_PARENT_CONTOUR_INDEX = "parent_contour_index";
    public static final String OUTPUT_NESTING_LEVEL = "nesting_level";
    public static final String OUTPUT_STRICT_AREA = "strict_area";
    public static final String OUTPUT_SEGMENT_CENTERS_AREA = "segment_centers_area";
    public static final String OUTPUT_STRICT_PERIMETER = "strict_perimeter";
    public static final String OUTPUT_SEGMENT_CENTERS_PERIMETER = "segment_centers_perimeter";
    public static final String OUTPUT_PRECISE_DOUBLED_AREA = "precise_doubled_area";
    public static final String OUTPUT_CONTAINING_RECTANGLE = "containing_rectangle";
    public static final String OUTPUT_INSIDE_REPRESENTATIVE = "inside_representative";
    public static final String OUTPUT_DEGENERATED = "degenerated";
    public static final String OUTPUT_TOUCHING_MATRIX_BOUNDARY_FLAGS = "matrix_boundary_flags";
    public static final String OUTPUT_FRAME_ID = "frame_id";
    public static final String OUTPUT_SORTED_INDEXES_BY_LABEL = "sorted_indexes_by_label";
    public static final String OUTPUT_SORTED_INDEXES_BY_AREA = "sorted_indexes_by_area";
    public static final String OUTPUT_CONTOUR_OFFSETS = "contour_offsets";
    public static final String OUTPUT_CONTAINING_ALL_RECTANGLE = "containing_all_rectangle";
    private boolean needToAnalyseNestingForDiagonals = false;
    private boolean pixelCoordinatesForRectangles = true;

    public MeasureContours() {
        this.useVisibleResultParameter();
        this.setDefaultInputNumbers(INPUT_CONTOURS);
        this.addOutputNumbers("object_label");
        this.addOutputNumbers(OUTPUT_PARENT_CONTOUR_INDEX);
        this.addOutputNumbers(OUTPUT_NESTING_LEVEL);
        this.addOutputNumbers(OUTPUT_STRICT_AREA);
        this.addOutputNumbers(OUTPUT_SEGMENT_CENTERS_AREA);
        this.addOutputNumbers(OUTPUT_STRICT_PERIMETER);
        this.addOutputNumbers(OUTPUT_SEGMENT_CENTERS_PERIMETER);
        this.addOutputNumbers(OUTPUT_PRECISE_DOUBLED_AREA);
        this.addOutputNumbers(OUTPUT_CONTAINING_RECTANGLE);
        this.addOutputNumbers(OUTPUT_INSIDE_REPRESENTATIVE);
        this.addOutputNumbers(OUTPUT_DEGENERATED);
        this.addOutputNumbers("internal_boundary");
        this.addOutputNumbers(OUTPUT_TOUCHING_MATRIX_BOUNDARY_FLAGS);
        this.addOutputNumbers(OUTPUT_FRAME_ID);
        this.addOutputNumbers(OUTPUT_SORTED_INDEXES_BY_LABEL);
        this.addOutputNumbers(OUTPUT_SORTED_INDEXES_BY_AREA);
        this.addOutputNumbers(OUTPUT_CONTOUR_OFFSETS);
        this.addOutputNumbers(OUTPUT_CONTAINING_ALL_RECTANGLE);
        this.addOutputScalar("number_of_objects");
    }

    public boolean isNeedToAnalyseNestingForDiagonals() {
        return this.needToAnalyseNestingForDiagonals;
    }

    public MeasureContours setNeedToAnalyseNestingForDiagonals(boolean needToAnalyseNestingForDiagonals) {
        this.needToAnalyseNestingForDiagonals = needToAnalyseNestingForDiagonals;
        return this;
    }

    public boolean isPixelCoordinatesForRectangles() {
        return this.pixelCoordinatesForRectangles;
    }

    public MeasureContours setPixelCoordinatesForRectangles(boolean pixelCoordinatesForRectangles) {
        this.pixelCoordinatesForRectangles = pixelCoordinatesForRectangles;
        return this;
    }

    public void process() {
        int[] indexes;
        int n;
        Object[] result;
        Contours contours = Contours.deserialize((int[])this.getInputNumbers(INPUT_CONTOURS).toIntArray());
        this.getScalar("number_of_objects").setTo(contours.numberOfContours());
        long t1 = MeasureContours.debugTime();
        Object additionalTiming = "";
        boolean nestingLevelNecessary = this.isOutputNecessary(OUTPUT_NESTING_LEVEL);
        long[] doubledAreas = null;
        if (this.isOutputNecessary(OUTPUT_PARENT_CONTOUR_INDEX) || nestingLevelNecessary) {
            Contours unpackedIfNeeded;
            boolean weUnpackContours;
            long t11 = MeasureContours.debugTime();
            boolean bl = weUnpackContours = !this.needToAnalyseNestingForDiagonals;
            if (weUnpackContours) {
                doubledAreas = new long[contours.numberOfContours()];
                unpackedIfNeeded = contours.unpackContours(false, doubledAreas);
            } else {
                unpackedIfNeeded = contours;
            }
            long t12 = MeasureContours.debugTime();
            ContourNestingAnalyser analyser = ContourNestingAnalyser.newInstance((Contours)unpackedIfNeeded, (boolean)weUnpackContours, (long[])doubledAreas);
            analyser.setNestingLevelNecessary(nestingLevelNecessary);
            long t13 = MeasureContours.debugTime();
            analyser.analyseAllContours();
            long t14 = MeasureContours.debugTime();
            this.getNumbers(OUTPUT_PARENT_CONTOUR_INDEX).setTo(analyser.getContourNestingParents(), 1);
            if (nestingLevelNecessary) {
                this.getNumbers(OUTPUT_NESTING_LEVEL).setTo(analyser.getContourNestingLevels(), 1);
            } else {
                this.getNumbers(OUTPUT_NESTING_LEVEL).setInitialized(false);
            }
            if (LOGGABLE_DEBUG) {
                double m = 1.0 / (double)contours.numberOfContours();
                additionalTiming = (String)additionalTiming + String.format(Locale.US, "; nesting: %s%.3f ms initializing + %.3f ms analysis (total/mean number of nesting contours %d/%.4f, checked %d/%.4f, summary length %d/%.4f - %s)", weUnpackContours ? String.format(Locale.US, "%.3f ms unpacking + ", (double)(t12 - t11) * 1.0E-6) : "", (double)(t13 - t12) * 1.0E-6, (double)(t14 - t13) * 1.0E-6, analyser.numberOfNestingContours(), (double)analyser.numberOfNestingContours() * m, analyser.numberOfCheckedContours(), (double)analyser.numberOfCheckedContours() * m, analyser.summaryContoursLength(), (double)analyser.summaryContoursLength() * m, analyser);
            }
        }
        if (this.isOutputNecessary("object_label")) {
            this.getNumbers("object_label").setTo(contours.getAllObjectLabels(), 1);
        }
        if (this.isOutputNecessary(OUTPUT_STRICT_AREA)) {
            float[] result2 = new float[contours.numberOfContours()];
            IntStream.range(0, result2.length).parallel().forEach(k -> {
                result[k] = (float)contours.strictArea(k);
            });
            this.getNumbers(OUTPUT_STRICT_AREA).setTo(result2, 1);
        }
        if (this.isOutputNecessary(OUTPUT_SEGMENT_CENTERS_AREA)) {
            float[] result3 = new float[contours.numberOfContours()];
            IntStream.range(0, result3.length).parallel().forEach(k -> {
                result[k] = (float)contours.segmentCentersArea(k);
            });
            this.getNumbers(OUTPUT_SEGMENT_CENTERS_AREA).setTo(result3, 1);
        }
        if (this.isOutputNecessary(OUTPUT_STRICT_PERIMETER)) {
            float[] result4 = new float[contours.numberOfContours()];
            IntStream.range(0, result4.length).parallel().forEach(k -> {
                result[k] = (float)contours.strictPerimeter(k);
            });
            this.getNumbers(OUTPUT_STRICT_PERIMETER).setTo(result4, 1);
        }
        if (this.isOutputNecessary(OUTPUT_SEGMENT_CENTERS_PERIMETER)) {
            float[] result5 = new float[contours.numberOfContours()];
            IntStream.range(0, result5.length).parallel().forEach(k -> {
                result[k] = (float)contours.segmentCentersPerimeter(k);
            });
            this.getNumbers(OUTPUT_SEGMENT_CENTERS_PERIMETER).setTo(result5, 1);
        }
        if (this.isOutputNecessary(OUTPUT_PRECISE_DOUBLED_AREA)) {
            long[] result6;
            if (doubledAreas != null) {
                result6 = doubledAreas;
            } else {
                result6 = new long[contours.numberOfContours()];
                IntStream.range(0, result6.length).parallel().forEach(k -> {
                    result[k] = contours.preciseDoubledArea(k);
                });
            }
            this.getNumbers(OUTPUT_PRECISE_DOUBLED_AREA).setTo(result6, 1);
        }
        long containingAllMinX = Long.MAX_VALUE;
        long containingAllMaxX = Long.MIN_VALUE;
        long containingAllMinY = Long.MAX_VALUE;
        long containingAllMaxY = Long.MIN_VALUE;
        if (this.isOutputNecessary(OUTPUT_CONTAINING_RECTANGLE) || this.isOutputNecessary(OUTPUT_CONTAINING_ALL_RECTANGLE)) {
            result = new float[4 * contours.numberOfContours()];
            ContourHeader h = new ContourHeader();
            n = contours.numberOfContours();
            double correction = this.pixelCoordinatesForRectangles ? -0.5 : 0.0;
            int k2 = 0;
            int offset = 0;
            while (k2 < n) {
                contours.getHeader(h, k2);
                BoundaryParameter.pushRectangle(result, offset, (double)h.minX() + correction, (double)h.minY() + correction, (double)h.maxX() + correction, (double)h.maxY() + correction);
                containingAllMinX = Math.min(containingAllMinX, (long)h.minX());
                containingAllMaxX = Math.max(containingAllMaxX, (long)h.maxX());
                containingAllMinY = Math.min(containingAllMinY, (long)h.minY());
                containingAllMaxY = Math.max(containingAllMaxY, (long)h.maxY());
                ++k2;
                offset += 4;
            }
            this.getNumbers(OUTPUT_CONTAINING_RECTANGLE).setTo(result, 4);
            if (n > 0) {
                this.getNumbers(OUTPUT_CONTAINING_ALL_RECTANGLE).setTo(IRectangularArea.valueOf((long)containingAllMinX, (long)containingAllMinY, (long)containingAllMaxX, (long)containingAllMaxY));
            }
        }
        if (this.isOutputNecessary(OUTPUT_INSIDE_REPRESENTATIVE) || this.isOutputNecessary(OUTPUT_DEGENERATED)) {
            long t11 = MeasureContours.debugTime();
            n = contours.numberOfContours();
            float[] result7 = new float[2 * n];
            byte[] degenerated = new byte[n];
            long t12 = MeasureContours.debugTime();
            IntStream.range(0, n + 15 >>> 4).parallel().forEach(block -> {
                int i;
                Point2D.Float point = new Point2D.Float();
                int to = (int)Math.min((long)i + 16L, (long)n);
                for (i = block << 4; i < to; ++i) {
                    boolean found = contours.findSomePointInside((Point2D)point, i);
                    result[2 * i] = point.x;
                    result[2 * i + 1] = point.y;
                    degenerated[i] = found ? (byte)0 : (byte)1;
                }
            });
            long t13 = MeasureContours.debugTime();
            additionalTiming = (String)additionalTiming + String.format(Locale.US, "; representatives: %.3f ms allocation + %.3f ms analysis", (double)(t12 - t11) * 1.0E-6, (double)(t13 - t12) * 1.0E-6);
            this.getNumbers(OUTPUT_INSIDE_REPRESENTATIVE).setTo(result7, 2);
            this.getNumbers(OUTPUT_DEGENERATED).setTo(degenerated, 1);
        }
        if (this.isOutputNecessary("internal_boundary")) {
            this.getNumbers("internal_boundary").setTo(MeasureContours.booleansToBytes(contours.getAllInternalContour()), 1);
        }
        if (this.isOutputNecessary(OUTPUT_TOUCHING_MATRIX_BOUNDARY_FLAGS)) {
            result = new byte[4 * contours.numberOfContours()];
            ContourHeader h = new ContourHeader();
            int n2 = contours.numberOfContours();
            int offset = 0;
            for (int k3 = 0; k3 < n2; ++k3) {
                contours.getHeader(h, k3);
                result[offset++] = (byte)(h.isContourTouchingMinXMatrixBoundary() ? 1 : 0);
                result[offset++] = (byte)(h.isContourTouchingMaxXMatrixBoundary() ? 1 : 0);
                result[offset++] = (byte)(h.isContourTouchingMinYMatrixBoundary() ? 1 : 0);
                result[offset++] = (byte)(h.isContourTouchingMaxYMatrixBoundary() ? 1 : 0);
            }
            this.getNumbers(OUTPUT_TOUCHING_MATRIX_BOUNDARY_FLAGS).setTo((byte[])result, 4);
        }
        if (this.isOutputNecessary(OUTPUT_FRAME_ID)) {
            this.getNumbers(OUTPUT_FRAME_ID).setTo(contours.getAllFrameId(-1), 1);
        }
        if (this.isOutputNecessary(OUTPUT_SORTED_INDEXES_BY_LABEL)) {
            indexes = new int[contours.numberOfContours()];
            Arrays.setAll(indexes, k -> k);
            contours.sortIndexesByLabels(indexes);
            this.getNumbers(OUTPUT_SORTED_INDEXES_BY_LABEL).setTo(indexes, 1);
        }
        if (this.isOutputNecessary(OUTPUT_SORTED_INDEXES_BY_AREA)) {
            indexes = new int[contours.numberOfContours()];
            Arrays.setAll(indexes, k -> k);
            contours.sortIndexesByPreciseArea(indexes, true);
            this.getNumbers(OUTPUT_SORTED_INDEXES_BY_AREA).setTo(indexes, 1);
        }
        if (this.isOutputNecessary(OUTPUT_CONTOUR_OFFSETS)) {
            result = new int[contours.numberOfContours()];
            IntStream.range(0, result.length + 255 >>> 8).parallel().forEach(arg_0 -> MeasureContours.lambda$process$8((int[])result, contours, arg_0));
            this.getNumbers(OUTPUT_CONTOUR_OFFSETS).setTo((int[])result, 1);
        }
        long t2 = MeasureContours.debugTime();
        if (LOGGABLE_DEBUG) {
            MeasureContours.logDebug((String)String.format(Locale.US, "%d contours measured in %.3f ms, %.5f mcs/contour%s", contours.numberOfContours(), (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) * 0.001 / (double)contours.numberOfContours(), additionalTiming));
        }
    }

    static byte[] booleansToBytes(boolean[] array) {
        byte[] result = new byte[array.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = array[k] ? (byte)1 : 0;
        }
        return result;
    }

    private static /* synthetic */ void lambda$process$8(int[] result, Contours contours, int block) {
        int i;
        int to = (int)Math.min((long)i + 256L, (long)result.length);
        for (i = block << 8; i < to; ++i) {
            result[i] = contours.getContourOffset(i);
        }
    }
}

