/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.misc;

import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.enums.ODepth;
import net.algart.executors.modules.opencv.util.enums.ODistanceLabelType;
import net.algart.executors.modules.opencv.util.enums.ODistanceType;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class DistanceTransform
extends VoidResultUMatFilter {
    public static final String OUTPUT_LABELS = "labels";
    private ODistanceType distanceType = ODistanceType.DIST_L2;
    private int maskSize = 3;
    private ODepth resultDepth = ODepth.CV_32F;
    private ODistanceLabelType labelType = ODistanceLabelType.DIST_LABEL_CCOMP;

    public DistanceTransform() {
        this.addOutputMat(OUTPUT_LABELS);
    }

    public ODistanceType getDistanceType() {
        return this.distanceType;
    }

    public void setDistanceType(ODistanceType distanceType) {
        this.distanceType = (ODistanceType)((Object)DistanceTransform.nonNull((Object)((Object)distanceType)));
    }

    public int getMaskSize() {
        return this.maskSize;
    }

    public void setMaskSize(int maskSize) {
        this.maskSize = DistanceTransform.nonNegative((int)maskSize);
    }

    public ODepth getResultDepth() {
        return this.resultDepth;
    }

    public void setResultDepth(ODepth resultDepth) {
        this.resultDepth = (ODepth)((Object)DistanceTransform.nonNull((Object)((Object)resultDepth)));
    }

    public ODistanceLabelType getLabelType() {
        return this.labelType;
    }

    public void setLabelType(ODistanceLabelType labelType) {
        this.labelType = (ODistanceLabelType)((Object)DistanceTransform.nonNull((Object)((Object)labelType)));
    }

    @Override
    public void process(Mat result, Mat source) {
        if (this.isOutputNecessary(OUTPUT_LABELS)) {
            DistanceTransform.logDebug(() -> "Distance transform with labels: distanceType = " + this.distanceType + ", maskSize = " + this.maskSize + ", labelType = " + this.labelType + " (source: " + source + ")");
            Mat labels = new Mat();
            opencv_imgproc.distanceTransformWithLabels((Mat)source, (Mat)result, (Mat)labels, (int)this.distanceType.code(), (int)this.maskSize, (int)this.labelType.code());
            this.setEndProcessingTimeStamp();
            O2SMat.setTo(this.getMat(OUTPUT_LABELS), labels);
        } else {
            DistanceTransform.logDebug(() -> "Distance transform without labels: distanceType = " + this.distanceType + ", maskSize = " + this.maskSize + ", resultDepth = " + this.resultDepth + " (source: " + source + ")");
            opencv_imgproc.distanceTransform((Mat)source, (Mat)result, (int)this.distanceType.code(), (int)this.maskSize, (int)this.resultDepth.code());
        }
    }

    @Override
    public void process(UMat result, UMat source) {
        if (this.isOutputNecessary(OUTPUT_LABELS)) {
            DistanceTransform.logDebug(() -> "Distance transform with labels (GPU): distanceType = " + this.distanceType + ", maskSize = " + this.maskSize + ", labelType = " + this.labelType + " (source: " + source + ")");
            UMat labels = new UMat();
            opencv_imgproc.distanceTransformWithLabels((UMat)source, (UMat)result, (UMat)labels, (int)this.distanceType.code(), (int)this.maskSize, (int)this.labelType.code());
            this.setEndProcessingTimeStamp();
            O2SMat.setTo(this.getMat(OUTPUT_LABELS), labels);
        } else {
            DistanceTransform.logDebug(() -> "Distance transform without labels (GPU): distanceType = " + this.distanceType + ", maskSize = " + this.maskSize + ", resultDepth = " + this.resultDepth + " (source: " + source + ")");
            opencv_imgproc.distanceTransform((UMat)source, (UMat)result, (int)this.distanceType.code(), (int)this.maskSize, (int)this.resultDepth.code());
        }
    }

    @Override
    protected boolean allowInputPackedBits() {
        return true;
    }
}

