/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OInterpolation;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.TermCriteria;
import org.bytedeco.opencv.opencv_core.UMat;

public final class MeanShift
extends UMatFilter {
    private double spatialRadius = 15.0;
    private double colorRadius = 0.1;
    private int maxPyramidLevel = 0;
    private int terminationMaxCount = 0;
    private double terminationEpsilon = 0.0;

    public MeanShift() {
        this.setStretchingInterpolation(OInterpolation.INTER_LINEAR);
    }

    public double getSpatialRadius() {
        return this.spatialRadius;
    }

    public void setSpatialRadius(double spatialRadius) {
        this.spatialRadius = MeanShift.positive((double)spatialRadius);
    }

    public double getColorRadius() {
        return this.colorRadius;
    }

    public void setColorRadius(double colorRadius) {
        this.colorRadius = MeanShift.positive((double)colorRadius);
    }

    public int getMaxPyramidLevel() {
        return this.maxPyramidLevel;
    }

    public void setMaxPyramidLevel(int maxPyramidLevel) {
        this.maxPyramidLevel = MeanShift.nonNegative((int)maxPyramidLevel);
    }

    public int getTerminationMaxCount() {
        return this.terminationMaxCount;
    }

    public void setTerminationMaxCount(int terminationMaxCount) {
        this.terminationMaxCount = MeanShift.nonNegative((int)terminationMaxCount);
    }

    public double getTerminationEpsilon() {
        return this.terminationEpsilon;
    }

    public void setTerminationEpsilon(double terminationEpsilon) {
        this.terminationEpsilon = MeanShift.nonNegative((double)terminationEpsilon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mat process(Mat source) {
        MeanShift.logDebug(() -> "MeanShift segmentation: spatialRadius = " + this.spatialRadius + ", colorRadius = " + this.colorRadius + " (source: " + source + ")");
        Mat result = new Mat();
        try (TermCriteria termCriteria = OTools.termCriteria(this.terminationMaxCount, this.terminationEpsilon, true);){
            if (source.channels() == 1) {
                opencv_imgproc.cvtColor((Mat)source, (Mat)source, (int)8);
            }
            opencv_imgproc.pyrMeanShiftFiltering((Mat)source, (Mat)result, (double)this.spatialRadius, (double)(this.colorRadius * OTools.maxPossibleValue(source)), (int)this.maxPyramidLevel, (TermCriteria)termCriteria);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UMat process(UMat source) {
        MeanShift.logDebug(() -> "MeanShift segmentation (GPU): spatialRadius = " + this.spatialRadius + ", colorRadius = " + this.colorRadius + " (source: " + source + ")");
        UMat result = new UMat();
        try (TermCriteria termCriteria = null;){
            if (this.terminationMaxCount != 0 || this.terminationEpsilon != 0.0) {
                int type = (this.terminationMaxCount != 0 ? 1 : 0) + (this.terminationEpsilon != 0.0 ? 2 : 0);
                termCriteria = new TermCriteria(type, this.terminationMaxCount, this.terminationEpsilon);
            }
            if (source.channels() == 1) {
                opencv_imgproc.cvtColor((UMat)source, (UMat)source, (int)8);
            }
            opencv_imgproc.pyrMeanShiftFiltering((UMat)source, (UMat)result, (double)this.spatialRadius, (double)(this.colorRadius * OTools.maxPossibleValue(source)), (int)this.maxPyramidLevel, (TermCriteria)termCriteria);
        }
        return result;
    }
}

