/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.OpenCVExecutor;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OBorderType;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

public final class FastEigenValues
extends OpenCVExecutor
implements ReadOnlyExecutionInput {
    private static final Scalar zeroScalar = new Scalar(0.0);
    private static final int RESULT_DEPTH = 5;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;
    private double scale = 1.0;

    public FastEigenValues() {
        this.useVisibleResultParameter();
        this.setDefaultInputMat(DEFAULT_INPUT_PORT);
        for (ResultValue resultValue : ResultValue.values()) {
            String portName = resultValue.valueName();
            this.addOutputMat(portName);
        }
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public FastEigenValues setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)FastEigenValues.nonNull((Object)((Object)borderType)));
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public FastEigenValues setScale(double scale) {
        this.scale = scale;
        return this;
    }

    public void process() {
        if (this.isUseGPU()) {
            this.hessian(O2SMat.toUMat(this.getInputMat()));
        } else {
            this.hessian(O2SMat.toMat(this.getInputMat()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hessian(Mat source) {
        this.setStartProcessingTimeStamp();
        int borderType = this.borderType.code();
        double multD = 0.5 * this.scale / OTools.maxPossibleValue(source);
        float multF = (float)multD;
        Mat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            try (FloatPointer p = new FloatPointer(new float[]{0.0f, -multF, 0.0f, multF, 0.0f, multF, 0.0f, -multF, 0.0f});
                 Mat kernel = new Mat(3, 3, 5, (Pointer)p);
                 Mat d2DxDy = new Mat();
                 Mat laplacian = new Mat();
                 Mat determinant = new Mat();){
                opencv_imgproc.Laplacian((Mat)mat, (Mat)laplacian, (int)5, (int)1, (double)multD, (double)0.0, (int)borderType);
                opencv_imgproc.Sobel((Mat)mat, (Mat)d2DxDy, (int)5, (int)1, (int)1, (int)1, (double)(0.5 * multD), (double)0.0, (int)borderType);
                opencv_imgproc.filter2D((Mat)mat, (Mat)determinant, (int)5, (Mat)kernel, null, (double)0.0, (int)borderType);
                opencv_core.magnitude((Mat)d2DxDy, (Mat)determinant, (Mat)determinant);
                for (ResultValue resultValue : ResultValue.values()) {
                    if (!this.isOutputNecessary(resultValue.valueName)) continue;
                    Mat result = new Mat();
                    resultValue.eigenValue(result, laplacian, determinant);
                    O2SMat.setTo(this.getMat(resultValue.valueName), result);
                }
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
        this.setEndProcessingTimeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hessian(UMat source) {
        this.setStartProcessingTimeStamp();
        int borderType = this.borderType.code();
        double multD = 0.5 * this.scale / OTools.maxPossibleValue(source);
        float multF = (float)multD;
        UMat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            try (FloatPointer p = new FloatPointer(new float[]{0.0f, -multF, 0.0f, multF, 0.0f, multF, 0.0f, -multF, 0.0f});
                 Mat k = new Mat(3, 3, 5, (Pointer)p);
                 UMat kernel = OTools.toUMat(k);
                 UMat d2DxDy = new UMat();
                 UMat laplacian = new UMat();
                 UMat determinant = new UMat();){
                opencv_imgproc.Laplacian((UMat)mat, (UMat)laplacian, (int)5, (int)1, (double)multD, (double)0.0, (int)borderType);
                opencv_imgproc.Sobel((UMat)mat, (UMat)d2DxDy, (int)5, (int)1, (int)1, (int)1, (double)(0.5 * multD), (double)0.0, (int)borderType);
                opencv_imgproc.filter2D((UMat)mat, (UMat)determinant, (int)5, (UMat)kernel, null, (double)0.0, (int)borderType);
                opencv_core.magnitude((UMat)d2DxDy, (UMat)determinant, (UMat)determinant);
                for (ResultValue resultValue : ResultValue.values()) {
                    if (!this.isOutputNecessary(resultValue.valueName)) continue;
                    UMat result = new UMat();
                    resultValue.eigenValue(result, laplacian, determinant);
                    O2SMat.setTo(this.getMat(resultValue.valueName), result);
                }
            }
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
        this.setEndProcessingTimeStamp();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ResultValue {
        LAMBDA_1("lambda1"){

            @Override
            void eigenValue(Mat result, Mat laplacian, Mat determinant) {
                opencv_core.add((Mat)laplacian, (Mat)determinant, (Mat)result);
            }

            @Override
            void eigenValue(UMat result, UMat laplacian, UMat determinant) {
                opencv_core.add((UMat)laplacian, (UMat)determinant, (UMat)result);
            }
        }
        ,
        LAMBDA_2("lambda2"){

            @Override
            void eigenValue(Mat result, Mat laplacian, Mat determinant) {
                opencv_core.subtract((Mat)laplacian, (Mat)determinant, (Mat)result);
            }

            @Override
            void eigenValue(UMat result, UMat laplacian, UMat determinant) {
                opencv_core.subtract((UMat)laplacian, (UMat)determinant, (UMat)result);
            }
        }
        ,
        LAMBDA_1_PLUS("lambda1_plus"){

            @Override
            void eigenValue(Mat result, Mat laplacian, Mat determinant) {
                LAMBDA_1.eigenValue(result, laplacian, determinant);
                try (Mat zero = new Mat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.max((Mat)result, (Mat)zero, (Mat)result);
                }
            }

            @Override
            void eigenValue(UMat result, UMat laplacian, UMat determinant) {
                LAMBDA_1.eigenValue(result, laplacian, determinant);
                try (UMat zero = new UMat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.max((UMat)result, (UMat)zero, (UMat)result);
                }
            }
        }
        ,
        LAMBDA_1_MINUS("lambda1_minus"){

            @Override
            void eigenValue(Mat result, Mat laplacian, Mat determinant) {
                LAMBDA_1.eigenValue(result, laplacian, determinant);
                try (Mat zero = new Mat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.min((Mat)result, (Mat)zero, (Mat)result);
                }
            }

            @Override
            void eigenValue(UMat result, UMat laplacian, UMat determinant) {
                LAMBDA_1.eigenValue(result, laplacian, determinant);
                try (UMat zero = new UMat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.min((UMat)result, (UMat)zero, (UMat)result);
                }
            }
        }
        ,
        LAMBDA_2_PLUS("lambda2_plus"){

            @Override
            void eigenValue(Mat result, Mat laplacian, Mat determinant) {
                LAMBDA_2.eigenValue(result, laplacian, determinant);
                try (Mat zero = new Mat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.max((Mat)result, (Mat)zero, (Mat)result);
                }
            }

            @Override
            void eigenValue(UMat result, UMat laplacian, UMat determinant) {
                LAMBDA_2.eigenValue(result, laplacian, determinant);
                try (UMat zero = new UMat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.max((UMat)result, (UMat)zero, (UMat)result);
                }
            }
        }
        ,
        LAMBDA_2_MINUS("lambda2_minus"){

            @Override
            void eigenValue(Mat result, Mat laplacian, Mat determinant) {
                LAMBDA_2.eigenValue(result, laplacian, determinant);
                try (Mat zero = new Mat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.min((Mat)result, (Mat)zero, (Mat)result);
                }
            }

            @Override
            void eigenValue(UMat result, UMat laplacian, UMat determinant) {
                LAMBDA_2.eigenValue(result, laplacian, determinant);
                try (UMat zero = new UMat(result.rows(), result.cols(), result.depth(), zeroScalar);){
                    opencv_core.min((UMat)result, (UMat)zero, (UMat)result);
                }
            }
        };

        private final String valueName;

        private ResultValue(String valueName) {
            this.valueName = valueName;
        }

        public String valueName() {
            return this.valueName;
        }

        abstract void eigenValue(Mat var1, Mat var2, Mat var3);

        abstract void eigenValue(UMat var1, UMat var2, UMat var3);
    }
}

