/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.matrices.filtering.AbstractFilterWithGuideImage;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class AdaptiveManifoldFilter
extends AbstractFilterWithGuideImage {
    private double sigmaS = 16.0;
    private double sigmaR = 0.2;
    private int treeHeight = -1;
    private int numPcaIterations = 1;
    private boolean adjustOutliers = false;
    private boolean useRNG = true;

    public double getSigmaS() {
        return this.sigmaS;
    }

    public void setSigmaS(double sigmaS) {
        this.sigmaS = AdaptiveManifoldFilter.nonNegative((double)sigmaS);
    }

    public double getSigmaR() {
        return this.sigmaR;
    }

    public void setSigmaR(double sigmaR) {
        this.sigmaR = AdaptiveManifoldFilter.nonNegative((double)sigmaR);
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    public void setTreeHeight(int treeHeight) {
        this.treeHeight = treeHeight;
    }

    public int getNumPcaIterations() {
        return this.numPcaIterations;
    }

    public void setNumPcaIterations(int numPcaIterations) {
        this.numPcaIterations = AdaptiveManifoldFilter.nonNegative((int)numPcaIterations);
    }

    public boolean isAdjustOutliers() {
        return this.adjustOutliers;
    }

    public void setAdjustOutliers(boolean adjustOutliers) {
        this.adjustOutliers = adjustOutliers;
    }

    public boolean isUseRNG() {
        return this.useRNG;
    }

    public void setUseRNG(boolean useRNG) {
        this.useRNG = useRNG;
    }

    @Override
    public void process(Mat result, Mat source, Mat guide) {
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.AdaptiveManifoldFilter filter = opencv_ximgproc.createAMFilter((double)this.sigmaS, (double)this.sigmaR, (boolean)this.adjustOutliers);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.setTreeHeight(this.treeHeight);
            filter.setPCAIterations(this.numPcaIterations);
            filter.setUseRNG(this.useRNG);
            filter.filter(source, result, guide);
        }
    }

    @Override
    public void process(UMat result, UMat source, UMat guide) {
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.AdaptiveManifoldFilter filter = opencv_ximgproc.createAMFilter((double)this.sigmaS, (double)this.sigmaR, (boolean)this.adjustOutliers);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.setTreeHeight(this.treeHeight);
            filter.setPCAIterations(this.numPcaIterations);
            filter.setUseRNG(this.useRNG);
            filter.filter(source, result, guide);
        }
    }
}

