/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePFixedArray;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.SwitchableBitMatrices;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.ConnectivityType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BoundaryType {
    MAIN_BOUNDARIES{

        @Override
        public Boundary2DScanner newScanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2, ConnectivityType connectivityType) {
            return Boundary2DScanner.getMainBoundariesScanner(matrix, buffer1, (ConnectivityType)connectivityType);
        }
    }
    ,
    ALL_BOUNDARIES,
    ALL_EXTERNAL_BOUNDARIES{

        @Override
        public boolean needToAnalyseThisBoundary(Boundary2DScanner scanner) {
            return scanner.side() == Boundary2DScanner.Side.X_MINUS;
        }

        @Override
        public boolean needToAnalyseThisBoundary(boolean isInternalBoundary) {
            return !isInternalBoundary;
        }

        @Override
        Func maskFunc(double labelsMaxValue) {
            return LinearFunc.getInstance((double)0.0, (double[])new double[]{labelsMaxValue});
        }
    }
    ,
    ALL_INTERNAL_BOUNDARIES{

        @Override
        public boolean needToAnalyseThisBoundary(Boundary2DScanner scanner) {
            return scanner.side() == Boundary2DScanner.Side.X_PLUS;
        }

        @Override
        public boolean needToAnalyseThisBoundary(boolean isInternalBoundary) {
            return isInternalBoundary;
        }

        @Override
        public boolean includesExternalBoundary() {
            return false;
        }

        @Override
        Func maskFunc(double labelsMaxValue) {
            return LinearFunc.getInstance((double)labelsMaxValue, (double[])new double[]{-labelsMaxValue});
        }
    };


    public boolean needToAnalyseThisBoundary(Boundary2DScanner scanner) {
        return true;
    }

    public boolean needToAnalyseThisBoundary(boolean isInternalBoundary) {
        return true;
    }

    public boolean includesExternalBoundary() {
        return true;
    }

    public final boolean supportsLabels() {
        return this != MAIN_BOUNDARIES;
    }

    public Boundary2DScanner newScanner(Matrix<? extends BitArray> matrix, Matrix<? extends UpdatablePFixedArray> buffer1, Matrix<? extends UpdatablePFixedArray> buffer2, ConnectivityType connectivityType) {
        return Boundary2DScanner.getAllBoundariesScanner(matrix, buffer1, buffer2, (ConnectivityType)connectivityType);
    }

    public final Boundary2DScanner newScanner(SwitchableBitMatrices switchable, ConnectivityType connectivityType) {
        return this.newScanner(switchable.bits(), switchable.buffer1(), switchable.buffer2(), connectivityType);
    }

    Matrix<? extends PArray> onlyActualLabels(Matrix<? extends PArray> labels, Matrix<? extends BitArray> objects) {
        Func maskFunc = this.maskFunc(((PArray)labels.array()).maxPossibleValue(1.0));
        if (maskFunc == null) {
            return labels;
        }
        Class type = labels.type(PArray.class);
        Matrix mask = Matrices.asFuncMatrix((Func)maskFunc, (Class)type, objects);
        return Matrices.asFuncMatrix((Func)Func.MIN, (Class)type, (Matrix)mask, labels);
    }

    Func maskFunc(double labelsMaxValue) {
        return null;
    }
}

