/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.Objects;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.PFixedArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryType;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.LabelsDrawer;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.SwitchableBitMatrices;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.multimatrix.MultiMatrix;

class BoundariesScanner {
    private static final int BACKGROUND = 0;
    private final ConnectivityType connectivityType;
    private final BoundaryType boundaryType;
    private final Matrix<? extends PFixedArray> objects;
    private final PFixedArray objectsArray;
    private final SwitchableBitMatrices switchable;
    private final boolean binary;
    private final Boundary2DScanner boundaryScanner;
    private final LabelsDrawer labelsDrawer;
    private final long maxLevelForLabelsDrawer;
    private boolean processBackgroundAsObject = false;
    private Boundary2DScanner boundaryMeasurer;
    private long sideCounter = 0L;
    private long objectCounter = 0L;
    private int currentLabel = 0;
    private boolean internalBoundary = false;

    BoundariesScanner(Matrix<? extends PFixedArray> objects, ConnectivityType connectivityType, BoundaryType boundaryType, boolean needSecondBuffer) {
        this(objects, connectivityType, boundaryType, needSecondBuffer, false, Long.MAX_VALUE);
    }

    BoundariesScanner(Matrix<? extends PFixedArray> objects, ConnectivityType connectivityType, BoundaryType boundaryType, boolean needSecondBufferForBinary, boolean needLabels, long maxLevelForLabelsDrawer) {
        this.objects = Objects.requireNonNull(objects);
        this.objectsArray = (PFixedArray)objects.array();
        if (maxLevelForLabelsDrawer != Long.MAX_VALUE) {
            needSecondBufferForBinary = true;
        }
        this.switchable = new SwitchableBitMatrices(objects, needSecondBufferForBinary);
        this.binary = this.switchable.isBinary();
        if (!this.binary && !boundaryType.supportsLabels()) {
            throw new IllegalArgumentException("The mode " + boundaryType + " is supported for binary matrices only");
        }
        this.connectivityType = Objects.requireNonNull(connectivityType);
        this.boundaryType = Objects.requireNonNull(boundaryType);
        this.boundaryMeasurer = this.boundaryScanner = this.binary ? boundaryType.newScanner(this.switchable, this.connectivityType) : Boundary2DScanner.getSingleBoundaryScanner(this.switchable.bits(), (ConnectivityType)connectivityType);
        this.labelsDrawer = needLabels ? new LabelsDrawer(this) : null;
        this.maxLevelForLabelsDrawer = maxLevelForLabelsDrawer;
    }

    public Boundary2DScanner getBoundaryScanner() {
        return this.boundaryScanner;
    }

    public Matrix<? extends PFixedArray> objects() {
        return this.objects;
    }

    public BoundaryType getBoundaryType() {
        return this.boundaryType;
    }

    public Boundary2DScanner getBoundaryMeasurer() {
        return this.boundaryMeasurer;
    }

    public void setBoundaryMeasurer(Boundary2DScanner measurer) {
        this.boundaryMeasurer = measurer;
    }

    public boolean isProcessBackgroundAsObject() {
        return this.processBackgroundAsObject;
    }

    public void setProcessBackgroundAsObject(boolean processBackgroundAsObject) {
        this.processBackgroundAsObject = processBackgroundAsObject;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public long sideCounter() {
        return this.sideCounter;
    }

    public long objectCounter() {
        return this.objectCounter;
    }

    public int currentLabel() {
        return this.currentLabel;
    }

    public boolean internalBoundary() {
        return this.internalBoundary;
    }

    public boolean nextBoundary() {
        return this.binary ? this.boundaryMeasurer.nextBoundary() : this.nextBoundaryForLabels();
    }

    public boolean needToAnalyseThisBoundary() {
        if (this.binary) {
            return this.boundaryType.needToAnalyseThisBoundary(this.boundaryScanner);
        }
        return (this.processBackgroundAsObject || this.currentLabel != 0) && this.boundaryType.needToAnalyseThisBoundary(this.boundaryScanner.orientedArea() < 0L);
    }

    public void scanAndProcess() {
        this.currentLabel = this.objectsArray.getInt(this.boundaryScanner.currentIndexInArray());
        if (this.binary) {
            this.scanBinary();
        } else {
            this.scanLabels();
        }
        this.sideCounter += this.boundaryMeasurer.stepCount();
        if (this.needToAnalyseThisBoundary()) {
            ++this.objectCounter;
        }
    }

    public Matrix<UpdatableBitArray> getMainBuffer() {
        return this.switchable.buffer1();
    }

    public Matrix<? extends PArray> getLabels() {
        if (this.labelsDrawer != null) {
            this.labelsDrawer.buildLabels();
            return this.binary ? this.boundaryType.onlyActualLabels(this.labelsDrawer.getLabels(), (Matrix<? extends BitArray>)this.boundaryScanner.matrix()) : this.labelsDrawer.getLabels();
        }
        return null;
    }

    public static Matrix<? extends PFixedArray> toObjects(MultiMatrix source, boolean binaryOnly) {
        BoundariesScanner.checkObjects(source, binaryOnly);
        if (binaryOnly) {
            return BitMultiMatrixFilter.toBit((Matrix)source.intensityChannel());
        }
        Matrix channel = Matrices.clone((Matrix)source.channel(0));
        assert (channel.array() instanceof PFixedArray);
        return channel.cast(PFixedArray.class);
    }

    public static void checkObjects(MultiMatrix matrix, boolean binaryOnly) {
        if (matrix.dimCount() != 2) {
            throw new IllegalArgumentException("Objects must be represented by 2-dimensional matrix (multidimensional matrices are not supported), but we have " + matrix);
        }
        if (matrix.dim(0) >= 0x3FFFFFFFL || matrix.dim(1) >= 0x3FFFFFFFL) {
            throw new TooLargeArrayException("Matrices with sizes > 1073741822 = 0x" + Integer.toHexString(0x3FFFFFFE) + " are not supported by boundaries scanner, but we have " + matrix);
        }
        if (!(binaryOnly || matrix.isMono() && !matrix.isFloatingPoint() && matrix.bitsPerElement() <= 32)) {
            throw new IllegalArgumentException("Objects must be represented by 1-channel integer matrix with <=32 bits/element, but we have " + matrix);
        }
    }

    private boolean needToDrawLabel() {
        if (this.binary) {
            return this.boundaryType.needToAnalyseThisBoundary(this.boundaryScanner);
        }
        return (this.processBackgroundAsObject || this.currentLabel != 0) && this.boundaryScanner.orientedArea() >= 0L == this.boundaryType.includesExternalBoundary();
    }

    private boolean nextBoundaryForLabels() {
        boolean bracket1;
        do {
            if (!this.nextSingleBoundaryForLabels()) {
                return false;
            }
            assert (this.boundaryScanner.side() == Boundary2DScanner.Side.X_MINUS);
        } while (bracket1 = ((UpdatableBitArray)this.switchable.buffer1().array()).getBit(this.boundaryScanner.currentIndexInArray()));
        return true;
    }

    private boolean nextSingleBoundaryForLabels() {
        PFixedArray array = (PFixedArray)this.switchable.objects().array();
        long dimX = this.switchable.objects().dimX();
        if (array.length() == 0L) {
            return false;
        }
        if (!this.boundaryScanner.isInitialized()) {
            this.boundaryMeasurer.goTo(0L, 0L, Boundary2DScanner.Side.X_MINUS);
            return true;
        }
        long index = this.boundaryScanner.currentIndexInArray();
        int currentLabel = this.objectsArray.getInt(index);
        ++index;
        long y = this.boundaryScanner.y();
        long x = this.boundaryScanner.x() + 1L;
        while (x < dimX) {
            if (this.objectsArray.getInt(index) != currentLabel) {
                this.boundaryMeasurer.goTo(x, y, Boundary2DScanner.Side.X_MINUS);
                return true;
            }
            ++x;
            ++index;
        }
        if (++y == this.switchable.objects().dimY()) {
            return false;
        }
        this.boundaryScanner.goTo(0L, y, Boundary2DScanner.Side.X_MINUS);
        return true;
    }

    private void scanBinary() {
        if (this.labelsDrawer != null && this.needToDrawLabel()) {
            this.internalBoundary = this.boundaryScanner.isInternalBoundary();
            do {
                this.boundaryMeasurer.next();
                if (this.boundaryScanner.nestingLevel() > this.maxLevelForLabelsDrawer) continue;
                this.labelsDrawer.drawBracket(this.objectCounter, this.internalBoundary);
            } while (!this.boundaryMeasurer.boundaryFinished());
        } else {
            do {
                this.boundaryMeasurer.next();
            } while (!this.boundaryMeasurer.boundaryFinished());
        }
    }

    private void scanLabels() {
        this.switchable.setCurrentLabel(this.currentLabel);
        if (this.labelsDrawer != null) {
            do {
                this.boundaryMeasurer.next();
                this.setHorizontalBracketForLabels();
            } while (!this.boundaryMeasurer.boundaryFinished());
            boolean bl = this.internalBoundary = this.boundaryMeasurer.orientedArea() < 0L;
            if (this.needToDrawLabel()) {
                this.boundaryScanner.resetCounters();
                do {
                    this.boundaryScanner.next();
                    this.labelsDrawer.drawBracket(this.objectCounter, this.internalBoundary);
                } while (!this.boundaryScanner.boundaryFinished());
            }
        } else {
            do {
                this.boundaryMeasurer.next();
                this.setHorizontalBracketForLabels();
            } while (!this.boundaryMeasurer.boundaryFinished());
            this.internalBoundary = this.boundaryMeasurer.orientedArea() < 0L;
        }
    }

    private void setHorizontalBracketForLabels() {
        if (this.boundaryScanner.side() == Boundary2DScanner.Side.X_MINUS) {
            this.switchable.setBuffer1Bit(this.boundaryScanner.currentIndexInArray());
        }
    }
}

