/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableFloatArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.components.ConnectedObjectScanningAlgorithm;
import net.algart.math.functions.DividingFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.functions.PowerFunc;
import net.algart.matrices.scanning.ConnectedObjectScanner;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class MeasureLabelledObjects
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_LABELS = "labels";
    public static final String INPUT_MASK = "mask";
    public static final String OUTPUT_NUMBER_OF_OBJECTS = "number_of_objects";
    private static final Map<String, ObjectParameter> OUTPUT_STATISTICS = new LinkedHashMap<String, ObjectParameter>();
    private boolean autoSplitBitInputIntoConnectedComponents = false;
    private double pixelSize = 1.0;
    private ConnectivityType bitInputConnectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;
    private BoundaryLineType boundaryLineType = BoundaryLineType.BOUNDARY_PIXELS;

    public MeasureLabelledObjects() {
        this.useVisibleResultParameter();
        this.setDefaultInputMat(INPUT_LABELS);
        this.setDefaultOutputNumbers(ObjectParameter.AREA.outputPort);
        this.addInputMat(INPUT_MASK);
        this.addOutputScalar(OUTPUT_NUMBER_OF_OBJECTS);
        for (ObjectParameter parameter : ObjectParameter.values()) {
            this.addOutputNumbers(parameter.outputPort);
        }
    }

    public boolean isAutoSplitBitInputIntoConnectedComponents() {
        return this.autoSplitBitInputIntoConnectedComponents;
    }

    public MeasureLabelledObjects setAutoSplitBitInputIntoConnectedComponents(boolean autoSplitBitInputIntoConnectedComponents) {
        this.autoSplitBitInputIntoConnectedComponents = autoSplitBitInputIntoConnectedComponents;
        return this;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public MeasureLabelledObjects setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
        return this;
    }

    public ConnectivityType getBitInputConnectivityType() {
        return this.bitInputConnectivityType;
    }

    public MeasureLabelledObjects setBitInputConnectivityType(ConnectivityType bitInputConnectivityType) {
        this.bitInputConnectivityType = (ConnectivityType)MeasureLabelledObjects.nonNull((Object)bitInputConnectivityType);
        return this;
    }

    public BoundaryLineType getBoundaryLineType() {
        return this.boundaryLineType;
    }

    public MeasureLabelledObjects setBoundaryLineType(BoundaryLineType boundaryLineType) {
        this.boundaryLineType = (BoundaryLineType)((Object)MeasureLabelledObjects.nonNull((Object)((Object)boundaryLineType)));
        return this;
    }

    public void process() {
        MultiMatrix2D labels = this.getInputMat(INPUT_LABELS, false).toMultiMatrix2D();
        MultiMatrix2D mask = this.getInputMat(INPUT_MASK, true).toMultiMatrix2D();
        Map<ObjectParameter, SNumbers> resultStatistics = MeasureLabelledObjects.convertMap(this.allOutputContainers(SNumbers.class, true));
        this.setStartProcessingTimeStamp();
        this.analyse(resultStatistics, labels, mask);
        this.setEndProcessingTimeStamp();
    }

    public void analyse(Map<ObjectParameter, SNumbers> results, MultiMatrix2D labels, MultiMatrix2D mask) {
        int x;
        int disp;
        Matrix maskMatrix;
        labels.checkDimensionEquality((MultiMatrix)mask, INPUT_LABELS, INPUT_MASK);
        Matrix matrix = maskMatrix = mask == null ? null : BitMultiMatrixFilter.toBit((Matrix)mask.intensityChannel());
        if (labels.elementType() == Boolean.TYPE && this.autoSplitBitInputIntoConnectedComponents) {
            this.analyseConnectedComponents(results, (Matrix<? extends BitArray>)labels.channel(0).cast(BitArray.class), (Matrix<? extends BitArray>)maskMatrix);
            return;
        }
        if (mask != null) {
            labels = labels.min(mask.nonZeroRGB());
        }
        int[] labelsArray = labels.channelToIntArray(0);
        int numberOfObjects = 0;
        for (int v : labelsArray) {
            if (v <= numberOfObjects) continue;
            numberOfObjects = v;
        }
        if (LOGGABLE_DEBUG) {
            MeasureLabelledObjects.logDebug((String)("Measuring " + numberOfObjects + " labelled objects of " + labels));
        }
        this.getScalar(OUTPUT_NUMBER_OF_OBJECTS).setTo(numberOfObjects);
        int[] cardinalities = null;
        if (results.containsKey((Object)ObjectParameter.AREA) || results.containsKey((Object)ObjectParameter.SQRT_AREA) || results.containsKey((Object)ObjectParameter.THICKNESS) || results.containsKey((Object)ObjectParameter.SHAPE_FACTOR) || results.containsKey((Object)ObjectParameter.CENTROID)) {
            MutableFloatArray result;
            cardinalities = new int[numberOfObjects];
            for (int v : labelsArray) {
                if (v <= 0) continue;
                int n = v - 1;
                cardinalities[n] = cardinalities[n] + 1;
            }
            if (results.containsKey((Object)ObjectParameter.AREA)) {
                result = Arrays.SMM.newFloatArray((long)cardinalities.length);
                Arrays.applyFunc(null, (Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{this.pixelSize * this.pixelSize}), (UpdatablePArray)result, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableIntArray((int[])cardinalities)});
                results.get((Object)ObjectParameter.AREA).setTo((PNumberArray)result, 1);
            }
            if (results.containsKey((Object)ObjectParameter.SQRT_AREA)) {
                result = Arrays.SMM.newFloatArray((long)cardinalities.length);
                Arrays.applyFunc(null, (Func)PowerFunc.getInstance((double)0.5, (double)this.pixelSize), (UpdatablePArray)result, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableIntArray((int[])cardinalities)});
                results.get((Object)ObjectParameter.SQRT_AREA).setTo((PNumberArray)result, 1);
            }
        }
        int dimX = (int)labels.dimX();
        int dimY = (int)labels.dimY();
        if (results.containsKey((Object)ObjectParameter.BOUNDARY) || results.containsKey((Object)ObjectParameter.THICKNESS) || results.containsKey((Object)ObjectParameter.SHAPE_FACTOR)) {
            int[] boundaries = new int[numberOfObjects];
            disp = 0;
            for (int y = 0; y < dimY; ++y) {
                x = 0;
                while (x < dimX) {
                    int label = labelsArray[disp];
                    if (label > 0) {
                        switch (this.boundaryLineType) {
                            case BOUNDARY_PIXELS: {
                                if (x != 0 && labelsArray[disp - 1] == label && x != dimX - 1 && labelsArray[disp + 1] == label && y != 0 && labelsArray[disp - dimX] == label && y != dimY - 1 && labelsArray[disp + dimX] == label) break;
                                int n = label - 1;
                                boundaries[n] = boundaries[n] + 1;
                                break;
                            }
                            case BOUNDARY_INTERPIXEL_SEGMENTS: {
                                int count = 0;
                                if (x == 0 || labelsArray[disp - 1] != label) {
                                    ++count;
                                }
                                if (x == dimX - 1 || labelsArray[disp + 1] != label) {
                                    ++count;
                                }
                                if (y == 0 || labelsArray[disp - dimX] != label) {
                                    ++count;
                                }
                                if (y == dimY - 1 || labelsArray[disp + dimX] != label) {
                                    ++count;
                                }
                                int n = label - 1;
                                boundaries[n] = boundaries[n] + count;
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unsupported boundary line type: " + this.boundaryLineType));
                            }
                        }
                    }
                    ++x;
                    ++disp;
                }
            }
            if (results.containsKey((Object)ObjectParameter.BOUNDARY)) {
                MutableFloatArray result = Arrays.SMM.newFloatArray((long)boundaries.length);
                Arrays.applyFunc(null, (Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{this.pixelSize}), (UpdatablePArray)result, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableIntArray((int[])boundaries)});
                results.get((Object)ObjectParameter.BOUNDARY).setTo((PNumberArray)result, 1);
            }
            if (results.containsKey((Object)ObjectParameter.THICKNESS)) {
                assert (cardinalities != null);
                MutableFloatArray result = Arrays.SMM.newFloatArray((long)boundaries.length);
                Arrays.applyFunc(null, (Func)DividingFunc.getInstance((double)(2.0 * this.pixelSize)), (UpdatablePArray)result, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableIntArray((int[])cardinalities), SimpleMemoryModel.asUpdatableIntArray((int[])boundaries)});
                results.get((Object)ObjectParameter.THICKNESS).setTo((PNumberArray)result, 1);
            }
            if (results.containsKey((Object)ObjectParameter.SHAPE_FACTOR)) {
                assert (cardinalities != null);
                MutableFloatArray result = Arrays.SMM.newFloatArray((long)boundaries.length);
                Arrays.applyFunc(null, (Func)DividingFunc.getInstance((double)(2.0 * StrictMath.sqrt(Math.PI))), (UpdatablePArray)result, (PArray[])new PArray[]{Arrays.asFuncArray((Func)PowerFunc.getInstance((double)0.5), DoubleArray.class, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableIntArray((int[])cardinalities)}), SimpleMemoryModel.asUpdatableIntArray((int[])boundaries)});
                results.get((Object)ObjectParameter.SHAPE_FACTOR).setTo((PNumberArray)result, 1);
            }
        }
        if (results.containsKey((Object)ObjectParameter.CENTROID)) {
            assert (cardinalities != null);
            if (2L * (long)numberOfObjects > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("numberOfObjects = " + numberOfObjects + " >= 2^31 / 2");
            }
            double[] centroids = new double[2 * numberOfObjects];
            disp = 0;
            for (int y = 0; y < dimY; ++y) {
                x = 0;
                while (x < dimX) {
                    int v = labelsArray[disp];
                    if (v > 0) {
                        int n = 2 * (v - 1);
                        centroids[n] = centroids[n] + (double)x;
                        int n2 = 2 * (v - 1) + 1;
                        centroids[n2] = centroids[n2] + (double)y;
                    }
                    ++x;
                    ++disp;
                }
            }
            for (int k = 0; k < numberOfObjects; ++k) {
                int n = 2 * k;
                centroids[n] = centroids[n] / (double)cardinalities[k];
                int n3 = 2 * k + 1;
                centroids[n3] = centroids[n3] / (double)cardinalities[k];
            }
            MutableFloatArray result = Arrays.SMM.newFloatArray((long)centroids.length);
            Arrays.applyFunc(null, (Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{this.pixelSize}), (UpdatablePArray)result, (PArray[])new PArray[]{SimpleMemoryModel.asUpdatableDoubleArray((double[])centroids)});
            results.get((Object)ObjectParameter.CENTROID).setTo((PNumberArray)result, 2);
        }
        if (results.containsKey((Object)ObjectParameter.CONTAINING_RECTANGLE)) {
            if (4L * (long)numberOfObjects > Integer.MAX_VALUE) {
                throw new TooLargeArrayException("numberOfObjects = " + numberOfObjects + " >= 2^31 / 4");
            }
            int[] minX = new int[numberOfObjects];
            int[] minY = new int[numberOfObjects];
            int[] maxX = new int[numberOfObjects];
            int[] maxY = new int[numberOfObjects];
            JArrays.fillIntArray((int[])minX, (int)Integer.MAX_VALUE);
            JArrays.fillIntArray((int[])minY, (int)Integer.MAX_VALUE);
            int disp2 = 0;
            for (int y = 0; y < dimY; ++y) {
                int x2 = 0;
                while (x2 < dimX) {
                    int v = labelsArray[disp2];
                    if (v > 0) {
                        minX[v - 1] = Math.min(minX[v - 1], x2);
                        minY[v - 1] = Math.min(minY[v - 1], y);
                        maxX[v - 1] = Math.max(maxX[v - 1], x2);
                        maxY[v - 1] = Math.max(maxY[v - 1], y);
                    }
                    ++x2;
                    ++disp2;
                }
            }
            float[] rectangles = new float[4 * numberOfObjects];
            for (int k = 0; k < numberOfObjects; ++k) {
                rectangles[4 * k] = (float)(0.5 * this.pixelSize * (double)(minX[k] + maxX[k]));
                rectangles[4 * k + 1] = (float)(0.5 * this.pixelSize * (double)(minY[k] + maxY[k]));
                rectangles[4 * k + 2] = (float)(this.pixelSize * (double)(maxX[k] - minX[k] + 1));
                rectangles[4 * k + 3] = (float)(this.pixelSize * (double)(maxY[k] - minY[k] + 1));
            }
            results.get((Object)ObjectParameter.CONTAINING_RECTANGLE).setTo(rectangles, 4);
        }
    }

    public void analyseConnectedComponents(Map<ObjectParameter, SNumbers> results, Matrix<? extends BitArray> source, Matrix<? extends BitArray> mask) {
        BoundariesAndCentroidAndRectangleCalculator calculator;
        if (mask != null) {
            source = Matrices.asFuncMatrix((Func)Func.MIN, BitArray.class, source, mask);
        }
        final Matrix objects = BitMultiMatrixFilter.cloneBit((Matrix)source.subMatrix(-1L, -1L, source.dimX() + 1L, source.dimY() + 1L, Matrix.ContinuationMode.getConstantMode((Object)0)));
        final UpdatableBitArray pixels = ((UpdatableBitArray)objects.array()).updatableClone((MemoryModel)Arrays.SMM);
        ConnectedObjectScanner scanner = ConnectedObjectScanningAlgorithm.QUICKEN.connectedObjectScanner((Matrix<? extends UpdatableBitArray>)objects, this.bitInputConnectivityType, false);
        MutableFloatArray areas = Arrays.SMM.newFloatArray(0L);
        MutableFloatArray sqrtAreas = results.containsKey((Object)ObjectParameter.SQRT_AREA) ? Arrays.SMM.newFloatArray(0L) : null;
        MutableFloatArray boundaries = results.containsKey((Object)ObjectParameter.BOUNDARY) ? Arrays.SMM.newFloatArray(0L) : null;
        MutableFloatArray thicknesses = results.containsKey((Object)ObjectParameter.THICKNESS) ? Arrays.SMM.newFloatArray(0L) : null;
        MutableFloatArray shapeFactors = results.containsKey((Object)ObjectParameter.SHAPE_FACTOR) ? Arrays.SMM.newFloatArray(0L) : null;
        MutableFloatArray centroids = results.containsKey((Object)ObjectParameter.CENTROID) ? Arrays.SMM.newFloatArray(0L) : null;
        MutableFloatArray rectangles = results.containsKey((Object)ObjectParameter.CONTAINING_RECTANGLE) ? Arrays.SMM.newFloatArray(0L) : null;
        final long dimX = objects.dimX();
        final long dimY = objects.dimY();
        long pixelCounter = 0L;
        long[] coordinates = new long[objects.dimCount()];
        class BoundariesAndCentroidAndRectangleCalculator
        implements ConnectedObjectScanner.ElementVisitor {
            final long[] coordinatesInMatrix;
            int minX;
            int minY;
            int maxX;
            int maxY;
            double sumX;
            double sumY;
            long countBoundary;

            BoundariesAndCentroidAndRectangleCalculator() {
                this.coordinatesInMatrix = new long[objects.dimCount()];
            }

            public void visit(long[] coordinatesInMatrix, long indexInArray) {
                if (coordinatesInMatrix == null) {
                    coordinatesInMatrix = objects.coordinates(indexInArray, this.coordinatesInMatrix);
                }
                int x = (int)coordinatesInMatrix[0] - 1;
                int y = (int)coordinatesInMatrix[1] - 1;
                this.minX = Math.min(this.minX, x);
                this.minY = Math.min(this.minY, y);
                this.maxX = Math.max(this.maxX, x);
                this.maxY = Math.max(this.maxY, y);
                this.sumX += (double)x;
                this.sumY += (double)y;
                switch (MeasureLabelledObjects.this.boundaryLineType) {
                    case BOUNDARY_PIXELS: {
                        if (x != 0 && pixels.getBit(indexInArray - 1L) && (long)x != dimX - 1L && pixels.getBit(indexInArray + 1L) && y != 0 && pixels.getBit(indexInArray - dimX) && (long)y != dimY - 1L && pixels.getBit(indexInArray + dimX)) break;
                        ++this.countBoundary;
                        break;
                    }
                    case BOUNDARY_INTERPIXEL_SEGMENTS: {
                        if (x == 0 || !pixels.getBit(indexInArray - 1L)) {
                            ++this.countBoundary;
                        }
                        if ((long)x == dimX - 1L || !pixels.getBit(indexInArray + 1L)) {
                            ++this.countBoundary;
                        }
                        if (y == 0 || !pixels.getBit(indexInArray - dimX)) {
                            ++this.countBoundary;
                        }
                        if ((long)y != dimY - 1L && pixels.getBit(indexInArray + dimX)) break;
                        ++this.countBoundary;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported boundary line type: " + MeasureLabelledObjects.this.boundaryLineType));
                    }
                }
            }

            public void init() {
                this.minX = Integer.MAX_VALUE;
                this.minY = Integer.MAX_VALUE;
                this.maxX = Integer.MIN_VALUE;
                this.maxY = Integer.MIN_VALUE;
                this.sumX = 0.0;
                this.sumY = 0.0;
                this.countBoundary = 0L;
            }
        }
        BoundariesAndCentroidAndRectangleCalculator boundariesAndCentroidAndRectangleCalculator = calculator = centroids != null || rectangles != null || boundaries != null || thicknesses != null || shapeFactors != null ? new BoundariesAndCentroidAndRectangleCalculator() : null;
        while (scanner.nextUnitBit(coordinates)) {
            if (calculator != null) {
                calculator.init();
            }
            long cardinality = scanner.clear(null, (ConnectedObjectScanner.ElementVisitor)calculator, coordinates, false);
            pixelCounter += cardinality;
            areas.pushFloat((float)((double)cardinality * (this.pixelSize * this.pixelSize)));
            if (sqrtAreas != null) {
                sqrtAreas.pushFloat((float)(Math.sqrt(cardinality) * this.pixelSize));
            }
            if (boundaries != null) {
                boundaries.pushFloat((float)((double)calculator.countBoundary * this.pixelSize));
            }
            if (thicknesses != null) {
                thicknesses.pushFloat((float)(2.0 * (double)cardinality * this.pixelSize / (double)calculator.countBoundary));
            }
            if (shapeFactors != null) {
                shapeFactors.pushFloat((float)(2.0 * Math.sqrt(Math.PI * (double)cardinality) / (double)calculator.countBoundary));
            }
            if (centroids != null) {
                centroids.pushFloat((float)(this.pixelSize * calculator.sumX / (double)cardinality));
                centroids.pushFloat((float)(this.pixelSize * calculator.sumY / (double)cardinality));
            }
            if (rectangles == null) continue;
            rectangles.pushFloat((float)(0.5 * this.pixelSize * (double)(calculator.minX + calculator.maxX)));
            rectangles.pushFloat((float)(0.5 * this.pixelSize * (double)(calculator.minY + calculator.maxY)));
            rectangles.pushFloat((float)(this.pixelSize * (double)(calculator.maxX - calculator.minX + 1)));
            rectangles.pushFloat((float)(this.pixelSize * (double)(calculator.maxY - calculator.minY + 1)));
        }
        this.getScalar(OUTPUT_NUMBER_OF_OBJECTS).setTo(areas.length());
        if (LOGGABLE_DEBUG) {
            MeasureLabelledObjects.logDebug((String)("Measuring " + areas.length() + " connected components  (" + pixelCounter + " pixels) at " + source));
        }
        results.computeIfAbsent(ObjectParameter.AREA, k -> new SNumbers()).setTo((PNumberArray)areas, 1);
        if (sqrtAreas != null) {
            results.get((Object)ObjectParameter.SQRT_AREA).setTo((PNumberArray)sqrtAreas, 1);
        }
        if (boundaries != null) {
            results.get((Object)ObjectParameter.BOUNDARY).setTo((PNumberArray)boundaries, 1);
        }
        if (thicknesses != null) {
            results.get((Object)ObjectParameter.THICKNESS).setTo((PNumberArray)thicknesses, 1);
        }
        if (shapeFactors != null) {
            results.get((Object)ObjectParameter.SHAPE_FACTOR).setTo((PNumberArray)shapeFactors, 1);
        }
        if (centroids != null) {
            results.get((Object)ObjectParameter.CENTROID).setTo((PNumberArray)centroids, 2);
        }
        if (rectangles != null) {
            results.get((Object)ObjectParameter.CONTAINING_RECTANGLE).setTo((PNumberArray)rectangles, 4);
        }
    }

    public static Map<ObjectParameter, SNumbers> convertMap(Map<String, SNumbers> statistics) {
        LinkedHashMap<ObjectParameter, SNumbers> result = new LinkedHashMap<ObjectParameter, SNumbers>();
        statistics.forEach((s, numbers) -> result.put(OUTPUT_STATISTICS.get(s), (SNumbers)numbers));
        return result;
    }

    static {
        for (ObjectParameter parameter : ObjectParameter.values()) {
            OUTPUT_STATISTICS.put(parameter.outputPort, parameter);
        }
    }

    public static enum BoundaryLineType {
        BOUNDARY_PIXELS,
        BOUNDARY_INTERPIXEL_SEGMENTS;

    }

    public static enum ObjectParameter {
        AREA("area"),
        SQRT_AREA("sqrt_area"),
        BOUNDARY("boundary"),
        THICKNESS("thickness"),
        SHAPE_FACTOR("shape_factor"),
        CENTROID("centroid"),
        CONTAINING_RECTANGLE("containing_rectangle");

        final String outputPort;

        private ObjectParameter(String outputPort) {
            this.outputPort = outputPort;
        }

        public String outputPort() {
            return this.outputPort;
        }
    }
}

