/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.cv.matrices.morphology.RankMorphologyFilter;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;

public final class PercentileRank
extends RankMorphologyFilter {
    private ResultInterpretation resultInterpretation = ResultInterpretation.NORMALIZED_0_1;

    public ResultInterpretation getResultInterpretation() {
        return this.resultInterpretation;
    }

    public void setResultInterpretation(ResultInterpretation resultInterpretation) {
        this.resultInterpretation = (ResultInterpretation)((Object)PercentileRank.nonNull((Object)((Object)resultInterpretation)));
    }

    @Override
    protected Matrix<? extends PArray> processCompressedChannel(Matrix<? extends PArray> m) {
        Pattern pattern = this.getPattern(m);
        if (this.currentChannel() == 0) {
            PercentileRank.logDebug(() -> "Percentile rank (" + (this.resultInterpretation == ResultInterpretation.ABSOLUTE_INDEX ? "31-bit index)" : "normalized float)") + this.rankMorphologyLogMessage() + " with " + pattern + (String)(this.continuationMode == null ? "" : ", " + this.continuationMode) + " for " + this.sourceMultiMatrix());
        }
        Matrix rank = this.createRankMorphology(m.elementType(), 1.0).rank(IntArray.class, m, m, pattern);
        switch (this.resultInterpretation) {
            case ABSOLUTE_INDEX: {
                return rank;
            }
            case NORMALIZED_0_1: {
                return Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{1.0 / (double)pattern.pointCount()}), FloatArray.class, (Matrix)rank);
            }
        }
        throw new AssertionError((Object)"Unknown resultInterpretation");
    }

    public static enum ResultInterpretation {
        ABSOLUTE_INDEX,
        NORMALIZED_0_1;

    }
}

