/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.arrays.PIntegerArray;
import net.algart.math.IPoint;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Point;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;
import net.algart.math.patterns.DirectPointSetPattern;
import net.algart.math.patterns.HyperboloidOfRevolutionFunc;
import net.algart.math.patterns.ParaboloidOfRevolutionFunc;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.RectangularPattern;
import net.algart.math.patterns.SimplePattern;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.math.patterns.UpperHalfEllipsoidOfRevolutionFunc;

public final class PatternSpecificationParser {
    private static final System.Logger LOG = System.getLogger(PatternSpecificationParser.class.getName());
    private static final Map<Class<?>, PatternSpecificationParser> INSTANCES = new HashMap();
    private final Class<?> elementType;
    private final Map<String, Reference<Pattern>> patternCache = new HashMap<String, Reference<Pattern>>();

    private PatternSpecificationParser(Class<?> elementType) {
        this.elementType = elementType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PatternSpecificationParser getInstance(Class<?> elementType) {
        Map<Class<?>, PatternSpecificationParser> map = INSTANCES;
        synchronized (map) {
            PatternSpecificationParser result = INSTANCES.get(elementType);
            if (result == null) {
                result = new PatternSpecificationParser(elementType);
                INSTANCES.put(elementType, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern parse(String s) {
        UniformGridPattern ugResult;
        boolean bounds;
        boolean surface;
        boolean slow;
        boolean raw;
        if (!PatternSpecificationParser.isSurelyLowCase(s = s.trim())) {
            s = s.toLowerCase();
        }
        Pattern result = null;
        Map<String, Reference<Pattern>> map = this.patternCache;
        synchronized (map) {
            Reference<Pattern> ref = this.patternCache.get(s);
            if (ref != null) {
                result = ref.get();
            }
            if (result != null) {
                return result;
            }
            this.patternCache.entrySet().removeIf(entry -> ((Reference)entry.getValue()).get() == null);
        }
        Class arrayType = net.algart.arrays.Arrays.type(PArray.class, this.elementType);
        boolean integerType = PIntegerArray.class.isAssignableFrom(arrayType) && this.elementType != Long.TYPE;
        double zScale = net.algart.arrays.Arrays.maxPossibleValue((Class)arrayType, (double)1.0);
        try {
            Pattern matrix01;
            raw = s.endsWith(" -raw");
            if (raw) {
                s = s.substring(0, s.length() - " -raw".length());
            }
            if (slow = s.endsWith(" -slow")) {
                s = s.substring(0, s.length() - " -slow".length());
            }
            if (surface = s.startsWith("bound ")) {
                s = s.substring("bound ".length());
            }
            if (bounds = s.startsWith("ext-bound ")) {
                s = s.substring("ext-bound ".length());
            }
            if ((matrix01 = PatternSpecificationParser.parseBinaryMatrix2D(s)) != null) {
                result = matrix01;
            } else {
                String[] elements = s.split("(\\b|\\s)mult(\\b|\\s)");
                if (elements.length == 2) {
                    double mult = Double.parseDouble(elements[0].trim());
                    result = this.parse(elements[1]).multiply(mult);
                } else {
                    elements = s.split("(\\b|\\s)scale(\\b|\\s)");
                    if (elements.length == 2) {
                        String[] params = elements[0].split("[, ]+");
                        double mX = Double.parseDouble(params[0].trim());
                        double mY = Double.parseDouble(params[1].trim());
                        result = this.parse(elements[1]).scale(new double[]{mX, mY});
                    } else {
                        elements = s.split("\\s\\\\-\\s");
                        if (elements.length == 2) {
                            Pattern ptn2;
                            Pattern ptn1 = this.parse(elements[0]);
                            result = ptn1.minkowskiSubtract(ptn2 = this.parse(elements[1]));
                            result = result == null ? ptn1 : PatternSpecificationParser.subtract(ptn1, result);
                        } else {
                            elements = s.split("(\\b|\\s)\\\\(\\b|\\s)");
                            if (elements.length == 2) {
                                Pattern ptn1 = this.parse(elements[0]);
                                Pattern ptn2 = this.parse(elements[1]);
                                result = PatternSpecificationParser.subtract(ptn1, ptn2);
                            } else {
                                elements = s.split("(\\b|\\s)u(\\b|\\s)");
                                if (elements.length > 1) {
                                    Pattern[] patterns = new Pattern[elements.length];
                                    for (int k = 0; k < patterns.length; ++k) {
                                        patterns[k] = this.parse(elements[k]);
                                    }
                                    result = Patterns.newUnion((Pattern[])patterns);
                                } else {
                                    elements = s.split("\\+");
                                    if (elements.length > 1) {
                                        Pattern[] patterns = new Pattern[elements.length];
                                        for (int k = 0; k < patterns.length; ++k) {
                                            patterns[k] = this.parse(elements[k]);
                                        }
                                        result = Patterns.newMinkowskiSum((Pattern[])patterns);
                                    } else {
                                        elements = s.split("\\s-\\s");
                                        if (elements.length == 2) {
                                            Pattern ptn2;
                                            Pattern ptn1 = this.parse(elements[0]);
                                            result = ptn1.minkowskiSubtract(ptn2 = this.parse(elements[1]));
                                            if (result == null) {
                                                throw new IllegalArgumentException("Empty pattern erosion");
                                            }
                                        } else {
                                            elements = s.split("(\\b|\\s)x(\\b|\\s)");
                                            if (elements.length == 2) {
                                                double mult = Double.parseDouble(elements[0].trim());
                                                if (mult < 0.0) {
                                                    throw new IllegalArgumentException("Negative multiplier");
                                                }
                                                Pattern ptn = this.parse(elements[1]);
                                                double frac = mult - (double)((int)mult);
                                                UniformGridPattern ptnFrac = ptn.multiply(frac).round();
                                                if ((int)mult > 0) {
                                                    result = Patterns.newMinkowskiMultiplePattern((Pattern)ptn, (int)((int)mult));
                                                    if (frac > 0.0) {
                                                        result = Patterns.newMinkowskiSum((Pattern[])new Pattern[]{result, ptnFrac});
                                                    }
                                                } else {
                                                    result = ptnFrac;
                                                }
                                            } else {
                                                elements = s.split("(\\b|\\s)\\*(\\b|\\s)");
                                                if (elements.length == 2) {
                                                    double mult = Double.parseDouble(elements[0].trim());
                                                    result = this.parse(elements[1]).multiply(mult);
                                                } else {
                                                    elements = s.split("(\\b|\\s)>>(\\b|\\s)");
                                                    if (elements.length == 2) {
                                                        String[] params = elements[1].split("[, ]+");
                                                        double x = Double.parseDouble(params[0].trim());
                                                        double y = Double.parseDouble(params[1].trim());
                                                        result = this.parse(elements[0]).shift(Point.valueOf((double)x, (double)y));
                                                    } else if (s.startsWith("circle ")) {
                                                        String[] params = s.substring("circle ".length()).split("[, ]+");
                                                        double d = Double.parseDouble(params[0].trim());
                                                        if (d > 10000.0) {
                                                            throw new IllegalArgumentException("Too large diameter: " + d + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        if (params.length >= 3) {
                                                            x = Double.parseDouble(params[1].trim());
                                                            y = Double.parseDouble(params[2].trim());
                                                        }
                                                        result = Patterns.newSphereIntegerPattern((Point)Point.valueOf((double)0.0, (double)0.0), (double)(0.5 * d)).shift(Point.valueOf((double)x, (double)y));
                                                    } else if (s.startsWith("ring ")) {
                                                        String[] params = s.substring("ring ".length()).split("[, ]+");
                                                        double d = Double.parseDouble(params[0].trim());
                                                        double th = Double.parseDouble(params[1].trim());
                                                        if (d > 10000.0) {
                                                            throw new IllegalArgumentException("Too large diameter: " + d + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        if (th >= 0.5 * d) {
                                                            throw new IllegalArgumentException("Too large thickness: must be less than d/2");
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        if (params.length >= 4) {
                                                            x = Double.parseDouble(params[2].trim());
                                                            y = Double.parseDouble(params[3].trim());
                                                        }
                                                        UniformGridPattern larger = Patterns.newSphereIntegerPattern((Point)Point.valueOf((double)x, (double)y), (double)(0.5 * d));
                                                        UniformGridPattern smaller = Patterns.newSphereIntegerPattern((Point)Point.valueOf((double)x, (double)y), (double)(0.5 * d - th));
                                                        HashSet points = new HashSet(larger.roundedPoints());
                                                        points.removeAll(smaller.roundedPoints());
                                                        points.addAll(larger.surface().roundedPoints());
                                                        result = Patterns.newIntegerPattern(points);
                                                    } else if (s.startsWith("ellipse ")) {
                                                        double x;
                                                        double y;
                                                        String[] params = s.substring("ellipse ".length()).split("[, ]+");
                                                        double a = Double.parseDouble(params[0].trim());
                                                        if (a > 10000.0) {
                                                            throw new IllegalArgumentException("Too large first diameter: " + a + " (maximal possible value is 10000)");
                                                        }
                                                        double b = Double.parseDouble(params[1].trim());
                                                        if (b > 10000.0) {
                                                            throw new IllegalArgumentException("Too large second diameter: " + b + " (maximal possible value is 10000)");
                                                        }
                                                        if (a <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative first diameter: " + a);
                                                        }
                                                        if (b <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative second diameter: " + b);
                                                        }
                                                        double fi = Math.toRadians(Double.parseDouble(params[2].trim()));
                                                        if (params.length < 5) {
                                                            y = 0.0;
                                                            x = 0.0;
                                                        } else {
                                                            x = Double.parseDouble(params[3].trim());
                                                            y = Double.parseDouble(params[4].trim());
                                                        }
                                                        if (fi == 0.0) {
                                                            result = Patterns.newEllipsoidIntegerPattern((Point)Point.origin((int)2), (double[])new double[]{0.5 * a, 0.5 * b}).shift(Point.valueOf((double)x, (double)y));
                                                        } else {
                                                            if (a < b) {
                                                                double temp = a;
                                                                a = b;
                                                                b = temp;
                                                                fi += 1.5707963267948966;
                                                            }
                                                            HashSet points = new HashSet();
                                                            double mult = b / a;
                                                            double r = 0.5 * b;
                                                            Point e = Point.valueOf((double)Math.cos(fi), (double)Math.sin(fi));
                                                            int ir = (int)a + 2;
                                                            int xMin = (int)x - ir;
                                                            int xMax = (int)x + ir;
                                                            int yMin = (int)y - ir;
                                                            int yMax = (int)y + ir;
                                                            Thread[] threads = new Thread[Arrays.SystemSettings.cpuCount()];
                                                            for (int k = 0; k < threads.length; ++k) {
                                                                int threadIndex = k;
                                                                threads[k] = new Thread(() -> {
                                                                    HashSet<IPoint> threadPoints = new HashSet<IPoint>();
                                                                    for (int iy = yMin; iy <= yMax; ++iy) {
                                                                        if ((iy - yMin) % threads.length != threadIndex) continue;
                                                                        for (int ix = xMin; ix <= xMax; ++ix) {
                                                                            Point p = Point.valueOf((double)((double)ix - x), (double)((double)iy - y));
                                                                            double pe = p.scalarProduct(e);
                                                                            if (!((p = p.add(e.multiply(pe * (mult - 1.0)))).distanceFromOrigin() <= r)) continue;
                                                                            threadPoints.add(IPoint.valueOf((long)ix, (long)iy));
                                                                        }
                                                                    }
                                                                    Thread[] threadArray = threads;
                                                                    synchronized (threads) {
                                                                        points.addAll(threadPoints);
                                                                        // ** MonitorExit[var17_14] (shouldn't be in output)
                                                                        return;
                                                                    }
                                                                });
                                                                threads[k].start();
                                                            }
                                                            for (Thread thread : threads) {
                                                                thread.join();
                                                            }
                                                            result = Patterns.newIntegerPattern(points);
                                                        }
                                                    } else if (s.startsWith("rect ")) {
                                                        long width;
                                                        String[] params = s.substring("rect ".length()).split("[, ]+");
                                                        long height = width = Long.parseLong(params[0].trim());
                                                        if (params.length >= 2) {
                                                            height = Long.parseLong(params[1].trim());
                                                        }
                                                        long x = -width / 2L;
                                                        long y = -height / 2L;
                                                        if (params.length >= 4) {
                                                            x += Long.parseLong(params[2].trim());
                                                            y += Long.parseLong(params[3].trim());
                                                        }
                                                        result = Patterns.newRectangularIntegerPattern((IRange[])new IRange[]{IRange.valueOf((long)x, (long)(x + width - 1L)), IRange.valueOf((long)y, (long)(y + height - 1L))});
                                                    } else if (s.startsWith("square ")) {
                                                        String[] params = s.substring("square ".length()).split("[, ]+");
                                                        long size = Long.parseLong(params[0].trim());
                                                        long x = -size / 2L;
                                                        long y = -size / 2L;
                                                        if (params.length >= 3) {
                                                            x += Long.parseLong(params[1].trim());
                                                            y += Long.parseLong(params[2].trim());
                                                        }
                                                        result = Patterns.newRectangularIntegerPattern((IRange[])new IRange[]{IRange.valueOf((long)x, (long)(x + size - 1L)), IRange.valueOf((long)y, (long)(y + size - 1L))});
                                                    } else if (s.startsWith("octagon ")) {
                                                        String[] params = s.substring("octagon ".length()).split("[, ]+");
                                                        double d = Double.parseDouble(params[0].trim());
                                                        if (d > 100000.0) {
                                                            throw new IllegalArgumentException("Too large diameter: " + d + " (maximal possible value is 100000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        long x = 0L;
                                                        long y = 0L;
                                                        if (params.length >= 3) {
                                                            x = Long.parseLong(params[1].trim());
                                                            y = Long.parseLong(params[2].trim());
                                                        }
                                                        int rectSize = (int)Math.round(d);
                                                        int diagSize = (int)(d / (Math.sqrt(2.0) + 2.0));
                                                        int nAxis = Math.max(1, diagSize < 1 ? rectSize : Math.max(1, rectSize - 2 * diagSize));
                                                        IRange axisRange = IRange.valueOf((long)(-nAxis / 2), (long)(-nAxis / 2 + nAxis - 1));
                                                        result = Patterns.newRectangularIntegerPattern((IRange[])new IRange[]{axisRange, axisRange});
                                                        if (diagSize >= 1) {
                                                            Pattern diagonal = Patterns.newMinkowskiSum((Pattern[])new Pattern[]{PatternSpecificationParser.getSeries(0L, 0L, 1L, 1L, diagSize + 1), PatternSpecificationParser.getSeries(0L, 0L, 1L, -1L, diagSize + 1)});
                                                            IRange xr = diagonal.roundedCoordRange(0);
                                                            IRange yr = diagonal.roundedCoordRange(1);
                                                            diagonal = diagonal.shift(Point.valueOf((double)(-(xr.min() + xr.max()) / 2L), (double)(-(yr.min() + yr.max()) / 2L)));
                                                            result = nAxis == 1 ? Patterns.newUnion((Pattern[])new Pattern[]{result, diagonal}) : Patterns.newMinkowskiSum((Pattern[])new Pattern[]{result, diagonal});
                                                        }
                                                        result = result.shift(Point.valueOf((double)x, (double)y));
                                                    } else if (s.equals("cross")) {
                                                        result = Patterns.newIntegerPattern((IPoint[])new IPoint[]{IPoint.valueOf((long)0L, (long)0L), IPoint.valueOf((long)1L, (long)0L), IPoint.valueOf((long)0L, (long)1L), IPoint.valueOf((long)-1L, (long)0L), IPoint.valueOf((long)0L, (long)-1L)});
                                                    } else if (s.startsWith("sphere-surface ")) {
                                                        String[] params = s.substring("sphere-surface ".length()).split("[, ]+");
                                                        double dCircle = Double.parseDouble(params[0].trim());
                                                        double d = Double.parseDouble(params[1].trim());
                                                        double zD = Double.parseDouble(params[2].trim()) * zScale;
                                                        if (dCircle > 10000.0) {
                                                            throw new IllegalArgumentException("Too large circle diameter: " + dCircle + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        if (dCircle > d) {
                                                            throw new IllegalArgumentException("Circle diameter is greater than sphere diameter");
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        double z = 0.0;
                                                        if (params.length >= 5) {
                                                            x = Double.parseDouble(params[3].trim());
                                                            y = Double.parseDouble(params[4].trim());
                                                        }
                                                        if (params.length >= 6) {
                                                            z = Double.parseDouble(params[5].trim()) * zScale;
                                                        }
                                                        UniformGridPattern projection = Patterns.newSphereIntegerPattern((Point)Point.origin((int)2), (double)(0.5 * dCircle));
                                                        UpperHalfEllipsoidOfRevolutionFunc surf = UpperHalfEllipsoidOfRevolutionFunc.getInstance((double)(0.5 * d), (double)(0.5 * zD), (double)0.0);
                                                        result = Patterns.newSurface((Pattern)projection, (Func)surf).shift(Point.valueOf((double)x, (double)y, (double)z));
                                                        if (integerType) {
                                                            result = result.round();
                                                        }
                                                    } else if (s.startsWith("sphere ")) {
                                                        String[] params = s.substring("sphere ".length()).split("[, ]+");
                                                        double dCircle = Double.parseDouble(params[0].trim());
                                                        double d = Double.parseDouble(params[1].trim());
                                                        double zD = Double.parseDouble(params[2].trim()) * zScale;
                                                        double zStep = Double.parseDouble(params[3].trim()) * zScale;
                                                        if (integerType) {
                                                            zStep = Math.ceil(zStep);
                                                        }
                                                        if (dCircle > 10000.0) {
                                                            throw new IllegalArgumentException("Too large circle diameter: " + dCircle + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        if (dCircle > d) {
                                                            throw new IllegalArgumentException("Circle diameter is greater than sphere diameter");
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        double z = 0.0;
                                                        if (params.length >= 6) {
                                                            x = Double.parseDouble(params[4].trim());
                                                            y = Double.parseDouble(params[5].trim());
                                                        }
                                                        if (params.length >= 7) {
                                                            z = Double.parseDouble(params[6].trim()) * zScale;
                                                            if (integerType) {
                                                                z = Math.round(z);
                                                            }
                                                        }
                                                        UniformGridPattern projection = Patterns.newSphereIntegerPattern((Point)Point.origin((int)2), (double)(0.5 * dCircle));
                                                        UpperHalfEllipsoidOfRevolutionFunc surf = UpperHalfEllipsoidOfRevolutionFunc.getInstance((double)(0.5 * d), (double)(0.5 * zD), (double)0.0);
                                                        result = Patterns.newSpaceSegment((UniformGridPattern)projection, (Func)ConstantFunc.getInstance((double)surf.get(0.5 * dCircle, 0.0)), (Func)surf, (double)0.0, (double)zStep).shift(Point.valueOf((double)x, (double)y, (double)z));
                                                    } else if (s.startsWith("hyperboloid-surface ")) {
                                                        String[] params = s.substring("hyperboloid-surface ".length()).split("[, ]+");
                                                        double dCircle = Double.parseDouble(params[0].trim());
                                                        double d = Double.parseDouble(params[1].trim());
                                                        double zAxis = Double.parseDouble(params[2].trim()) * zScale;
                                                        if (dCircle > 10000.0) {
                                                            throw new IllegalArgumentException("Too large circle diameter: " + dCircle + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        double z = 0.0;
                                                        if (params.length >= 5) {
                                                            x = Double.parseDouble(params[3].trim());
                                                            y = Double.parseDouble(params[4].trim());
                                                        }
                                                        if (params.length >= 6) {
                                                            z = Double.parseDouble(params[5].trim()) * zScale;
                                                        }
                                                        UniformGridPattern projection = Patterns.newSphereIntegerPattern((Point)Point.origin((int)2), (double)(0.5 * dCircle));
                                                        HyperboloidOfRevolutionFunc surf = HyperboloidOfRevolutionFunc.getLowerInstance((double)(0.5 * d), (double)(0.5 * zAxis), (double)0.0);
                                                        result = Patterns.newSurface((Pattern)projection, (Func)surf).shift(Point.valueOf((double)x, (double)y, (double)z));
                                                        if (integerType) {
                                                            result = result.round();
                                                        }
                                                    } else if (s.startsWith("hyperboloid ")) {
                                                        String[] params = s.substring("hyperboloid ".length()).split("[, ]+");
                                                        double dCircle = Double.parseDouble(params[0].trim());
                                                        double d = Double.parseDouble(params[1].trim());
                                                        double zAxis = Double.parseDouble(params[2].trim()) * zScale;
                                                        double zStep = Double.parseDouble(params[3].trim()) * zScale;
                                                        if (integerType) {
                                                            zStep = Math.ceil(zStep);
                                                        }
                                                        if (dCircle > 10000.0) {
                                                            throw new IllegalArgumentException("Too large circle diameter: " + dCircle + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        double z = 0.0;
                                                        if (params.length >= 6) {
                                                            x = Double.parseDouble(params[4].trim());
                                                            y = Double.parseDouble(params[5].trim());
                                                        }
                                                        if (params.length >= 7) {
                                                            z = Double.parseDouble(params[6].trim()) * zScale;
                                                            if (integerType) {
                                                                z = Math.round(z);
                                                            }
                                                        }
                                                        UniformGridPattern projection = Patterns.newSphereIntegerPattern((Point)Point.origin((int)2), (double)(0.5 * dCircle));
                                                        HyperboloidOfRevolutionFunc surf = HyperboloidOfRevolutionFunc.getLowerInstance((double)(0.5 * d), (double)(0.5 * zAxis), (double)0.0);
                                                        result = Patterns.newSpaceSegment((UniformGridPattern)projection, (Func)ConstantFunc.getInstance((double)surf.get(0.5 * dCircle, 0.0)), (Func)surf, (double)0.0, (double)zStep).shift(Point.valueOf((double)x, (double)y, (double)z));
                                                    } else if (s.startsWith("paraboloid-surface ")) {
                                                        String[] params = s.substring("paraboloid-surface ".length()).split("[, ]+");
                                                        double dCircle = Double.parseDouble(params[0].trim());
                                                        double d = Double.parseDouble(params[1].trim());
                                                        double zAxis = Double.parseDouble(params[2].trim()) * zScale;
                                                        if (dCircle > 10000.0) {
                                                            throw new IllegalArgumentException("Too large circle diameter: " + dCircle + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        double z = 0.0;
                                                        if (params.length >= 5) {
                                                            x = Double.parseDouble(params[3].trim());
                                                            y = Double.parseDouble(params[4].trim());
                                                        }
                                                        if (params.length >= 6) {
                                                            z = Double.parseDouble(params[5].trim()) * zScale;
                                                        }
                                                        UniformGridPattern projection = Patterns.newSphereIntegerPattern((Point)Point.origin((int)2), (double)(0.5 * dCircle));
                                                        ParaboloidOfRevolutionFunc surf = ParaboloidOfRevolutionFunc.getInstance((double)(-zAxis / (0.5 * d * d)), (double)0.0);
                                                        result = Patterns.newSurface((Pattern)projection, (Func)surf).shift(Point.valueOf((double)x, (double)y, (double)z));
                                                        if (integerType) {
                                                            result = result.round();
                                                        }
                                                    } else if (s.startsWith("paraboloid ")) {
                                                        String[] params = s.substring("paraboloid ".length()).split("[, ]+");
                                                        double dCircle = Double.parseDouble(params[0].trim());
                                                        double d = Double.parseDouble(params[1].trim());
                                                        double zAxis = Double.parseDouble(params[2].trim()) * zScale;
                                                        double zStep = Double.parseDouble(params[3].trim()) * zScale;
                                                        if (integerType) {
                                                            zStep = Math.ceil(zStep);
                                                        }
                                                        if (dCircle > 10000.0) {
                                                            throw new IllegalArgumentException("Too large circle diameter: " + dCircle + " (maximal possible value is 10000)");
                                                        }
                                                        if (d <= 0.0) {
                                                            throw new IllegalArgumentException("Zero or negative diameter: " + d);
                                                        }
                                                        double x = 0.0;
                                                        double y = 0.0;
                                                        double z = 0.0;
                                                        if (params.length >= 6) {
                                                            x = Double.parseDouble(params[4].trim());
                                                            y = Double.parseDouble(params[5].trim());
                                                        }
                                                        if (params.length >= 7) {
                                                            z = Double.parseDouble(params[6].trim()) * zScale;
                                                            if (integerType) {
                                                                z = Math.round(z);
                                                            }
                                                        }
                                                        UniformGridPattern projection = Patterns.newSphereIntegerPattern((Point)Point.origin((int)2), (double)(0.5 * dCircle));
                                                        ParaboloidOfRevolutionFunc surf = ParaboloidOfRevolutionFunc.getInstance((double)(-zAxis / (0.5 * d * d)), (double)0.0);
                                                        result = Patterns.newSpaceSegment((UniformGridPattern)projection, (Func)ConstantFunc.getInstance((double)surf.get(0.5 * dCircle, 0.0)), (Func)surf, (double)0.0, (double)zStep).shift(Point.valueOf((double)x, (double)y, (double)z));
                                                    } else if (s.startsWith("series ")) {
                                                        String[] params = s.substring("series ".length()).split("[, ]+");
                                                        int paramIndex = 0;
                                                        if (params.length >= 7 || params.length == 4) {
                                                            long x0 = params.length >= 7 ? Long.parseLong(params[paramIndex++].trim()) : 0L;
                                                            long y0 = params.length >= 7 ? Long.parseLong(params[paramIndex++].trim()) : 0L;
                                                            double z0 = params.length >= 7 ? Double.parseDouble(params[paramIndex++].trim()) * zScale : 0.0;
                                                            long dx = Long.parseLong(params[paramIndex++].trim());
                                                            long dy = Long.parseLong(params[paramIndex++].trim());
                                                            double dz = Double.parseDouble(params[paramIndex++].trim()) * zScale;
                                                            if (integerType) {
                                                                z0 = Math.round(z0);
                                                                dz = Math.round(dz);
                                                            }
                                                            int n = Integer.parseInt(params[paramIndex].trim());
                                                            result = PatternSpecificationParser.getSeries(x0, y0, z0, dx, dy, dz, n);
                                                        } else {
                                                            long x0 = params.length >= 5 ? Long.parseLong(params[paramIndex++].trim()) : 0L;
                                                            long y0 = params.length >= 5 ? Long.parseLong(params[paramIndex++].trim()) : 0L;
                                                            long dx = Long.parseLong(params[paramIndex++].trim());
                                                            long dy = Long.parseLong(params[paramIndex++].trim());
                                                            int n = Integer.parseInt(params[paramIndex].trim());
                                                            result = PatternSpecificationParser.getSeries(x0, y0, dx, dy, n);
                                                        }
                                                    } else if (s.startsWith("points ")) {
                                                        result = PatternSpecificationParser.parsePoints(s, integerType, zScale);
                                                        raw = false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Illegal pattern description: \"" + s + "\": " + ex.getMessage(), ex);
        }
        if (result == null) {
            throw new IllegalArgumentException("Unsupported pattern description format: \"" + s + "\"");
        }
        if (surface) {
            result = result.round().surface();
        }
        if (bounds) {
            result = Patterns.newUnion((Pattern[])new Pattern[]{result.maxBound(0), result.maxBound(1), result.minBound(0), result.minBound(1)});
        }
        if (slow) {
            result = new SimplePattern((Collection)result.points());
        } else if (raw) {
            if (result instanceof UniformGridPattern) {
                ugResult = (UniformGridPattern)result;
                result = Patterns.newUniformGridPattern((Point)ugResult.originOfGrid(), (double[])ugResult.stepsOfGrid(), (Collection)ugResult.gridIndexPattern().roundedPoints());
            } else {
                result = Patterns.newPattern((Collection)result.points());
            }
        }
        ugResult = this.patternCache;
        synchronized (ugResult) {
            this.patternCache.put(s, new SoftReference<Pattern>(result));
        }
        Pattern finalResult = result;
        LOG.log(System.Logger.Level.DEBUG, () -> "Pattern loaded from cache: " + finalResult);
        return result;
    }

    public static boolean isRectangularInteger(Pattern pattern) {
        return pattern instanceof UniformGridPattern && ((UniformGridPattern)pattern).isActuallyRectangular() && pattern.isSurelyInteger();
    }

    public static Pattern subtract(Pattern pattern1, Pattern pattern2) {
        if (PatternSpecificationParser.isRectangularInteger(pattern1) && PatternSpecificationParser.isRectangularInteger(pattern2) && pattern1.dimCount() == pattern2.dimCount()) {
            IRectangularArea area1 = pattern1.roundedCoordArea();
            IRectangularArea area2 = pattern2.roundedCoordArea();
            ArrayList<RectangularPattern> patternList = new ArrayList<RectangularPattern>();
            for (IRectangularArea area : area1.difference(new ArrayList(), area2)) {
                patternList.add(Patterns.newRectangularIntegerPattern((IRange[])area.ranges()));
            }
            return Patterns.newUnion(patternList);
        }
        LinkedHashSet points = new LinkedHashSet(pattern1.roundedPoints());
        points.removeAll(pattern2.roundedPoints());
        return Patterns.newIntegerPattern(points);
    }

    private static Pattern getSeries(long x0, long y0, long dx, long dy, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Zero or negative length of the series: " + n);
        }
        if (n == 1) {
            return Patterns.newIntegerPattern((IPoint[])new IPoint[]{IPoint.valueOf((long)x0, (long)y0)});
        }
        return Patterns.newMinkowskiMultiplePattern((Pattern)Patterns.newIntegerPattern((IPoint[])new IPoint[]{IPoint.origin((int)2), IPoint.valueOf((long)dx, (long)dy)}), (int)(n - 1)).shift(Point.valueOf((double)x0, (double)y0));
    }

    private static Pattern parsePoints(String s, boolean integerType, double zScale) {
        String[] pointDescriptions = s.substring("points ".length()).split(";");
        HashSet<Point> points = new HashSet<Point>();
        for (String pd : pointDescriptions) {
            String[] coordDescriptions = pd.trim().split("[, ]+");
            double[] coordinates = new double[coordDescriptions.length];
            for (int j = 0; j < coordinates.length; ++j) {
                coordinates[j] = Double.parseDouble(coordDescriptions[j].trim());
                if (j != 2) continue;
                int n = j;
                coordinates[n] = coordinates[n] * zScale;
                if (!integerType) continue;
                coordinates[j] = Math.round(coordinates[j]);
            }
            points.add(Point.valueOf((double[])coordinates));
        }
        DirectPointSetPattern result = Patterns.newPattern(points);
        return result;
    }

    private static Pattern parseBinaryMatrix2D(String s) {
        String[] lines = s.split("\\r(?!\\n)|\\n|\\r\\n");
        if (s.isEmpty() || lines.length == 0) {
            return null;
        }
        Arrays.setAll(lines, k -> lines[k].replaceAll("\\s+", ""));
        if (!Arrays.stream(lines).allMatch(line -> line.matches("^[01]+$"))) {
            return null;
        }
        int dimX = lines[0].length();
        int dimY = lines.length;
        for (int i = 1; i < dimY; ++i) {
            if (lines[i].length() == dimX) continue;
            throw new IllegalArgumentException("Pattern is represented by 0/1 matrix, but lines #1 and #" + (i + 1) + " of this matrix contains different number of characters 0/1");
        }
        if (dimX <= 1 && dimY == 1) {
            throw new IllegalArgumentException("Pattern is represented by too small 0/1 matrix " + dimX + "x" + dimY + ": at least one of dimensions must be >1");
        }
        int centerX = dimX / 2;
        int centerY = dimY / 2;
        ArrayList<IPoint> points = new ArrayList<IPoint>();
        for (int y = 0; y < dimY; ++y) {
            for (int x = 0; x < dimX; ++x) {
                if (lines[y].charAt(x) == '0') continue;
                points.add(IPoint.valueOf((long)(x - centerX), (long)(y - centerY)));
            }
        }
        if (points.isEmpty()) {
            throw new IllegalArgumentException("Pattern is represented by 0/1 matrix, but all values are 0, it is prohibited: pattern must contain at least one point");
        }
        return Patterns.newIntegerPattern(points);
    }

    private static Pattern getSeries(long x0, long y0, double z0, long dx, long dy, double dz, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Zero or negative length of the series: " + n);
        }
        if (n == 1) {
            return Patterns.newPattern((Point[])new Point[]{Point.valueOf((double)x0, (double)y0, (double)z0)});
        }
        return Patterns.newMinkowskiMultiplePattern((Pattern)Patterns.newPattern((Point[])new Point[]{Point.origin((int)3), Point.valueOf((double)dx, (double)dy, (double)dz)}), (int)(n - 1)).shift(Point.valueOf((double)x0, (double)y0, (double)z0));
    }

    private static boolean isSurelyLowCase(String s) {
        int n = s.length();
        for (int k = 0; k < n; ++k) {
            char ch = s.charAt(k);
            if (ch < '\u0080' && (ch < 'A' || ch > 'Z')) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(PatternSpecificationParser.isSurelyLowCase(args[0]));
        System.out.println(PatternSpecificationParser.isSurelyLowCase(""));
        System.out.println(PatternSpecificationParser.isSurelyLowCase("asd"));
        System.out.println(PatternSpecificationParser.isSurelyLowCase("asF"));
    }
}

