/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrixToNumbers;
import net.algart.executors.modules.core.matrices.geometry.ContinuationMode;
import net.algart.executors.modules.cv.matrices.misc.Selector;
import net.algart.executors.modules.cv.matrices.misc.SortedRound2DAperture;
import net.algart.executors.modules.cv.matrices.misc.extremums.ExtremumsFinder;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import net.algart.executors.modules.cv.matrices.objects.MeasureLabelledObjects;
import net.algart.executors.modules.opencv.matrices.filtering.GaussianBlur;
import net.algart.math.IRange;
import net.algart.math.functions.Func;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class LocalExtremums
extends MultiMatrixToNumbers {
    private static final int MULTITHREADING_Y_BLOCK_LENGTH = 8;
    private static final int MIN_MULTITHREADING_Y_BLOCK_LENGTH = 4;
    public static final String INPUT_MASK = "mask";
    public static final String INPUT_IGNORE = "ignore";
    public static final String OUTPUT_EXTREMUMS = "extremums";
    public static final String OUTPUT_EXTREMUMS_MASK = "extremums_mask";
    public static final String OUTPUT_EXTREMUMS_ON_SOURCE = "extremums_on_source";
    private ResultValues resultValues = ResultValues.MAXIMUMS;
    private int gaussianBlurKernelSize = 5;
    private int apertureSize = 5;
    private int depthApertureSize = 0;
    private boolean depthApertureRing = false;
    private ExtremumsFinder.DeepTestSettings.Mode depthAnalysisMode = ExtremumsFinder.DeepTestSettings.Mode.PERCENTILE;
    private double depthPercentileLevel = 1.0;
    private double minimalDepth = 0.0;
    private ResultAtPlateau resultAtPlateau = ResultAtPlateau.CENTROID;
    private int resultCircleSize = 1;
    private String drawingExtremumsColor = "#FFFFFF";
    private boolean autoContrastSourceUnderExtremums = false;
    private boolean visibleExtremumsOnSource = false;
    private MultiMatrix2D resultExtremumsMask = null;

    public LocalExtremums() {
        this.addInputMat(INPUT_MASK);
        this.addInputMat(INPUT_IGNORE);
        this.setDefaultOutputNumbers(OUTPUT_EXTREMUMS);
        this.addOutputMat(OUTPUT_EXTREMUMS_MASK);
    }

    public ResultValues getResultValues() {
        return this.resultValues;
    }

    public LocalExtremums setResultValues(ResultValues resultValues) {
        this.resultValues = (ResultValues)((Object)LocalExtremums.nonNull((Object)((Object)resultValues)));
        return this;
    }

    public int getGaussianBlurKernelSize() {
        return this.gaussianBlurKernelSize;
    }

    public LocalExtremums setGaussianBlurKernelSize(int gaussianBlurKernelSize) {
        this.gaussianBlurKernelSize = LocalExtremums.nonNegative((int)gaussianBlurKernelSize);
        return this;
    }

    public int getApertureSize() {
        return this.apertureSize;
    }

    public LocalExtremums setApertureSize(int apertureSize) {
        this.apertureSize = LocalExtremums.positive((int)apertureSize);
        return this;
    }

    public int getDepthApertureSize() {
        return this.depthApertureSize;
    }

    public LocalExtremums setDepthApertureSize(int depthApertureSize) {
        this.depthApertureSize = LocalExtremums.nonNegative((int)depthApertureSize);
        return this;
    }

    public LocalExtremums setDepthApertureSize(String depthApertureSize) {
        this.depthApertureSize = LocalExtremums.nonNegative((int)LocalExtremums.intOrDefault((String)depthApertureSize, (int)0));
        return this;
    }

    public boolean isDepthApertureRing() {
        return this.depthApertureRing;
    }

    public LocalExtremums setDepthApertureRing(boolean depthApertureRing) {
        this.depthApertureRing = depthApertureRing;
        return this;
    }

    public ExtremumsFinder.DeepTestSettings.Mode getDepthAnalysisMode() {
        return this.depthAnalysisMode;
    }

    public LocalExtremums setDepthAnalysisMode(ExtremumsFinder.DeepTestSettings.Mode depthAnalysisMode) {
        this.depthAnalysisMode = (ExtremumsFinder.DeepTestSettings.Mode)((Object)LocalExtremums.nonNull((Object)((Object)depthAnalysisMode)));
        return this;
    }

    public double getDepthPercentileLevel() {
        return this.depthPercentileLevel;
    }

    public LocalExtremums setDepthPercentileLevel(double depthPercentileLevel) {
        this.depthPercentileLevel = LocalExtremums.inRange((double)depthPercentileLevel, (double)0.0, (double)1.0);
        return this;
    }

    public double getMinimalDepth() {
        return this.minimalDepth;
    }

    public LocalExtremums setMinimalDepth(double minimalDepth) {
        this.minimalDepth = LocalExtremums.nonNegative((double)minimalDepth);
        return this;
    }

    public ResultAtPlateau getResultAtPlateau() {
        return this.resultAtPlateau;
    }

    public LocalExtremums setResultAtPlateau(ResultAtPlateau resultAtPlateau) {
        this.resultAtPlateau = (ResultAtPlateau)((Object)LocalExtremums.nonNull((Object)((Object)resultAtPlateau)));
        return this;
    }

    public int getResultCircleSize() {
        return this.resultCircleSize;
    }

    public LocalExtremums setResultCircleSize(int resultCircleSize) {
        this.resultCircleSize = LocalExtremums.positive((int)resultCircleSize);
        return this;
    }

    public String getDrawingExtremumsColor() {
        return this.drawingExtremumsColor;
    }

    public LocalExtremums setDrawingExtremumsColor(String drawingExtremumsColor) {
        this.drawingExtremumsColor = (String)LocalExtremums.nonNull((Object)drawingExtremumsColor);
        return this;
    }

    public boolean isAutoContrastSourceUnderExtremums() {
        return this.autoContrastSourceUnderExtremums;
    }

    public LocalExtremums setAutoContrastSourceUnderExtremums(boolean autoContrastSourceUnderExtremums) {
        this.autoContrastSourceUnderExtremums = autoContrastSourceUnderExtremums;
        return this;
    }

    public boolean isVisibleExtremumsOnSource() {
        return this.visibleExtremumsOnSource;
    }

    public LocalExtremums setVisibleExtremumsOnSource(boolean visibleExtremumsOnSource) {
        this.visibleExtremumsOnSource = visibleExtremumsOnSource;
        return this;
    }

    public MultiMatrix2D resultExtremumsMask() {
        return this.resultExtremumsMask;
    }

    public SNumbers analyse(MultiMatrix source) {
        Objects.requireNonNull(source, "Null source");
        return this.analyse(source.asMultiMatrix2D(), this.getInputMat(INPUT_MASK, true).toMultiMatrix2D(), this.getInputMat(INPUT_IGNORE, true).toMultiMatrix2D());
    }

    public SNumbers analyse(MultiMatrix2D source, MultiMatrix2D mask, MultiMatrix2D ignore) {
        int depthApertureSize;
        source.checkDimensionEquality((MultiMatrix)mask, "source", INPUT_MASK);
        source.checkDimensionEquality((MultiMatrix)ignore, "source", INPUT_IGNORE);
        long t1 = System.nanoTime();
        source = source.toMonoIfNot();
        if (this.gaussianBlurKernelSize > 0) {
            source = GaussianBlur.blur(source, this.gaussianBlurKernelSize, true);
        }
        long t2 = System.nanoTime();
        boolean[] maskArray = mask == null ? null : Arrays.toJavaArray((BitArray)((BitArray)mask.nonZeroRGBMatrix().array()));
        long t3 = System.nanoTime();
        SortedRound2DAperture aperture = SortedRound2DAperture.getCircleWithSpeciallyOrderedPointsAtAxes(this.apertureSize, source.dimX());
        int n = depthApertureSize = this.depthApertureSize == 0 ? this.apertureSize : this.depthApertureSize;
        SortedRound2DAperture depthAperture = depthApertureSize == this.apertureSize && !this.depthApertureRing ? null : (this.depthApertureRing ? SortedRound2DAperture.getRing(depthApertureSize, source.dimX()) : SortedRound2DAperture.getCircle(depthApertureSize, source.dimX()));
        Matrix ignoreMatrix = ignore == null ? null : ignore.nonZeroRGBMatrix();
        float[] values = source.channelToFloatArray(0);
        Matrix extremumsMaskMatrix = Arrays.SMM.newBitMatrix(source.dimensions());
        long t4 = System.nanoTime();
        MutableIntArray extremumsXY = Arrays.SMM.newEmptyIntArray();
        if (source.size() > 0L) {
            long dimY = source.dimY();
            if (Arrays.SystemSettings.cpuCount() == 1) {
                extremumsXY = this.processRange(values, maskArray, aperture, depthAperture, (Matrix<? extends BitArray>)ignoreMatrix, (Matrix<UpdatableBitArray>)extremumsMaskMatrix, IRange.valueOf((long)0L, (long)(dimY - 1L)));
            } else {
                ArrayList<IRange> yRanges = new ArrayList<IRange>();
                int yBlockLength = Math.max(4, (int)Math.min(8L, dimY / (long)Runtime.getRuntime().availableProcessors()));
                for (long y = 0L; y < dimY; y += (long)yBlockLength) {
                    yRanges.add(IRange.valueOf((long)y, (long)(Math.min(y + (long)yBlockLength, dimY) - 1L)));
                }
                List results = yRanges.parallelStream().map(range -> this.processRange(values, maskArray, aperture, depthAperture, (Matrix<? extends BitArray>)ignoreMatrix, (Matrix<UpdatableBitArray>)extremumsMaskMatrix, (IRange)range)).collect(Collectors.toList());
                for (IntArray a : results) {
                    extremumsXY.append((Array)a);
                }
            }
        }
        long t5 = System.nanoTime();
        this.resultExtremumsMask = MultiMatrix.valueOf2DMono((Matrix)extremumsMaskMatrix);
        SNumbers result = this.postprocess((IntArray)extremumsXY);
        this.dilateExtremumsMask();
        long t6 = System.nanoTime();
        if (LOGGABLE_DEBUG) {
            LocalExtremums.logDebug((String)String.format(Locale.US, "Local %s%s for %s, aperture size %d (%d points): %.3f ms = %.3f blur, %.3f preparing mask, %.3f preparing, %.3f search, %.3f postprocessing", new Object[]{this.resultValues, mask == null ? "" : " (masked)", source, this.apertureSize, aperture.count(), (double)(t6 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t6 - t5) * 1.0E-6}));
        }
        this.setEndProcessingTimeStamp();
        this.getMat(OUTPUT_EXTREMUMS_MASK).setTo((MultiMatrix)this.resultExtremumsMask);
        if (this.isOutputNecessary(OUTPUT_EXTREMUMS_ON_SOURCE)) {
            try (Selector selector = new Selector();){
                this.getMat(OUTPUT_EXTREMUMS_ON_SOURCE).setTo(selector.setSelectorType(Selector.SelectorType.BINARY_MATRIX).setFiller(1, this.drawingExtremumsColor).setMinimalRequiredNumberOfChannels(3).process(new MultiMatrix[]{this.resultExtremumsMask, this.autoContrastSourceUnderExtremums ? source.contrast() : source, null}));
            }
        }
        return result;
    }

    public String visibleOutputPortName() {
        return this.visibleExtremumsOnSource ? OUTPUT_EXTREMUMS_ON_SOURCE : OUTPUT_EXTREMUMS_MASK;
    }

    private SNumbers postprocess(IntArray extremumsXY) {
        if (this.resultAtPlateau == ResultAtPlateau.ALL_PIXELS) {
            PArray result = Arrays.asFuncArray((Func)Func.IDENTITY, FloatArray.class, (PArray[])new PArray[]{extremumsXY});
            return SNumbers.valueOfArray((Object)Arrays.toJavaArray((Array)result), (int)2);
        }
        if (this.resultAtPlateau == ResultAtPlateau.CENTROID_OF_CIRCLE) {
            this.dilateExtremumsMask();
        }
        HashMap<MeasureLabelledObjects.ObjectParameter, SNumbers> resultStatistics = new HashMap<MeasureLabelledObjects.ObjectParameter, SNumbers>();
        SNumbers result = new SNumbers();
        resultStatistics.put(MeasureLabelledObjects.ObjectParameter.CENTROID, result);
        new MeasureLabelledObjects().setAutoSplitBitInputIntoConnectedComponents(true).setBitInputConnectivityType(ConnectivityType.STRAIGHT_AND_DIAGONAL).analyse(resultStatistics, this.resultExtremumsMask, null);
        Matrix mask = Arrays.SMM.newBitMatrix(this.resultExtremumsMask.dimensions());
        long dimX = mask.dimX();
        long dimY = mask.dimY();
        int n = result.n();
        for (int k = 0; k < n; ++k) {
            long x = Math.round(result.getValue(k, 0));
            long y = Math.round(result.getValue(k, 1));
            if (x < 0L || y < 0L || x >= dimX || y >= dimY) continue;
            ((UpdatableBitArray)mask.array()).setBit(y * dimX + x);
        }
        this.resultExtremumsMask = MultiMatrix.valueOf2DMono((Matrix)mask);
        return result;
    }

    private void dilateExtremumsMask() {
        this.resultExtremumsMask = new StrictMorphology().setOperation(MorphologyOperation.DILATION).setContinuationMode(ContinuationMode.ZERO_CONSTANT).setPattern(MorphologyFilter.Shape.SPHERE, this.resultCircleSize).process((MultiMatrix)this.resultExtremumsMask).asMultiMatrix2D();
    }

    private IntArray processRange(float[] values, boolean[] mask, SortedRound2DAperture aperture, SortedRound2DAperture depthAperture, Matrix<? extends BitArray> ignore, Matrix<UpdatableBitArray> extremumsMaskMatrix, IRange yRange) {
        ExtremumsFinder.DeepTestSettings deepTestSettings = new ExtremumsFinder.DeepTestSettings().setDepthAperture(depthAperture).setMode(this.depthAnalysisMode).setPercentileLevel(this.depthPercentileLevel).setMinimalDepth(this.minimalDepth).setIgnore(ignore);
        ExtremumsFinder finder = this.resultValues == ResultValues.MAXIMUMS ? ExtremumsFinder.getMaximumsFinder(values, mask, aperture, deepTestSettings, extremumsMaskMatrix, !this.resultAtPlateau.postProcessingRequired) : ExtremumsFinder.getMinimumsFinder(values, mask, aperture, deepTestSettings, extremumsMaskMatrix, !this.resultAtPlateau.postProcessingRequired);
        int yMax = (int)yRange.max();
        for (int y = (int)yRange.min(); y <= yMax; ++y) {
            finder.processLine(y);
        }
        return finder.getExtremumsXY();
    }

    public static enum ResultValues {
        MAXIMUMS,
        MINIMUMS;

    }

    public static enum ResultAtPlateau {
        ALL_PIXELS(false),
        CENTROID(true),
        CENTROID_OF_CIRCLE(true);

        final boolean postProcessingRequired;

        private ResultAtPlateau(boolean postProcessingRequired) {
            this.postProcessingRequired = postProcessingRequired;
        }
    }
}

