/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.camera;

import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.executors.modules.core.common.matrices.MultiMatrixGenerator;
import net.algart.executors.modules.cv.matrices.camera.IntensityToReflectance;
import net.algart.executors.modules.cv.matrices.camera.reflectance.ReflectanceSettings;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;

public final class ReflectanceToIntensity
extends MultiMatrixFilter {
    private String reflectanceSettingsFile = "";
    private Class<?> elementType = Float.TYPE;
    private boolean maximalPrecision = false;

    public ReflectanceToIntensity() {
        this.addOutputScalar("reflectance_settings");
    }

    public String getReflectanceSettingsFile() {
        return this.reflectanceSettingsFile;
    }

    public ReflectanceToIntensity setReflectanceSettingsFile(String reflectanceSettingsFile) {
        this.reflectanceSettingsFile = ReflectanceToIntensity.nonEmpty((String)reflectanceSettingsFile);
        return this;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    public void setElementType(Class<?> elementType) {
        this.elementType = (Class)ReflectanceToIntensity.nonNull(elementType);
    }

    public void setElementType(String elementType) {
        this.setElementType(MultiMatrixGenerator.elementType((String)elementType));
    }

    public boolean isMaximalPrecision() {
        return this.maximalPrecision;
    }

    public void setMaximalPrecision(boolean maximalPrecision) {
        this.maximalPrecision = maximalPrecision;
    }

    public MultiMatrix process(MultiMatrix source) {
        ReflectanceSettings settings = IntensityToReflectance.loadReflectanceSettings((Executor)this, this.reflectanceSettingsFile);
        Func f = settings.reflectanceToIntensityFunc(this.elementType, this.maximalPrecision);
        return source.asMono().asFunc(f, Arrays.type(PArray.class, this.elementType)).clone();
    }
}

