/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

public final class MultitrehadingManyUMatProblem {
    public static UMat clone(UMat u) {
        try (Mat cloneInRAM = new Mat(u.rows(), u.cols(), u.type());){
            u.copyTo(cloneInRAM);
            UMat result = new UMat(u.rows(), u.cols(), u.type());
            u.copyTo(result);
            UMat uMat = result;
            return uMat;
        }
    }

    public static UMat cloneBad(UMat u) {
        UMat result = new UMat(u.rows(), u.cols(), u.type());
        u.copyTo(result);
        return result;
    }

    public static void main(String[] args) {
        System.out.println("OpenCL existence: " + opencv_core.haveOpenCL());
        System.out.println("OpenCL usage: " + opencv_core.useOpenCL());
        System.out.println();
        int n = Integer.parseInt(args[0]);
        int k = 1;
        while (k <= n) {
            int index = k++;
            new Thread(() -> {
                System.out.println("Starting " + index + "/" + n + "...");
                UMat mat = new UMat(2000, 2000, 0, new Scalar(0.0, 0.0, 0.0, 0.0));
                System.out.println("Cloning " + index + "/" + n + "...");
                UMat clone = MultitrehadingManyUMatProblem.cloneBad(mat);
                System.out.println("Finishing " + index + "/" + n + "...");
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }).start();
        }
    }
}

