/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.photo;

import net.algart.executors.modules.opencv.common.VoidResultTwoUMatFilter;
import net.algart.executors.modules.opencv.util.enums.OInpaintAlgorithm;
import org.bytedeco.opencv.global.opencv_photo;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Inpaint
extends VoidResultTwoUMatFilter {
    public static final String INPUT_MASK = "mask";
    private double inpaintRadius = 10.0;
    private OInpaintAlgorithm algorithm = OInpaintAlgorithm.INPAINT_NS;

    public Inpaint() {
        super(null, INPUT_MASK);
    }

    public double getInpaintRadius() {
        return this.inpaintRadius;
    }

    public void setInpaintRadius(double inpaintRadius) {
        this.inpaintRadius = Inpaint.nonNegative((double)inpaintRadius);
    }

    public OInpaintAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(OInpaintAlgorithm algorithm) {
        this.algorithm = (OInpaintAlgorithm)((Object)Inpaint.nonNull((Object)((Object)algorithm)));
    }

    @Override
    public void process(Mat result, Mat source, Mat secondMat) {
        opencv_photo.inpaint((Mat)source, (Mat)secondMat, (Mat)result, (double)this.inpaintRadius, (int)this.algorithm.code());
    }

    @Override
    public void process(UMat result, UMat source, UMat secondMat) {
        opencv_photo.inpaint((UMat)source, (UMat)secondMat, (UMat)result, (double)this.inpaintRadius, (int)this.algorithm.code());
    }

    @Override
    protected boolean allowInputPackedBits(int inputIndex) {
        return inputIndex == 1;
    }
}

