/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.drawing;

import java.awt.Color;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.IndexingBase;
import net.algart.executors.modules.cv.matrices.drawing.PositionsAndColors;
import net.algart.executors.modules.opencv.common.OpenCVExecutor;
import net.algart.executors.modules.opencv.util.O2SMat;
import net.algart.executors.modules.opencv.util.OTools;
import net.algart.executors.modules.opencv.util.enums.OLineType;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Scalar;

public final class DrawLine
extends OpenCVExecutor {
    public static final String INPUT_POSITIONS = "positions";
    public static final String INPUT_PAIRS_OF_INDEXES_OF_POINTS = "pairs_of_indexes_of_points";
    public static final String INPUT_COLORS = "colors";
    private boolean percents = false;
    private double x1 = 0.0;
    private double y1 = 0.0;
    private double x2 = 0.0;
    private double y2 = 0.0;
    private int thickness = 1;
    private double lengthIncrement = 0.0;
    private IndexingBase indexingBase = IndexingBase.ONE_BASED;
    private OLineType lineType = OLineType.LINE_8;
    private Color color = Color.WHITE;
    private String backgroundColor = "";

    public DrawLine() {
        this.setDefaultInputMat(DEFAULT_INPUT_PORT);
        this.addInputNumbers(INPUT_POSITIONS);
        this.addInputNumbers(INPUT_PAIRS_OF_INDEXES_OF_POINTS);
        this.addInputNumbers(INPUT_COLORS);
        this.setDefaultOutputMat(DEFAULT_OUTPUT_PORT);
    }

    public boolean isPercents() {
        return this.percents;
    }

    public DrawLine setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX1() {
        return this.x1;
    }

    public DrawLine setX1(double x1) {
        this.x1 = x1;
        return this;
    }

    public double getY1() {
        return this.y1;
    }

    public DrawLine setY1(double y1) {
        this.y1 = y1;
        return this;
    }

    public double getX2() {
        return this.x2;
    }

    public DrawLine setX2(double x2) {
        this.x2 = x2;
        return this;
    }

    public double getY2() {
        return this.y2;
    }

    public DrawLine setY2(double y2) {
        this.y2 = y2;
        return this;
    }

    public int getThickness() {
        return this.thickness;
    }

    public DrawLine setThickness(int thickness) {
        this.thickness = DrawLine.nonNegative((int)thickness);
        return this;
    }

    public double getLengthIncrement() {
        return this.lengthIncrement;
    }

    public DrawLine setLengthIncrement(double lengthIncrement) {
        this.lengthIncrement = lengthIncrement;
        return this;
    }

    public IndexingBase getIndexingBase() {
        return this.indexingBase;
    }

    public DrawLine setIndexingBase(IndexingBase indexingBase) {
        this.indexingBase = (IndexingBase)DrawLine.nonNull((Object)indexingBase);
        return this;
    }

    public OLineType getLineType() {
        return this.lineType;
    }

    public DrawLine setLineType(OLineType lineType) {
        this.lineType = (OLineType)((Object)DrawLine.nonNull((Object)((Object)lineType)));
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public DrawLine setColor(Color color) {
        this.color = (Color)DrawLine.nonNull((Object)color);
        return this;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public DrawLine setBackgroundColor(String backgroundColor) {
        this.backgroundColor = (String)DrawLine.nonNull((Object)backgroundColor);
        return this;
    }

    public boolean hasBackgroundColor() {
        return !this.backgroundColor.trim().isEmpty();
    }

    public void process() {
        Mat source;
        SMat m = this.getInputMat(true);
        if (this.hasBackgroundColor() && !m.getDepth().isOpenCVCompatible()) {
            if (m.getDimX() > Integer.MAX_VALUE || m.getDimY() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Too large matrix sizes (>2^31): " + m);
            }
            int type = opencv_core.CV_MAKE_TYPE((int)0, (int)m.getNumberOfChannels());
            source = new Mat((int)m.getDimY(), (int)m.getDimX(), type);
        } else {
            source = O2SMat.toMat(m, true);
        }
        O2SMat.setTo(this.getMat(), this.process(source));
    }

    public Mat process(Mat source) {
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        SNumbers pairsOfIndexes = this.getInputNumbers(INPUT_PAIRS_OF_INDEXES_OF_POINTS, true);
        if (this.hasBackgroundColor()) {
            try (Scalar scalar = OTools.scalarBGRA(this.backgroundColor, OTools.maxPossibleValue(source));){
                source.put(scalar);
            }
        }
        if (pairsOfIndexes.isInitialized()) {
            net.algart.executors.modules.cv.matrices.drawing.DrawLine.translatePairsOfIndexes(positions, pairsOfIndexes, this.indexingBase);
        }
        SNumbers colors = this.getInputNumbers(INPUT_COLORS, true);
        double defaultX1 = this.percents ? this.x1 / 100.0 * (double)(source.cols() - 1) : this.x1;
        double defaultY1 = this.percents ? this.y1 / 100.0 * (double)(source.rows() - 1) : this.y1;
        double defaultX2 = this.percents ? this.x2 / 100.0 * (double)(source.cols() - 1) : this.x2;
        double defaultY2 = this.percents ? this.y2 / 100.0 * (double)(source.rows() - 1) : this.y2;
        PositionsAndColors positionsAndColors = new PositionsAndColors(positions, colors, new double[]{defaultX1, defaultY1, defaultX2, defaultY2}, Double.NaN, 4);
        double scale = OTools.maxPossibleValue(source);
        int n = positionsAndColors.n();
        for (int k = 0; k < n; ++k) {
            double[] x1y1x2y2 = positionsAndColors.xyAndOthers(k);
            net.algart.executors.modules.cv.matrices.drawing.DrawLine.increaseLength(x1y1x2y2, this.lengthIncrement);
            try (Scalar color = this.rgbToScalar(positionsAndColors.colorRGB(k), scale);
                 Point p1 = new Point((int)x1y1x2y2[0], (int)x1y1x2y2[1]);
                 Point p2 = new Point((int)x1y1x2y2[2], (int)x1y1x2y2[3]);){
                opencv_imgproc.line((Mat)source, (Point)p1, (Point)p2, (Scalar)color, (int)this.thickness, (int)this.lineType.code(), (int)0);
                continue;
            }
        }
        return source;
    }

    protected boolean allowInputPackedBits() {
        return true;
    }

    private Scalar rgbToScalar(float[] rgb, double scale) {
        if (rgb == null) {
            rgb = this.color.getRGBColorComponents(null);
        }
        double r = DrawLine.truncateColor01(rgb[0]);
        double g = DrawLine.truncateColor01(rgb[1]);
        double b = DrawLine.truncateColor01(rgb[2]);
        return new Scalar(b * scale, g * scale, r * scale, scale);
    }

    private static double truncateColor01(double v) {
        return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
    }
}

