/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.morphology;

import net.algart.arrays.Arrays;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IterativeArrayProcessor;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixChannel2DFilter;
import net.algart.executors.modules.core.matrices.geometry.ContinuationMode;
import net.algart.executors.modules.cv.matrices.morphology.PatternSpecificationParser;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.math.patterns.Pattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.ContinuedMorphology;
import net.algart.matrices.morphology.IterativeErosion;
import net.algart.matrices.morphology.IterativeOpening;
import net.algart.matrices.morphology.Morphology;
import net.algart.multimatrix.MultiMatrix2D;

public final class MorphologyTransform
extends MultiMatrixChannel2DFilter {
    private TransformOperation transformOperation = TransformOperation.EROSION;
    private ResultElementType resultElementType = ResultElementType.FLOAT;
    private Long maxNumberOfIterations = null;
    private String patternsSpecification = "cross | square 3";
    private Pattern[] patterns = MorphologyTransform.parsePatterns(this.patternsSpecification);
    private ContinuationMode continuationMode = ContinuationMode.NEGATIVE_INFINITY;
    private boolean convertToMono = true;

    public TransformOperation getTransformOperation() {
        return this.transformOperation;
    }

    public MorphologyTransform setTransformOperation(TransformOperation transformOperation) {
        this.transformOperation = transformOperation;
        return this;
    }

    public ResultElementType getResultElementType() {
        return this.resultElementType;
    }

    public MorphologyTransform setResultElementType(ResultElementType resultElementType) {
        this.resultElementType = resultElementType;
        return this;
    }

    public Long getMaxNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    public MorphologyTransform setMaxNumberOfIterations(Long maxNumberOfIterations) {
        if (maxNumberOfIterations != null) {
            MorphologyTransform.nonNegative((long)maxNumberOfIterations);
        }
        this.maxNumberOfIterations = maxNumberOfIterations;
        return this;
    }

    public MorphologyTransform setMaxNumberOfIterations(String maxNumberOfIterations) {
        return this.setMaxNumberOfIterations(MorphologyTransform.longOrNull((String)maxNumberOfIterations));
    }

    public String getPatternsSpecification() {
        return this.patternsSpecification;
    }

    public MorphologyTransform setPatternsSpecification(String patternsSpecification) {
        if (!this.patternsSpecification.equals(patternsSpecification)) {
            this.patternsSpecification = (String)MorphologyTransform.nonNull((Object)patternsSpecification);
            this.patterns = MorphologyTransform.parsePatterns(patternsSpecification);
        }
        return this;
    }

    public ContinuationMode getContinuationMode() {
        return this.continuationMode;
    }

    public MorphologyTransform setContinuationMode(ContinuationMode continuationMode) {
        this.continuationMode = (ContinuationMode)MorphologyTransform.nonNull((Object)continuationMode);
        return this;
    }

    public boolean isConvertToMono() {
        return this.convertToMono;
    }

    public MorphologyTransform setConvertToMono(boolean convertToMono) {
        this.convertToMono = convertToMono;
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        if (this.convertToMono) {
            source = source.asMono();
        }
        return super.process(source);
    }

    protected Matrix<? extends PArray> processChannel(Matrix<? extends PArray> m) {
        if (this.currentChannel() == 0) {
            MorphologyTransform.logDebug(() -> "Morphology transform " + this.transformOperation + " with " + this.patternsSpecification + (String)(this.continuationMode == ContinuationMode.DEFAULT ? "" : ", " + this.continuationMode.continuationMode()) + " for " + this.sourceMultiMatrix());
        }
        Class resultType = Arrays.type(UpdatablePArray.class, this.resultElementType.elementType);
        IterativeArrayProcessor processor = this.transformOperation.getProcessor(this.createMorphology(m), resultType, m, this.patterns);
        if (this.maxNumberOfIterations != null) {
            processor = processor.limitIterations(this.maxNumberOfIterations.longValue());
        }
        Matrix result = (Matrix)processor.process();
        double maxPossibleValue = ((PArray)m.array()).maxPossibleValue(1.0);
        if (maxPossibleValue != 1.0) {
            result = Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{1.0 / maxPossibleValue}), FloatArray.class, (Matrix)result);
        }
        return result;
    }

    public Morphology createMorphology(Matrix<? extends PArray> m) {
        BasicMorphology morphology = BasicMorphology.getInstance(null);
        if (this.continuationMode != ContinuationMode.DEFAULT) {
            Matrix.ContinuationMode mode = this.continuationMode == ContinuationMode.NEGATIVE_INFINITY && m.elementType() == Boolean.TYPE ? Matrix.ContinuationMode.ZERO_CONSTANT : this.continuationMode.continuationModeOrNull();
            morphology = ContinuedMorphology.getInstance((Morphology)morphology, (Matrix.ContinuationMode)mode);
        }
        return morphology;
    }

    private static Pattern[] parsePatterns(String patternsSpecification) {
        String[] patternsDescriptions = patternsSpecification.split("\\|");
        Pattern[] patterns = new Pattern[patternsDescriptions.length];
        PatternSpecificationParser parser = PatternSpecificationParser.getInstance(Byte.TYPE);
        for (int k = 0; k < patterns.length; ++k) {
            patterns[k] = parser.parse(patternsDescriptions[k]);
        }
        return patterns;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TransformOperation {
        EROSION{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatablePArray>> getProcessor(Morphology morphology, Class<? extends UpdatablePArray> requiredType, Matrix<? extends PArray> matrix, Pattern[] patterns) {
                return IterativeErosion.getInstance((Morphology)morphology, requiredType, matrix, (Pattern[])patterns);
            }
        }
        ,
        OPENING{

            @Override
            IterativeArrayProcessor<Matrix<? extends UpdatablePArray>> getProcessor(Morphology morphology, Class<? extends UpdatablePArray> requiredType, Matrix<? extends PArray> matrix, Pattern[] patterns) {
                return IterativeOpening.getInstance((Morphology)morphology, requiredType, matrix, (Pattern[])patterns);
            }
        };


        abstract IterativeArrayProcessor<Matrix<? extends UpdatablePArray>> getProcessor(Morphology var1, Class<? extends UpdatablePArray> var2, Matrix<? extends PArray> var3, Pattern[] var4);
    }

    public static enum ResultElementType {
        BYTE(Byte.TYPE),
        SHORT(Short.TYPE),
        INT(Integer.TYPE),
        FLOAT(Float.TYPE);

        final Class<?> elementType;

        private ResultElementType(Class<?> elementType) {
            this.elementType = elementType;
        }
    }
}

