/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc.extremums;

import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatableBitArray;
import net.algart.executors.modules.cv.matrices.misc.SortedRound2DAperture;
import net.algart.executors.modules.cv.matrices.misc.extremums.ExtremumsFinder;
import net.algart.executors.modules.cv.matrices.misc.extremums.MinimumsFinder;

class MinimumsFinderWithoutMask
extends MinimumsFinder {
    MinimumsFinderWithoutMask(float[] values, SortedRound2DAperture aperture, ExtremumsFinder.DeepTestSettings deepTestSettings, Matrix<UpdatableBitArray> resultExtremums, boolean buildListOfExtremumsXY) {
        super(values, null, aperture, deepTestSettings, resultExtremums, buildListOfExtremumsXY);
    }

    @Override
    boolean horizontalCheck(int index0) {
        float v0 = this.values[index0];
        for (int k = 1; k <= this.maxRadius; ++k) {
            if (!(this.values[index0 - k] < v0) && !(this.values[index0 + k] < v0)) continue;
            return false;
        }
        return true;
    }

    @Override
    void quickCheck(int index0) {
        int k;
        float v0 = this.values[index0];
        for (k = 1; k <= this.maxRadius; ++k) {
            if (!(this.values[index0 - k] < v0) && !(this.values[index0 + k] < v0)) continue;
            return;
        }
        for (k = 0; k < this.apertureCountWithoutLine; ++k) {
            if (!(this.values[index0 - this.apertureOffsets[k]] < v0)) continue;
            return;
        }
        this.neighboursCount = this.apertureCount;
        this.processExtremum(index0, this.apertureOffsets);
    }

    @Override
    void detailedCheck(int index0) {
        int x0 = index0 - this.valuesStart;
        int y0 = this.y;
        float v0 = this.values[index0];
        int dimX = this.dimX;
        int dimY = this.dimY;
        int[] dx = this.aperture.dx();
        int[] dy = this.aperture.dy();
        int count = 0;
        for (int k = 0; k < this.apertureCount; ++k) {
            int x = x0 - dx[k];
            int y = y0 - dy[k];
            if (x < 0 || y < 0 || x >= dimX || y >= dimY) continue;
            int offset = this.apertureOffsets[k];
            int index = index0 - offset;
            if (this.values[index] < v0) {
                return;
            }
            this.neighbourOffsets[count++] = offset;
        }
        this.neighboursCount = count;
        this.processExtremum(index0, this.neighbourOffsets);
    }
}

