/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.filtering;

import java.util.Locale;
import java.util.function.Function;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.matrices.filters3x3.AbstractQuickFilter3x3;
import net.algart.matrices.filters3x3.DilationByCross3x3;
import net.algart.matrices.filters3x3.DilationBySquare3x3;
import net.algart.matrices.filters3x3.ErosionByCross3x3;
import net.algart.matrices.filters3x3.ErosionBySquare3x3;
import net.algart.multimatrix.MultiMatrix;

public class SimpleMorphology3x3
extends MultiMatrixFilter {
    private Operation operation = Operation.DILATION;
    private Shape shape = Shape.CROSS;

    public Operation operation() {
        return this.operation;
    }

    public SimpleMorphology3x3 setOperation(Operation operation) {
        this.operation = (Operation)((Object)SimpleMorphology3x3.nonNull((Object)((Object)operation)));
        return this;
    }

    public Shape shape() {
        return this.shape;
    }

    public SimpleMorphology3x3 setShape(Shape shape) {
        this.shape = (Shape)((Object)SimpleMorphology3x3.nonNull((Object)((Object)shape)));
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        long t1 = SimpleMorphology3x3.debugTime();
        AbstractQuickFilter3x3 dilation = this.shape.getDilation.apply(source);
        AbstractQuickFilter3x3 erosion = this.shape.getErosion.apply(source);
        long t2 = SimpleMorphology3x3.debugTime();
        MultiMatrix result = source.mapChannels(matrix -> this.operation.perform((Matrix<? extends PArray>)matrix, dilation, erosion));
        long t3 = SimpleMorphology3x3.debugTime();
        SimpleMorphology3x3.logDebug(() -> String.format(Locale.US, "Simple 3x3 %s by %s of %s calculated in %.3f ms: %.3f initializing, %.3f processing", this.operation.name().toLowerCase(), this.shape.name().toLowerCase(), source, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return result;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Operation {
        DILATION{

            @Override
            Matrix<? extends UpdatablePArray> perform(Matrix<? extends PArray> matrix, AbstractQuickFilter3x3 dilation, AbstractQuickFilter3x3 erosion) {
                return dilation.filter(matrix);
            }
        }
        ,
        EROSION{

            @Override
            Matrix<? extends UpdatablePArray> perform(Matrix<? extends PArray> matrix, AbstractQuickFilter3x3 dilation, AbstractQuickFilter3x3 erosion) {
                return erosion.filter(matrix);
            }
        }
        ,
        CLOSING{

            @Override
            Matrix<? extends UpdatablePArray> perform(Matrix<? extends PArray> matrix, AbstractQuickFilter3x3 dilation, AbstractQuickFilter3x3 erosion) {
                return erosion.filter(dilation.filter(matrix));
            }
        }
        ,
        OPENING{

            @Override
            Matrix<? extends UpdatablePArray> perform(Matrix<? extends PArray> matrix, AbstractQuickFilter3x3 dilation, AbstractQuickFilter3x3 erosion) {
                return dilation.filter(erosion.filter(matrix));
            }
        };


        abstract Matrix<? extends UpdatablePArray> perform(Matrix<? extends PArray> var1, AbstractQuickFilter3x3 var2, AbstractQuickFilter3x3 var3);
    }

    public static enum Shape {
        CROSS(matrix -> DilationByCross3x3.newInstance((Class)matrix.elementType(), (long[])matrix.dimensions()), matrix -> ErosionByCross3x3.newInstance((Class)matrix.elementType(), (long[])matrix.dimensions())),
        SQUARE(matrix -> DilationBySquare3x3.newInstance((Class)matrix.elementType(), (long[])matrix.dimensions()), matrix -> ErosionBySquare3x3.newInstance((Class)matrix.elementType(), (long[])matrix.dimensions()));

        private final Function<MultiMatrix, AbstractQuickFilter3x3> getDilation;
        private final Function<MultiMatrix, AbstractQuickFilter3x3> getErosion;

        private Shape(Function<MultiMatrix, AbstractQuickFilter3x3> getDilation, Function<MultiMatrix, AbstractQuickFilter3x3> getErosion) {
            this.getDilation = getDilation;
            this.getErosion = getErosion;
        }
    }
}

