/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.filtering;

import java.util.Locale;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.matrices.filters3x3.MedianBySquare3x3;
import net.algart.matrices.filters3x3.PercentileBySquare3x3;
import net.algart.multimatrix.MultiMatrix;

public class Percentile3x3
extends MultiMatrixFilter {
    private int percentileIndex = 4;
    private boolean specialAlgorithmWhenPossible = true;

    public int getPercentileIndex() {
        return this.percentileIndex;
    }

    public Percentile3x3 setPercentileIndex(int percentileIndex) {
        this.percentileIndex = Percentile3x3.inRange((int)percentileIndex, (int)0, (int)8);
        return this;
    }

    public boolean isSpecialAlgorithmWhenPossible() {
        return this.specialAlgorithmWhenPossible;
    }

    public Percentile3x3 setSpecialAlgorithmWhenPossible(boolean specialAlgorithmWhenPossible) {
        this.specialAlgorithmWhenPossible = specialAlgorithmWhenPossible;
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        long t1 = Percentile3x3.debugTime();
        PercentileBySquare3x3 percentile = PercentileBySquare3x3.newInstance((Class)source.elementType(), (long[])source.dimensions(), (int)this.percentileIndex, (boolean)this.specialAlgorithmWhenPossible);
        long t2 = Percentile3x3.debugTime();
        MultiMatrix result = source.mapChannels(arg_0 -> ((PercentileBySquare3x3)percentile).filter(arg_0));
        long t3 = Percentile3x3.debugTime();
        Percentile3x3.logDebug(() -> String.format(Locale.US, "3x3 %s of %s calculated in %.3f ms: %.3f initializing, %.3f percentile", percentile instanceof MedianBySquare3x3 ? "median" : "percentile #" + this.percentileIndex, source, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return result;
    }
}

