/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.filtering;

import java.util.Locale;
import net.algart.executors.modules.core.common.matrices.MultiMatrixFilter;
import net.algart.matrices.filters3x3.AverageBySquare3x3;
import net.algart.multimatrix.MultiMatrix;

public class Average3x3
extends MultiMatrixFilter {
    private boolean rounding = true;

    public boolean isRounding() {
        return this.rounding;
    }

    public Average3x3 setRounding(boolean rounding) {
        this.rounding = rounding;
        return this;
    }

    public MultiMatrix process(MultiMatrix source) {
        long t1 = Average3x3.debugTime();
        AverageBySquare3x3 average = AverageBySquare3x3.newInstance((Class)source.elementType(), (long[])source.dimensions(), (boolean)this.rounding);
        long t2 = Average3x3.debugTime();
        MultiMatrix result = source.mapChannels(arg_0 -> ((AverageBySquare3x3)average).filter(arg_0));
        long t3 = Average3x3.debugTime();
        Average3x3.logDebug(() -> String.format(Locale.US, "3x3 average of %s calculated in %.3f ms: %.3f initializing, %.3f average", source, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return result;
    }
}

