/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc.slopes;

import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.stream.IntStream;
import net.algart.arrays.JArrays;
import net.algart.executors.modules.cv.matrices.misc.slopes.SlopeEmphasizer;

public class SlopeEmphasizerSimpleTest {
    private static String bytesToString(byte[] values) {
        int[] ints = IntStream.range(0, values.length).map(k -> values[k] & 0xFF).toArray();
        return JArrays.toString((int[])ints, (Locale)Locale.US, (String)"%5d", (String)", ", (int)1000);
    }

    private static String shortsToString(short[] values) {
        int[] ints = IntStream.range(0, values.length).map(k -> values[k] & 0xFFFF).toArray();
        return JArrays.toString((short[])values, (Locale)Locale.US, (String)"%7d", (String)", ", (int)1000);
    }

    private static String longsToString(long[] values) {
        return JArrays.toString((long[])values, (Locale)Locale.US, (String)"%9d", (String)", ", (int)1000);
    }

    private static String floatsToString(float[] values) {
        return JArrays.toString((float[])values, (Locale)Locale.US, (String)"%5.1f", (String)", ", (int)1000);
    }

    public static void main(String[] args) {
        int k;
        float[] floats;
        byte[] bytes;
        SlopeEmphasizer emphasizer = SlopeEmphasizer.getInstance().setSlopeWidth(5).setMinimalChange(5.0).setProcessAscending(true).setProcessDescending(true).setAllowLongSlopes(true).setExactHalfSum(true);
        Random rnd = new Random(231L);
        for (int test = 1000000; test >= 0; --test) {
            bytes = new byte[(rnd.nextInt() & 0xFFFF) % 100];
            short[] shorts = new short[bytes.length];
            long[] longs = new long[bytes.length];
            floats = new float[bytes.length];
            emphasizer.setAllowLongSlopes(rnd.nextInt() % 2 == 0);
            emphasizer.setSlopeWidth(1 + (rnd.nextInt() & 0xF));
            emphasizer.setMinimalChange((double)(rnd.nextInt() & 0xFF));
            for (int k2 = 0; k2 < bytes.length; ++k2) {
                bytes[k2] = (byte)rnd.nextInt();
                floats[k2] = bytes[k2] & 0xFF;
                shorts[k2] = (short)rnd.nextInt();
                longs[k2] = (long)rnd.nextInt() | (long)rnd.nextInt() << 32;
            }
            byte[] bytesClone = (byte[])bytes.clone();
            short[] shortsClone = (short[])shorts.clone();
            long[] longsClone = (long[])longs.clone();
            float[] floatsClone = (float[])floats.clone();
            emphasizer.emphasize(bytes, 0, bytes.length);
            emphasizer.emphasize(shorts, 0, shorts.length);
            emphasizer.emphasize(longs, 0, longs.length);
            emphasizer.emphasize(floats, 0, floats.length);
            int errorPosition = -1;
            for (int k3 = 0; k3 < bytes.length; ++k3) {
                if (floats[k3] == (float)(bytes[k3] & 0xFF)) continue;
                errorPosition = k3;
                break;
            }
            if (test <= 20 || errorPosition >= 0) {
                System.out.println(SlopeEmphasizerSimpleTest.shortsToString(shortsClone));
                System.out.println(SlopeEmphasizerSimpleTest.shortsToString(shorts));
                System.out.println();
                System.out.println(SlopeEmphasizerSimpleTest.longsToString(longsClone));
                System.out.println(SlopeEmphasizerSimpleTest.longsToString(longs));
                System.out.println();
                System.out.println(SlopeEmphasizerSimpleTest.bytesToString(bytesClone));
                System.out.println(SlopeEmphasizerSimpleTest.bytesToString(bytes));
                System.out.println();
                System.out.println(SlopeEmphasizerSimpleTest.floatsToString(floatsClone));
                System.out.println(SlopeEmphasizerSimpleTest.floatsToString(floats));
                System.out.println();
            }
            if (errorPosition >= 0) {
                emphasizer.emphasize(bytesClone, 0, bytes.length);
                emphasizer.emphasize(floatsClone, 0, floats.length);
                throw new AssertionError((Object)("Difference in emphasizing! " + errorPosition));
            }
            if (emphasizer.getSlopeWidth() == 1 && emphasizer.getMinimalChange() != 0.0 && !Arrays.equals(bytes, bytesClone)) {
                throw new AssertionError((Object)"Slope width = 1 cannot change an array!");
            }
        }
        emphasizer.setSlopeWidth(5).setMinimalChange(5.0).setProcessAscending(true).setProcessDescending(true).setAllowLongSlopes(true).setExactHalfSum(false);
        bytes = new byte[190];
        for (k = 0; k < bytes.length; ++k) {
            bytes[k] = (byte)rnd.nextInt();
        }
        System.out.println(SlopeEmphasizerSimpleTest.bytesToString(bytes));
        emphasizer.emphasize(bytes, 0, bytes.length);
        System.out.println(SlopeEmphasizerSimpleTest.bytesToString(bytes));
        System.out.println();
        bytes = new byte[]{2, 2, 3, 6, 11, 10, 20, 30, 14, 13, 12, 0, 1, 2, 2};
        floats = new float[bytes.length];
        for (k = 0; k < bytes.length; ++k) {
            floats[k] = bytes[k] & 0xFF;
        }
        System.out.println(SlopeEmphasizerSimpleTest.bytesToString(bytes));
        emphasizer.emphasize(bytes);
        System.out.println(SlopeEmphasizerSimpleTest.bytesToString(bytes));
        emphasizer.emphasize(floats);
        System.out.println(SlopeEmphasizerSimpleTest.floatsToString(floats));
        System.out.println();
    }
}

