/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.common.UMatFilter;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Median
extends UMatFilter {
    private int kernelSize = 5;

    public int getKernelSize() {
        return this.kernelSize;
    }

    public void setKernelSize(int kernelSize) {
        this.kernelSize = Median.positive((int)kernelSize);
    }

    @Override
    public Mat process(Mat source) {
        int kernelSize = this.kernelSize | 1;
        Median.logDebug(() -> "Median with kernel size " + kernelSize + " (source: " + source + ")");
        opencv_imgproc.medianBlur((Mat)source, (Mat)source, (int)kernelSize);
        return source;
    }

    @Override
    public UMat process(UMat source) {
        int kernelSize = this.kernelSize | 1;
        Median.logDebug(() -> "Median (GPU) with kernel size " + kernelSize + " (source: " + source + ")");
        opencv_imgproc.medianBlur((UMat)source, (UMat)source, (int)kernelSize);
        return source;
    }
}

