/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.labels;

import net.algart.executors.modules.cv.matrices.objects.labels.CardinalitiesAndSumsOfSquaresCalculator;

abstract class CardinalitiesAndSumsOfSquaresCalculator2Channels
extends CardinalitiesAndSumsOfSquaresCalculator {
    CardinalitiesAndSumsOfSquaresCalculator2Channels(int[] labels) {
        super(labels, 2);
    }

    static class ForDoubles
    extends CardinalitiesAndSumsOfSquaresCalculator2Channels {
        private final double[] data0;
        private final double[] data1;

        public ForDoubles(int[] labels, double[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForDoubles.ensureCapacityForLabel(cardinalities, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForDoubles.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                double value1 = this.data1[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sumsOfSquares0[n4] = sumsOfSquares0[n4] + value0 * value0;
                int n5 = label;
                sumsOfSquares1[n5] = sumsOfSquares1[n5] + value1 * value1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForFloats
    extends CardinalitiesAndSumsOfSquaresCalculator2Channels {
        private final float[] data0;
        private final float[] data1;

        public ForFloats(int[] labels, float[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForFloats.ensureCapacityForLabel(cardinalities, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForFloats.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                double value1 = this.data1[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sumsOfSquares0[n4] = sumsOfSquares0[n4] + value0 * value0;
                int n5 = label;
                sumsOfSquares1[n5] = sumsOfSquares1[n5] + value1 * value1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForInts
    extends CardinalitiesAndSumsOfSquaresCalculator2Channels {
        private final int[] data0;
        private final int[] data1;

        public ForInts(int[] labels, int[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForInts.ensureCapacityForLabel(cardinalities, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForInts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k];
                double value1 = this.data1[k];
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sumsOfSquares0[n4] = sumsOfSquares0[n4] + value0 * value0;
                int n5 = label;
                sumsOfSquares1[n5] = sumsOfSquares1[n5] + value1 * value1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForShorts
    extends CardinalitiesAndSumsOfSquaresCalculator2Channels {
        private final short[] data0;
        private final short[] data1;

        public ForShorts(int[] labels, short[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForShorts.ensureCapacityForLabel(cardinalities, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForShorts.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k] & 0xFFFF;
                double value1 = this.data1[k] & 0xFFFF;
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sumsOfSquares0[n4] = sumsOfSquares0[n4] + value0 * value0;
                int n5 = label;
                sumsOfSquares1[n5] = sumsOfSquares1[n5] + value1 * value1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }

    static class ForBytes
    extends CardinalitiesAndSumsOfSquaresCalculator2Channels {
        private final byte[] data0;
        private final byte[] data1;

        public ForBytes(int[] labels, byte[][] data) {
            super(labels);
            this.data0 = data[0];
            this.data1 = data[1];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            int k;
            int[] cardinalities = this.threadCardinalities[threadIndex];
            double[][] sums = this.threadSums[threadIndex];
            double[][] sumsOfSquares = this.threadSumsOfSquares[threadIndex];
            double[] sums0 = sums[0];
            double[] sums1 = sums[1];
            double[] sumsOfSquares0 = sumsOfSquares[0];
            double[] sumsOfSquares1 = sumsOfSquares[1];
            int kMax = k + count;
            for (k = p; k < kMax; ++k) {
                int label = this.labels[k];
                if (label <= 0) continue;
                if (label >= cardinalities.length) {
                    cardinalities = ForBytes.ensureCapacityForLabel(cardinalities, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sumsOfSquares, label);
                    ForBytes.ensureSeveralArraysCapacityForLabel(sums, label);
                    sums0 = sums[0];
                    sums1 = sums[1];
                    sumsOfSquares0 = sumsOfSquares[0];
                    sumsOfSquares1 = sumsOfSquares[1];
                }
                int n = label;
                cardinalities[n] = cardinalities[n] + 1;
                double value0 = this.data0[k] & 0xFF;
                double value1 = this.data1[k] & 0xFF;
                int n2 = label;
                sums0[n2] = sums0[n2] + value0;
                int n3 = label;
                sums1[n3] = sums1[n3] + value1;
                int n4 = label;
                sumsOfSquares0[n4] = sumsOfSquares0[n4] + value0 * value0;
                int n5 = label;
                sumsOfSquares1[n5] = sumsOfSquares1[n5] + value1 * value1;
            }
            this.threadCardinalities[threadIndex] = cardinalities;
        }
    }
}

