/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.awt.AWTDrawer;
import net.algart.executors.modules.cv.matrices.drawing.PositionsAndColors;

public final class DrawStraight
extends AWTDrawer {
    public static final String INPUT_POSITIONS = "positions";
    public static final String INPUT_COLORS = "colors";
    private boolean percents = false;
    private double x = 0.0;
    private double y = 0.0;
    private double angleInDegree = 0.0;
    private double thickness = 1.0;

    public DrawStraight() {
        this.addInputNumbers(INPUT_POSITIONS);
        this.addInputNumbers(INPUT_COLORS);
    }

    public boolean isPercents() {
        return this.percents;
    }

    public DrawStraight setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public DrawStraight setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public DrawStraight setY(double y) {
        this.y = y;
        return this;
    }

    public double getAngleInDegree() {
        return this.angleInDegree;
    }

    public void setAngleInDegree(double angleInDegree) {
        this.angleInDegree = angleInDegree;
    }

    public double getThickness() {
        return this.thickness;
    }

    public DrawStraight setThickness(double thickness) {
        this.thickness = DrawStraight.nonNegative((double)thickness);
        return this;
    }

    public void process(Graphics2D g, int dimX, int dimY) {
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        SNumbers colors = this.getInputNumbers(INPUT_COLORS, true);
        double defaultX = this.percents ? this.x / 100.0 * (double)(dimX - 1) : this.x;
        double defaultY = this.percents ? this.y / 100.0 * (double)(dimY - 1) : this.y;
        double angle = StrictMath.toRadians(this.angleInDegree);
        double cos = StrictMath.cos(angle);
        double sin = StrictMath.sin(angle);
        PositionsAndColors positionsAndColors = new PositionsAndColors(positions, colors, new double[]{defaultX, defaultY}, Double.NaN, 2);
        g.setStroke(new BasicStroke((float)this.thickness));
        for (int k = 0; k < positionsAndColors.n; ++k) {
            double x = positionsAndColors.x(k);
            double y = positionsAndColors.y(k);
            float[] rgb = positionsAndColors.colorRGB(k);
            g.setColor(rgb == null ? this.getColor() : new Color(DrawStraight.truncateColor01((float)rgb[0]), DrawStraight.truncateColor01((float)rgb[1]), DrawStraight.truncateColor01((float)rgb[2])));
            double[] x1y1x2y2 = DrawStraight.findX1Y1X2Y2(x, y, cos, sin, dimX, dimY);
            g.drawLine((int)x1y1x2y2[0], (int)x1y1x2y2[1], (int)x1y1x2y2[2], (int)x1y1x2y2[3]);
        }
    }

    private static double[] findX1Y1X2Y2(double x0, double y0, double cos, double sin, double dimX, double dimY) {
        if (Math.abs(cos) >= Math.abs(sin)) {
            double tangent = sin / cos;
            double y1 = y0 - tangent * x0;
            double y2 = y0 + tangent * (dimX - 1.0 - x0);
            return new double[]{0.0, y1, dimX - 1.0, y2};
        }
        double cotangent = cos / sin;
        double x1 = x0 - cotangent * y0;
        double x2 = x0 + cotangent * (dimY - 1.0 - y0);
        return new double[]{x1, 0.0, x2, dimY - 1.0};
    }
}

