/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.MutableBitArray;
import net.algart.arrays.MutableByteArray;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.SelectConstantFunc;

public final class SimpleOperationsSpeed {
    private static final int n = 0x400000;

    private static void time(String name, long t1, long t2) {
        System.out.printf("%-36s %.6f ms, %.6f ns/element, %.3f Giga-element/second %n", name + ":", (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 4194304.0, 4194304.0 / (double)(t2 - t1));
    }

    private static void setBitNonParallel(long[] dest, long index, boolean value) {
        if (value) {
            int n = (int)(index >>> 6);
            dest[n] = dest[n] | 1L << (int)(index & 0x3FL);
        } else {
            int n = (int)(index >>> 6);
            dest[n] = dest[n] & (1L << (int)(index & 0x3FL) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static void main(String[] args) {
        MutableBitArray mask = net.algart.arrays.Arrays.SMM.newBitArray(0x400000L);
        MutableBitArray bitArray = net.algart.arrays.Arrays.SMM.newBitArray(0x400000L);
        MutableByteArray byteArray = net.algart.arrays.Arrays.SMM.newByteArray(0x400000L);
        MutableIntArray intArray = net.algart.arrays.Arrays.SMM.newIntArray(0x400000L);
        long[] bits = new long[(int)PackedBitArrays.packedLength((long)0x400000L)];
        Random rnd = new Random(157L);
        for (int k2 = 0; k2 < 0x400000; ++k2) {
            if (rnd.nextInt(3) != 0) continue;
            mask.setBit((long)k2);
        }
        double someInfo = 0.0;
        long[] histogram = new long[256];
        for (int test = 1; test <= 32; ++test) {
            int k3;
            int k4;
            int k5;
            int k6;
            int k7;
            int k8;
            System.gc();
            System.out.printf("%nSpeed test #%d (%d numbers)%n", test, 0x400000);
            long t1 = System.nanoTime();
            int[] ints = new int[0x400000];
            long t2 = System.nanoTime();
            SimpleOperationsSpeed.time("new int[]", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            long[] longs = new long[0x400000];
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("new long[]", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            byte[] bytes = new byte[0x400000];
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("new byte[]", t1, t2);
            someInfo += (double)System.identityHashCode(bytes);
            t1 = System.nanoTime();
            double[] doubles = new double[0x400000];
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("new double[]", t1, t2);
            someInfo += (double)System.identityHashCode(doubles);
            t1 = System.nanoTime();
            byte[] byteClone = (byte[])bytes.clone();
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("byte[].clone()", t1, t2);
            someInfo += (double)System.identityHashCode(byteClone);
            t1 = System.nanoTime();
            int[] intClone = (int[])ints.clone();
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("int[].clone()", t1, t2);
            someInfo += (double)System.identityHashCode(intClone);
            t1 = System.nanoTime();
            double[] doubleClone = (double[])doubles.clone();
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("double[].clone()", t1, t2);
            someInfo += (double)System.identityHashCode(doubleClone);
            t1 = System.nanoTime();
            System.arraycopy(bytes, 0, byteClone, 0, bytes.length);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("arraycopy(byte[],...)", t1, t2);
            someInfo += (double)System.identityHashCode(intClone);
            t1 = System.nanoTime();
            System.arraycopy(ints, 0, intClone, 0, ints.length);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("arraycopy(int[],...)", t1, t2);
            someInfo += (double)System.identityHashCode(intClone);
            t1 = System.nanoTime();
            Arrays.sort(intClone);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("sort(int[])", t1, t2);
            someInfo += (double)System.identityHashCode(intClone);
            System.arraycopy(ints, 0, intClone, 0, ints.length);
            t1 = System.nanoTime();
            Arrays.parallelSort(intClone);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("parallelSort(int[])", t1, t2);
            someInfo += (double)System.identityHashCode(intClone);
            t1 = System.nanoTime();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x400000);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("ByteBuffer.allocate[]", t1, t2);
            someInfo += (double)System.identityHashCode(byteBuffer);
            t1 = System.nanoTime();
            ByteBuffer byteBufferDirect = ByteBuffer.allocateDirect(0x400000);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("ByteBuffer.allocateDirect[]", t1, t2);
            someInfo += (double)System.identityHashCode(byteBufferDirect);
            t1 = System.nanoTime();
            JArrays.fillByteArray((byte[])bytes, (byte)1);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("JArrays.fillByteArray", t1, t2);
            someInfo += (double)System.identityHashCode(bytes);
            t1 = System.nanoTime();
            Arrays.fill(bytes, (byte)1);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("Arrays.fill(byte[])", t1, t2);
            someInfo += (double)System.identityHashCode(bytes);
            t1 = System.nanoTime();
            JArrays.fillIntArray((int[])ints, (int)1);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("JArrays.fillIntArray", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            Arrays.fill(ints, 1);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("Arrays.fill(int[])", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            IntStream.range(0, 4096).parallel().forEach(b -> {
                int from = b << 10;
                int to = Math.min(0x400000, from + 1024);
                Arrays.fill(ints, from, to, 1);
            });
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("parallel block Arrays.fill(int[])", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            Arrays.parallelSetAll(ints, operand -> 1);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("Arrays.parallelSetAll(int[])", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            new IntFiller(ints).process();
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("IntFiller(int[])", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            JArrays.fillDoubleArray((double[])doubles, (double)0.0);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("JArrays.fillDoubleArray", t1, t2);
            someInfo += (double)System.identityHashCode(doubles);
            t1 = System.nanoTime();
            Arrays.fill(doubles, 0.0);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("Arrays.fill(double[])", t1, t2);
            someInfo += (double)System.identityHashCode(doubles);
            t1 = System.nanoTime();
            Arrays.parallelSetAll(doubles, operand -> 0.0);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("Arrays.parallelSetAll(doubles[])", t1, t2);
            someInfo += (double)System.identityHashCode(ints);
            t1 = System.nanoTime();
            UpdatableByteArray array = SimpleMemoryModel.asUpdatableByteArray((byte[])bytes);
            net.algart.arrays.Arrays.applyFunc(null, (boolean)false, (Func)SelectConstantFunc.getInstance((double[])new double[]{0.0, 255.0}), (UpdatablePArray)array, (PArray[])new PArray[]{mask});
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("unpackBits via applyFunc (->byte)", t1, t2);
            t1 = System.nanoTime();
            net.algart.arrays.Arrays.unpackBits((UpdatablePArray)SimpleMemoryModel.asUpdatableByteArray((byte[])bytes), (BitArray)mask, (double)0.0, (double)255.0);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("unpackBits() (->byte)", t1, t2);
            t1 = System.nanoTime();
            net.algart.arrays.Arrays.unpackZeroBits((UpdatablePArray)SimpleMemoryModel.asUpdatableIntArray((int[])ints), (BitArray)mask, (double)0.0);
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("unpackZeroBits() (->int)", t1, t2);
            t1 = System.nanoTime();
            for (k8 = 0; k8 < 0x400000; ++k8) {
                bitArray.setBit((long)k8, true);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("setBit", t1, t2);
            t1 = System.nanoTime();
            for (k8 = 0; k8 < 0x400000; ++k8) {
                PackedBitArrays.setBit((long[])bits, (long)k8, (boolean)true);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("PackedBitArrays.setBit", t1, t2);
            t1 = System.nanoTime();
            for (k8 = 0; k8 < 0x400000; ++k8) {
                SimpleOperationsSpeed.setBitNonParallel(bits, k8, true);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("setBitNonParallel", t1, t2);
            t1 = System.nanoTime();
            boolean bit = false;
            for (k7 = 0; k7 < 0x400000; ++k7) {
                bit |= bitArray.getBit((long)k7);
            }
            t2 = System.nanoTime();
            someInfo += (double)(bit ? 1 : 2);
            SimpleOperationsSpeed.time("getBit", t1, t2);
            t1 = System.nanoTime();
            for (k7 = 0; k7 < 0x400000; ++k7) {
                byteArray.setByte((long)k7, (byte)k7);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("setByte(k,k)", t1, t2);
            t1 = System.nanoTime();
            int byteSum = 0;
            for (k6 = 0; k6 < 0x400000; ++k6) {
                byteSum += byteArray.getByte((long)k6);
            }
            t2 = System.nanoTime();
            someInfo += (double)byteSum;
            SimpleOperationsSpeed.time("sum += getByte(k)", t1, t2);
            t1 = System.nanoTime();
            for (k6 = 0; k6 < 0x400000; ++k6) {
                intArray.setInt((long)k6, k6);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("setInt(k,k)", t1, t2);
            t1 = System.nanoTime();
            int intSum = 0;
            for (k5 = 0; k5 < 0x400000; ++k5) {
                intSum += intArray.getInt((long)k5);
            }
            t2 = System.nanoTime();
            someInfo += (double)intSum;
            SimpleOperationsSpeed.time("sum += getInt(k)", t1, t2);
            t1 = System.nanoTime();
            for (k5 = 0; k5 < 0x400000; ++k5) {
                ints[k5] = k5;
            }
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(ints[0x200000]);
            SimpleOperationsSpeed.time("simple ints[k]=k", t1, t2);
            t1 = System.nanoTime();
            intSum = 0;
            for (k5 = 0; k5 < 0x400000; ++k5) {
                intSum += ints[k5];
            }
            t2 = System.nanoTime();
            someInfo += (double)intSum;
            SimpleOperationsSpeed.time("sum += ints[k]", t1, t2);
            t1 = System.nanoTime();
            intSum = 0;
            for (k5 = 0; k5 < 0x400000; ++k5) {
                intSum += k5;
            }
            t2 = System.nanoTime();
            someInfo += (double)intSum;
            SimpleOperationsSpeed.time("sum += k (int)", t1, t2);
            t1 = System.nanoTime();
            intSum = 0;
            for (k5 = 0; k5 < 0x400000; ++k5) {
                intSum += k5 / 9;
            }
            t2 = System.nanoTime();
            someInfo += (double)intSum;
            SimpleOperationsSpeed.time("sum += k / 9 (int)", t1, t2);
            double MULTIPLIER = 0.1111111111111111;
            t1 = System.nanoTime();
            intSum = 0;
            for (k4 = 0; k4 < 0x400000; ++k4) {
                intSum += (int)((double)k4 * 0.1111111111111111);
            }
            t2 = System.nanoTime();
            someInfo += (double)intSum;
            SimpleOperationsSpeed.time("sum += k * (1.0/9.0) (int)", t1, t2);
            t1 = System.nanoTime();
            intSum = 0;
            for (k4 = 1; k4 <= 0x400000; ++k4) {
                intSum += 0x400000 / k4;
            }
            t2 = System.nanoTime();
            someInfo += (double)intSum;
            SimpleOperationsSpeed.time("sum += n / k (int)", t1, t2);
            t1 = System.nanoTime();
            for (k4 = 0; k4 < 0x400000; ++k4) {
                ints[k4] = 1;
            }
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(ints[0x200000]);
            SimpleOperationsSpeed.time("simple ints[k]=1", t1, t2);
            t1 = System.nanoTime();
            for (k4 = 0; k4 < 0x400000; ++k4) {
                longs[k4] = k4;
            }
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(longs[0x200000]);
            SimpleOperationsSpeed.time("simple longs[k]=k", t1, t2);
            t1 = System.nanoTime();
            long longSum = 0L;
            for (int k9 = 0; k9 < 0x400000; ++k9) {
                longSum += longs[k9];
            }
            t2 = System.nanoTime();
            someInfo += (double)longSum;
            SimpleOperationsSpeed.time("sum += longs[k]", t1, t2);
            t1 = System.nanoTime();
            longSum = 0L;
            for (long k10 = 0L; k10 < 0x400000L; ++k10) {
                longSum += k10;
            }
            t2 = System.nanoTime();
            someInfo += (double)longSum;
            SimpleOperationsSpeed.time("sum += k (long)", t1, t2);
            t1 = System.nanoTime();
            for (int k11 = 0; k11 < 0x400000; ++k11) {
                longs[k11] = 1L;
            }
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(longs[0x200000]);
            SimpleOperationsSpeed.time("simple longs[k]=1", t1, t2);
            t1 = System.nanoTime();
            IntStream.range(0, 0x400000).parallel().forEach(k -> {
                ints[k] = k;
            });
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(ints[10]);
            SimpleOperationsSpeed.time("parallel ints[k]=k", t1, t2);
            t1 = System.nanoTime();
            IntStream.range(0, 4096).parallel().forEach(b -> {
                int k;
                int to = Math.min(0x400000, k + 1024);
                for (k = b << 10; k < to; ++k) {
                    ints[k] = k;
                }
            });
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(ints[10]);
            SimpleOperationsSpeed.time("parallel block ints[k]=k", t1, t2);
            int[] cardinalities = new int[0x400000];
            t1 = System.nanoTime();
            for (int k12 = 0; k12 < 0x400000; ++k12) {
                int n = ints[k12];
                cardinalities[n] = cardinalities[n] + 1;
            }
            t2 = System.nanoTime();
            someInfo += (double)System.identityHashCode(cardinalities);
            SimpleOperationsSpeed.time("cardinalities[...]++", t1, t2);
            t1 = System.nanoTime();
            Range range = net.algart.arrays.Arrays.rangeOf((PArray)SimpleMemoryModel.asUpdatableIntArray((int[])ints));
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("rangeOf()", t1, t2);
            someInfo += range.size();
            t1 = System.nanoTime();
            net.algart.arrays.Arrays.histogramOf((PArray)SimpleMemoryModel.asUpdatableIntArray((int[])ints), (long[])histogram, (double)range.min(), (double)range.max());
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("histogramOf()", t1, t2);
            someInfo += net.algart.arrays.Arrays.sumOf((PArray)SimpleMemoryModel.asUpdatableLongArray((long[])histogram));
            t1 = System.nanoTime();
            for (int k13 = 0; k13 < 0x400000; ++k13) {
                doubles[k13] = (double)k13 + 0.5;
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("simple doubles[k]=k+0.5", t1, t2);
            double sum = 0.0;
            t1 = System.nanoTime();
            for (int k14 = 0; k14 < 0x400000; ++k14) {
                sum += doubles[k14];
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of doubles", t1, t2);
            someInfo += sum;
            double[][] rgb = new double[][]{doubles, doubles, doubles};
            double[] sums = new double[rgb.length];
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                for (int j = 0; j < 3; ++j) {
                    int n = j;
                    sums[n] = sums[n] + rgb[j][k3];
                }
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing with short loop", t1, t2);
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sums[0] = sums[0] + rgb[0][k3];
                sums[1] = sums[1] + rgb[1][k3];
                sums[2] = sums[2] + rgb[2][k3];
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing with 3 operations", t1, t2);
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += (double)((long)doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of (long)v", t1, t2);
            someInfo += sum;
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += (double)Math.round(doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of Math.round", t1, t2);
            someInfo += sum;
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += Math.rint(doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of Math.rint", t1, t2);
            someInfo += sum;
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += (double)((int)Math.rint(doubles[k3]));
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of (int)Math.rint", t1, t2);
            someInfo += sum;
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += Math.sqrt(doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of Math.sqrt", t1, t2);
            someInfo += sum;
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += Math.pow(2.5, doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of Math.pow", t1, t2);
            someInfo += sum;
            sum = 0.0;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                sum += Math.exp(doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("summing of Math.exp", t1, t2);
            someInfo += sum;
            t1 = System.nanoTime();
            for (k3 = 0; k3 < 0x400000; ++k3) {
                doubleClone[k3] = Math.exp(doubles[k3]);
            }
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("doubles[k]=Math.exp", t1, t2);
            t1 = System.nanoTime();
            IntStream.range(0, 4096).parallel().forEach(b -> {
                int k;
                int to = Math.min(0x400000, k + 1024);
                for (k = b << 10; k < to; ++k) {
                    doubleClone[k] = Math.exp(doubles[k]);
                }
            });
            t2 = System.nanoTime();
            SimpleOperationsSpeed.time("parallel block doubles[k]=Math.exp", t1, t2);
        }
        System.out.printf("%nSome info: %s%n", someInfo);
    }

    private static class IntFiller
    extends Arrays.ParallelExecutor {
        final int[] array;

        IntFiller(int[] array) {
            super(null, null, (Array)SimpleMemoryModel.asUpdatableIntArray((int[])array), 65536, 0, 0L);
            this.array = array;
        }

        protected void processSubArr(long position, int count, int threadIndex) {
            Arrays.fill(this.array, (int)position, (int)position + count, 0);
        }
    }
}

