/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import net.algart.arrays.IntArray;
import net.algart.arrays.PNumberArray;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.NumbersFilter;

public final class GetContourFromArray
extends NumbersFilter
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String OUTPUT_POINTS = "points";
    public static final String OUTPUT_OBJECT_LABEL = "object_label";
    public static final String OUTPUT_INTERNAL_BOUNDARY = "internal_boundary";
    public static final String OUTPUT_FRAME_ID = "frame_id";
    private int contourIndex = 0;
    private boolean unpackContour = true;
    private boolean unpackDiagonals = true;

    public GetContourFromArray() {
        this.setDefaultInputNumbers(INPUT_CONTOURS);
        this.setDefaultOutputNumbers(OUTPUT_POINTS);
        this.addOutputScalar(OUTPUT_OBJECT_LABEL);
        this.addOutputScalar(OUTPUT_INTERNAL_BOUNDARY);
        this.addOutputScalar(OUTPUT_FRAME_ID);
    }

    public int getContourIndex() {
        return this.contourIndex;
    }

    public GetContourFromArray setContourIndex(int contourIndex) {
        this.contourIndex = GetContourFromArray.nonNegative((int)contourIndex);
        return this;
    }

    public boolean isUnpackContour() {
        return this.unpackContour;
    }

    public GetContourFromArray setUnpackContour(boolean unpackContour) {
        this.unpackContour = unpackContour;
        return this;
    }

    public boolean isUnpackDiagonals() {
        return this.unpackDiagonals;
    }

    public GetContourFromArray setUnpackDiagonals(boolean unpackDiagonals) {
        this.unpackDiagonals = unpackDiagonals;
        return this;
    }

    protected SNumbers processNumbers(SNumbers source) {
        Contours contours = Contours.deserialize((int[])source.toIntArray());
        IntArray result = this.unpackContour ? contours.unpackContour(this.contourIndex, this.unpackDiagonals) : contours.getContour(this.contourIndex);
        this.getScalar(OUTPUT_OBJECT_LABEL).setTo(contours.getObjectLabel(this.contourIndex));
        this.getScalar(OUTPUT_INTERNAL_BOUNDARY).setTo(contours.isInternalContour(this.contourIndex) ? 1 : 0);
        Integer frameId = contours.getFrameIdOrNull(this.contourIndex);
        if (frameId != null) {
            this.getScalar(OUTPUT_FRAME_ID).setTo((Object)frameId);
        }
        return new SNumbers().setTo((PNumberArray)result, 2);
    }
}

