/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.List;
import java.util.Locale;
import net.algart.arrays.Arrays;
import net.algart.arrays.IntArray;
import net.algart.arrays.MutableIntArray;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.numbers.SeveralNumbersOperation;

public final class ChangeContourHeaders
extends SeveralNumbersOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_CONTOURS = "contours";
    public static final String INPUT_OBJECT_LABEL = "object_label";
    public static final String INPUT_INTERNAL_BOUNDARY = "internal_boundary";
    public static final String OUTPUT_CONTOURS = "contours";
    private boolean removeFrameId = false;
    private boolean reverseContours = false;

    public ChangeContourHeaders() {
        super(new String[]{"contours", INPUT_OBJECT_LABEL, INPUT_INTERNAL_BOUNDARY});
        this.setDefaultOutputNumbers("contours");
    }

    public boolean isRemoveFrameId() {
        return this.removeFrameId;
    }

    public ChangeContourHeaders setRemoveFrameId(boolean removeFrameId) {
        this.removeFrameId = removeFrameId;
        return this;
    }

    public boolean isReverseContours() {
        return this.reverseContours;
    }

    public ChangeContourHeaders setReverseContours(boolean reverseContours) {
        this.reverseContours = reverseContours;
        return this;
    }

    protected SNumbers processNumbers(List<SNumbers> sources) {
        Runtime rt = Runtime.getRuntime();
        long m1 = rt.totalMemory() - rt.freeMemory();
        long t1 = ChangeContourHeaders.debugTime();
        Contours contours = Contours.deserialize((int[])sources.get(0).toIntArray());
        int[] labels = this.getInputNumbers(INPUT_OBJECT_LABEL, true).toIntArray();
        byte[] internal = this.getInputNumbers(INPUT_INTERNAL_BOUNDARY, true).toByteArray();
        long m2 = rt.totalMemory() - rt.freeMemory();
        long t2 = ChangeContourHeaders.debugTime();
        Contours resultContours = Contours.newInstance();
        ContourHeader header = new ContourHeader();
        MutableIntArray workArray = Arrays.SMM.newEmptyIntArray();
        int n = contours.numberOfContours();
        for (int k = 0; k < n; ++k) {
            contours.getHeader(header, k);
            IntArray contour = contours.getContour(k);
            if (labels != null && k < labels.length) {
                header.setObjectLabel(labels[k]);
            }
            boolean newInternal = header.isInternalContour();
            if (internal != null) {
                if (k < internal.length) {
                    newInternal = internal[k] != 0;
                }
            } else if (this.reverseContours) {
                boolean bl = newInternal = !newInternal;
            }
            if (header.isInternalContour() != newInternal) {
                header.setInternalContour(newInternal);
                contour = Contours.reverseContour((MutableIntArray)workArray, (IntArray)contour);
            }
            if (this.removeFrameId) {
                header.removeFrameId();
            }
            resultContours.addContour(header, contour);
        }
        long m3 = rt.totalMemory() - rt.freeMemory();
        long t3 = ChangeContourHeaders.debugTime();
        SNumbers result = SNumbers.valueOf((Contours)resultContours);
        long m4 = rt.totalMemory() - rt.freeMemory();
        long t4 = ChangeContourHeaders.debugTime();
        ChangeContourHeaders.logDebug(() -> String.format(Locale.US, "Headers of %d contours changed in %.3f ms = %.3f reading (%.1f + %.3f MB) + %.3f changing (+ %.3f MB) + %.3f serializing (+ %.3f MB)", contours.numberOfContours(), (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)m1 / 1048576.0, (double)(m2 - m1) / 1048576.0, (double)(t3 - t2) * 1.0E-6, (double)(m3 - m2) / 1048576.0, (double)(t4 - t3) * 1.0E-6, (double)(m4 - m3) / 1048576.0));
        return result;
    }

    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex != 0;
    }

    protected boolean numberOfBlocksEqualityRequired() {
        return false;
    }

    protected boolean blockLengthEqualityRequired() {
        return false;
    }
}

