/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.objects.binary.boundaries;

import java.util.EnumSet;
import java.util.Objects;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.modules.core.common.matrices.BitMultiMatrixFilter;
import net.algart.executors.modules.cv.matrices.objects.binary.boundaries.BoundaryParameter;
import net.algart.math.Range;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.matrices.scanning.Boundary2DScanner;
import net.algart.matrices.scanning.Boundary2DSimpleMeasurer;
import net.algart.matrices.scanning.ConnectivityType;
import net.algart.matrices.scanning.ContourLineType;

public final class BinaryFilterParticlesOrPoresBySizes
extends BitMultiMatrixFilter {
    private double pixelSize = 1.0;
    private ConnectivityType connectivityType = ConnectivityType.STRAIGHT_AND_DIAGONAL;
    private ParticlesOrPores particlesOrPores = ParticlesOrPores.PORES;
    private Mode mode = Mode.REMOVE;
    private double maxSize = Double.POSITIVE_INFINITY;
    private double maxArea = Double.POSITIVE_INFINITY;
    private double maxPerimeter = Double.POSITIVE_INFINITY;

    public double getPixelSize() {
        return this.pixelSize;
    }

    public BinaryFilterParticlesOrPoresBySizes setPixelSize(double pixelSize) {
        this.pixelSize = pixelSize;
        return this;
    }

    public ConnectivityType getConnectivityType() {
        return this.connectivityType;
    }

    public ConnectivityType poresConnectivityType() {
        return BinaryFilterParticlesOrPoresBySizes.poresConnectivityType(this.connectivityType);
    }

    public BinaryFilterParticlesOrPoresBySizes setConnectivityType(ConnectivityType connectivityType) {
        this.connectivityType = (ConnectivityType)BinaryFilterParticlesOrPoresBySizes.nonNull((Object)connectivityType);
        return this;
    }

    public ParticlesOrPores getParticlesOrPores() {
        return this.particlesOrPores;
    }

    public BinaryFilterParticlesOrPoresBySizes setParticlesOrPores(ParticlesOrPores particlesOrPores) {
        this.particlesOrPores = (ParticlesOrPores)((Object)BinaryFilterParticlesOrPoresBySizes.nonNull((Object)((Object)particlesOrPores)));
        return this;
    }

    public Mode getMode() {
        return this.mode;
    }

    public BinaryFilterParticlesOrPoresBySizes setMode(Mode mode) {
        this.mode = (Mode)((Object)BinaryFilterParticlesOrPoresBySizes.nonNull((Object)((Object)mode)));
        return this;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public BinaryFilterParticlesOrPoresBySizes setMaxSize(double maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public BinaryFilterParticlesOrPoresBySizes setMaxSize(String maxSize) {
        return this.setMaxSize(BinaryFilterParticlesOrPoresBySizes.doubleOrPositiveInfinity((String)maxSize));
    }

    public double getMaxArea() {
        return this.maxArea;
    }

    public BinaryFilterParticlesOrPoresBySizes setMaxArea(double maxArea) {
        this.maxArea = maxArea;
        return this;
    }

    public BinaryFilterParticlesOrPoresBySizes setMaxArea(String maxArea) {
        return this.setMaxArea(BinaryFilterParticlesOrPoresBySizes.doubleOrPositiveInfinity((String)maxArea));
    }

    public double getMaxPerimeter() {
        return this.maxPerimeter;
    }

    public BinaryFilterParticlesOrPoresBySizes setMaxPerimeter(double maxPerimeter) {
        this.maxPerimeter = maxPerimeter;
        return this;
    }

    public BinaryFilterParticlesOrPoresBySizes setMaxPerimeter(String maxPerimeter) {
        return this.setMaxPerimeter(BinaryFilterParticlesOrPoresBySizes.doubleOrPositiveInfinity((String)maxPerimeter));
    }

    protected Matrix<? extends PArray> processMatrix(Matrix<? extends PArray> objects) {
        BinaryFilterParticlesOrPoresBySizes.logDebug(() -> "Filtering " + this.particlesOrPores + " at " + objects);
        return this.filter((Matrix<? extends BitArray>)objects.cast(BitArray.class));
    }

    public Matrix<? extends UpdatableBitArray> filter(Matrix<? extends BitArray> objects) {
        boolean pores;
        boolean bl = pores = this.particlesOrPores == ParticlesOrPores.PORES;
        if (pores) {
            objects = BinaryFilterParticlesOrPoresBySizes.poresToParticlesWithExtending(objects, 0.0).cast(BitArray.class);
        }
        Matrix result = Arrays.SMM.newBitMatrix(objects.dimensions());
        this.filterParticles((Matrix<? extends UpdatableBitArray>)result, (Matrix<? extends BitArray>)objects, null, pores ? this.poresConnectivityType() : this.getConnectivityType(), pores);
        if (pores) {
            return BinaryFilterParticlesOrPoresBySizes.asBit(BinaryFilterParticlesOrPoresBySizes.particlesToPoresWithReducing((Matrix<? extends UpdatablePArray>)result, this.mode == Mode.REMOVE));
        }
        return result;
    }

    public void filterParticles(Matrix<? extends UpdatableBitArray> result, Matrix<? extends BitArray> source, Matrix<? extends UpdatableBitArray> workMemory, ConnectivityType connectivityType, boolean skipFirstParticle) {
        boolean checkPerimeter;
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(result, "Null source matrix");
        Matrices.checkDimensionEquality((Matrix[])new Matrix[]{result, source});
        if (workMemory == null) {
            workMemory = Arrays.SMM.newBitMatrix(source.dimensions());
        }
        UpdatableBitArray resultArray = (UpdatableBitArray)result.array();
        ((UpdatableBitArray)workMemory.array()).fill(false);
        resultArray.fill(false);
        Boundary2DScanner allScanner = Boundary2DScanner.getAllBoundariesScanner(source, (Matrix)workMemory, (Matrix)workMemory, (ConnectivityType)connectivityType);
        Boundary2DSimpleMeasurer measurer = Boundary2DSimpleMeasurer.getInstance((Boundary2DScanner)allScanner, (ContourLineType)ContourLineType.SEGMENT_CENTERS_POLYLINE, this.necessaryParameters());
        Boundary2DScanner mainScanner = Boundary2DScanner.getMainBoundariesScanner(source, result, (ConnectivityType)connectivityType);
        boolean checkArea = this.maxArea != Double.POSITIVE_INFINITY;
        boolean checkSize = this.maxSize != Double.POSITIVE_INFINITY;
        boolean bl = checkPerimeter = this.maxPerimeter != Double.POSITIVE_INFINITY;
        while (measurer.nextBoundary()) {
            assert (measurer.get());
            measurer.scanBoundary(null);
            if (skipFirstParticle) {
                skipFirstParticle = false;
                continue;
            }
            if (measurer.isInternalBoundary() || checkArea && (double)Math.abs(measurer.orientedArea()) * this.pixelSize * this.pixelSize > this.maxArea || checkSize && BoundaryParameter.octagonBasedSize(measurer) * this.pixelSize > this.maxSize || checkPerimeter && measurer.perimeter() * this.pixelSize > this.maxPerimeter) continue;
            long currentIndex = measurer.currentIndexInArray();
            while (!mainScanner.isInitialized() || mainScanner.currentIndexInArray() < currentIndex) {
                mainScanner.nextBoundary();
            }
            if (mainScanner.currentIndexInArray() != currentIndex) continue;
            mainScanner.scanBoundary(null);
        }
        while (mainScanner.nextBoundary()) {
        }
        switch (this.mode) {
            case FIND: {
                Matrices.applyFunc(null, (Func)Func.MIN, result, source, result);
                break;
            }
            case REMOVE: {
                Matrices.applyFunc(null, (Func)Func.POSITIVE_DIFF, result, source, result);
                break;
            }
        }
    }

    public static ConnectivityType poresConnectivityType(ConnectivityType connectivityType) {
        return connectivityType == ConnectivityType.STRAIGHT_AND_DIAGONAL ? ConnectivityType.STRAIGHT_ONLY : ConnectivityType.STRAIGHT_AND_DIAGONAL;
    }

    public static Matrix<? extends PArray> poresToParticlesWithExtending(Matrix<? extends PArray> particles, double extendingFiller) {
        Matrix pores = Arrays.SMM.newMatrix(UpdatablePArray.class, particles.elementType(), new long[]{particles.dimX() + 2L, particles.dimY() + 2L});
        Matrix.ContinuationMode continuationMode = Matrix.ContinuationMode.getConstantMode((Object)extendingFiller);
        BinaryFilterParticlesOrPoresBySizes.switchParticlesAndPores((Matrix<? extends UpdatablePArray>)pores, (Matrix<? extends PArray>)particles.subMatr(-1L, -1L, pores.dimX(), pores.dimY(), continuationMode));
        return pores;
    }

    public static Matrix<? extends UpdatablePArray> particlesToPoresWithReducing(Matrix<? extends UpdatablePArray> result, boolean invertResult) {
        if (invertResult) {
            BinaryFilterParticlesOrPoresBySizes.switchParticlesAndPores(result, result);
        }
        return result.subMatr(1L, 1L, result.dimX() - 2L, result.dimY() - 2L);
    }

    public static Range poresToParticlesRange(Matrix<? extends PArray> particles, Range range) {
        double maxPossibleValue = ((PArray)particles.array()).maxPossibleValue(1.0);
        return Range.valueOf((double)(maxPossibleValue - range.max()), (double)(maxPossibleValue - range.min()));
    }

    private static void switchParticlesAndPores(Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> source) {
        double maxPossibleValue = ((PArray)source.array()).maxPossibleValue(1.0);
        Matrices.applyFunc(null, (Func)LinearFunc.getInstance((double)maxPossibleValue, (double[])new double[]{-1.0}), result, source);
    }

    private EnumSet<Boundary2DSimpleMeasurer.ObjectParameter> necessaryParameters() {
        EnumSet<Boundary2DSimpleMeasurer.ObjectParameter> result = EnumSet.noneOf(Boundary2DSimpleMeasurer.ObjectParameter.class);
        if (this.maxSize != Double.POSITIVE_INFINITY) {
            result.add(Boundary2DSimpleMeasurer.ObjectParameter.COORD_RANGES);
        }
        if (this.maxArea != Double.POSITIVE_INFINITY) {
            result.add(Boundary2DSimpleMeasurer.ObjectParameter.AREA);
        }
        if (this.maxPerimeter != Double.POSITIVE_INFINITY) {
            result.add(Boundary2DSimpleMeasurer.ObjectParameter.PERIMETER);
        }
        return result;
    }

    public static enum ParticlesOrPores {
        PARTICLES,
        PORES;

    }

    public static enum Mode {
        REMOVE,
        FIND,
        FIND_FILLED;

    }
}

