/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.BufferMemoryModel;
import net.algart.arrays.JArrays;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.external.ExternalAlgorithmCaller;
import net.algart.math.IPoint;
import net.algart.math.patterns.Pattern;
import net.algart.math.patterns.Patterns;
import net.algart.math.patterns.UniformGridPattern;
import net.algart.matrices.morphology.BasicMorphology;
import net.algart.matrices.morphology.BasicRankMorphology;
import net.algart.matrices.morphology.CustomRankPrecision;
import net.algart.matrices.morphology.RankMorphology;
import net.algart.matrices.morphology.RankPrecision;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;

public final class SimpleMorphologyTest {
    private final Color testColor = Color.YELLOW;
    private final int dimX = 1001;
    private final int dimY = 1001;
    private final int ptnRadius = 5;
    private final Path folder;
    private final ArrayContext context = ArrayContext.DEFAULT_SINGLE_THREAD;

    private SimpleMorphologyTest(Path folder) {
        this.folder = folder;
    }

    private Mat createMat() {
        Mat mat = new Mat(1001, 1001, opencv_core.CV_8UC3, new Scalar((double)this.testColor.getBlue(), (double)this.testColor.getRed(), (double)this.testColor.getRed(), 0.0));
        System.out.println("OpenCV Mat: " + mat);
        opencv_imgcodecs.imwrite((String)this.folder.resolve("simple.png").toString(), (Mat)mat);
        return mat;
    }

    private void createTest(ByteBuffer result) {
        result.position(0);
        int n = result.capacity() / 3;
        for (int i = 0; i < n; ++i) {
            if (i < n / 2 ? i % 20 < 5 : i % 50 < 15) {
                int r = (byte)i * this.testColor.getRed() / 255;
                int g = (byte)i * this.testColor.getGreen() / 255;
                int b = (byte)i * this.testColor.getBlue() / 255;
                result.put((byte)b);
                result.put((byte)g);
                result.put((byte)r);
                continue;
            }
            result.position(result.position() + 3);
        }
    }

    private void testDilation(Mat grayMat) throws IOException {
        Mat dilationMat = new Mat(1001, 1001, opencv_core.CV_8UC1);
        Matrix<? extends PArray> m = SimpleMorphologyTest.asMatrix(grayMat);
        BasicMorphology morphology = BasicMorphology.getInstance((ArrayContext)this.context);
        System.out.println("OpenCV morphologyEx...");
        SimpleMorphologyTest.morphologyEx(grayMat, dilationMat, 1, 11);
        SimpleMorphologyTest.morphologyEx(grayMat, dilationMat, 1, 11);
        long t1 = System.nanoTime();
        SimpleMorphologyTest.morphologyEx(grayMat, dilationMat, 1, 11);
        long t2 = System.nanoTime();
        System.out.printf("morphologyEx: %.3f ms%n", (double)(t2 - t1) * 1.0E-6);
        UniformGridPattern square = Patterns.newRectangularIntegerPattern((IPoint)IPoint.valueOf((long)-5L, (long)-5L), (IPoint)IPoint.valueOf((long)5L, (long)5L));
        System.out.println("AlgART dilation...");
        morphology.dilation(m, (Pattern)square);
        morphology.dilation(m, (Pattern)square);
        t1 = System.nanoTime();
        Matrix dilationMatrix = morphology.dilation(m, (Pattern)square);
        t2 = System.nanoTime();
        System.out.printf("Morphology: %.3f ms%n", (double)(t2 - t1) * 1.0E-6);
        opencv_imgcodecs.imwrite((String)this.folder.resolve("dilation5.png").toString(), (Mat)dilationMat);
        ExternalAlgorithmCaller.writeImage((File)this.folder.resolve("algart_dilation5.png").toFile(), Collections.singletonList(dilationMatrix));
    }

    private void testMedian(Mat grayMat) throws IOException {
        Mat medianMat = new Mat(grayMat.rows(), grayMat.cols(), opencv_core.CV_8UC1);
        Matrix<? extends PArray> m = SimpleMorphologyTest.asMatrix(grayMat);
        ExternalAlgorithmCaller.writeImage((File)this.folder.resolve("algart_gray.png").toFile(), Collections.singletonList(m));
        RankMorphology rankMorphology = BasicRankMorphology.getInstance((ArrayContext)this.context, (double)0.5, (CustomRankPrecision)RankPrecision.BITS_8);
        System.out.println("OpenCV median...");
        opencv_imgproc.medianBlur((Mat)grayMat, (Mat)medianMat, (int)11);
        opencv_imgproc.medianBlur((Mat)grayMat, (Mat)medianMat, (int)11);
        long t1 = System.nanoTime();
        opencv_imgproc.medianBlur((Mat)grayMat, (Mat)medianMat, (int)11);
        long t2 = System.nanoTime();
        System.out.printf("medianBlur: %.3f ms%n", (double)(t2 - t1) * 1.0E-6);
        System.out.println("AlgART median...");
        UniformGridPattern square = Patterns.newRectangularIntegerPattern((IPoint)IPoint.valueOf((long)-5L, (long)-5L), (IPoint)IPoint.valueOf((long)5L, (long)5L));
        rankMorphology.dilation(m, (Pattern)square);
        rankMorphology.dilation(m, (Pattern)square);
        t1 = System.nanoTime();
        Matrix medianMatrix = rankMorphology.dilation(m, (Pattern)square);
        t2 = System.nanoTime();
        System.out.printf("RankMorphology: %.3f ms%n", (double)(t2 - t1) * 1.0E-6);
        opencv_imgcodecs.imwrite((String)this.folder.resolve("median5.png").toString(), (Mat)medianMat);
        ExternalAlgorithmCaller.writeImage((File)this.folder.resolve("algart_median5.png").toFile(), Collections.singletonList(medianMatrix));
    }

    private static Matrix<? extends PArray> asMatrix(Mat m) {
        if (m.type() != opencv_core.CV_8UC1) {
            throw new IllegalArgumentException("Unsupported matrix type");
        }
        return Matrices.matrix((Array)BufferMemoryModel.asUpdatableByteArray((ByteBuffer)m.data().capacity(m.arraySize()).asByteBuffer()), (long[])new long[]{m.cols(), m.rows()});
    }

    private static void morphologyEx(Mat src, Mat dst, int op, int size) {
        try (Mat ptn = SimpleMorphologyTest.makeSquare(size);){
            opencv_imgproc.morphologyEx((Mat)src, (Mat)dst, (int)op, (Mat)ptn);
        }
    }

    private static Mat makeSquare(int size) {
        byte[] buf = new byte[size * size];
        JArrays.fillByteArray((byte[])buf, (byte)1);
        Mat ptn = new Mat(size, size, 0);
        try (BytePointer data = ptn.data();){
            data.put(buf);
        }
        return ptn;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.printf("Usage: %s testFolder%n", SimpleMorphologyTest.class.getName());
            return;
        }
        SimpleMorphologyTest test = new SimpleMorphologyTest(Paths.get(args[0], new String[0]));
        Mat mat = test.createMat();
        test.createTest(mat.data().capacity(mat.arraySize()).asByteBuffer());
        opencv_imgcodecs.imwrite((String)test.folder.resolve("test.png").toString(), (Mat)mat);
        Mat grayMat = new Mat(mat.rows(), mat.cols(), opencv_core.CV_8UC1);
        opencv_imgproc.cvtColor((Mat)mat, (Mat)grayMat, (int)6);
        test.testDilation(grayMat);
        test.testMedian(grayMat);
    }
}

