/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2017-2023 Daniel Alievsky, AlgART Laboratory (http://algart.net)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package net.algart.executors.modules.cv.matrices.objects.labels;

abstract class LabelledObjectsProcessorForFloat5Channels extends LabelledObjectsProcessorForFloat {
    LabelledObjectsProcessorForFloat5Channels(int[] lists, int[] listHeads, SingleObjectProcessor processor) {
        super(lists, listHeads, processor, 5);
    }

    /*Repeat() Bytes  ==> Shorts,,Ints,,Floats,,Doubles;;
               byte   ==> short,,int,,float,,double;;
               (data\w*\[index\]) \& 0xFF ==> $1 & 0xFFFF,,$1,,$1,,(float) $1
     */
    static class ForBytes extends LabelledObjectsProcessorForFloat5Channels {
        private final byte[] data0;
        private final byte[] data1;
        private final byte[] data2;
        private final byte[] data3;
        private final byte[] data4;

        public ForBytes(int[] lists, int[] listHeads, SingleObjectProcessor processor, byte[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            final float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            for (int label = p, labelMax = label + count; label < labelMax; label++) {
                int index = listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ensureCapacityForPixels(objectData, lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = data0[index] & 0xFF;
                    objectData1[pixelCount] = data1[index] & 0xFF;
                    objectData2[pixelCount] = data2[index] & 0xFF;
                    objectData3[pixelCount] = data3[index] & 0xFF;
                    objectData4[pixelCount] = data4[index] & 0xFF;
                    pixelCount++;
                    index = lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
    /*Repeat.AutoGeneratedStart !! Auto-generated: NOT EDIT !! */
    static class ForShorts extends LabelledObjectsProcessorForFloat5Channels {
        private final short[] data0;
        private final short[] data1;
        private final short[] data2;
        private final short[] data3;
        private final short[] data4;

        public ForShorts(int[] lists, int[] listHeads, SingleObjectProcessor processor, short[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            final float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            for (int label = p, labelMax = label + count; label < labelMax; label++) {
                int index = listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ensureCapacityForPixels(objectData, lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = data0[index] & 0xFFFF;
                    objectData1[pixelCount] = data1[index] & 0xFFFF;
                    objectData2[pixelCount] = data2[index] & 0xFFFF;
                    objectData3[pixelCount] = data3[index] & 0xFFFF;
                    objectData4[pixelCount] = data4[index] & 0xFFFF;
                    pixelCount++;
                    index = lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForInts extends LabelledObjectsProcessorForFloat5Channels {
        private final int[] data0;
        private final int[] data1;
        private final int[] data2;
        private final int[] data3;
        private final int[] data4;

        public ForInts(int[] lists, int[] listHeads, SingleObjectProcessor processor, int[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            final float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            for (int label = p, labelMax = label + count; label < labelMax; label++) {
                int index = listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ensureCapacityForPixels(objectData, lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = data0[index];
                    objectData1[pixelCount] = data1[index];
                    objectData2[pixelCount] = data2[index];
                    objectData3[pixelCount] = data3[index];
                    objectData4[pixelCount] = data4[index];
                    pixelCount++;
                    index = lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForFloats extends LabelledObjectsProcessorForFloat5Channels {
        private final float[] data0;
        private final float[] data1;
        private final float[] data2;
        private final float[] data3;
        private final float[] data4;

        public ForFloats(int[] lists, int[] listHeads, SingleObjectProcessor processor, float[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            final float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            for (int label = p, labelMax = label + count; label < labelMax; label++) {
                int index = listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ensureCapacityForPixels(objectData, lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = data0[index];
                    objectData1[pixelCount] = data1[index];
                    objectData2[pixelCount] = data2[index];
                    objectData3[pixelCount] = data3[index];
                    objectData4[pixelCount] = data4[index];
                    pixelCount++;
                    index = lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }

    static class ForDoubles extends LabelledObjectsProcessorForFloat5Channels {
        private final double[] data0;
        private final double[] data1;
        private final double[] data2;
        private final double[] data3;
        private final double[] data4;

        public ForDoubles(int[] lists, int[] listHeads, SingleObjectProcessor processor, double[][] data) {
            super(lists, listHeads, processor);
            this.data0 = data[0];
            this.data1 = data[1];
            this.data2 = data[2];
            this.data3 = data[3];
            this.data4 = data[4];
        }

        @Override
        protected void processSubArr(int p, int count, int threadIndex) {
            final float[][] objectData = this.threadObjectData[threadIndex];
            float[] objectData0 = objectData[0];
            float[] objectData1 = objectData[1];
            float[] objectData2 = objectData[2];
            float[] objectData3 = objectData[3];
            float[] objectData4 = objectData[4];
            for (int label = p, labelMax = label + count; label < labelMax; label++) {
                int index = listHeads[label];
                int pixelCount = 0;
                while (index != -1) {
                    if (pixelCount >= objectData0.length) {
                        ensureCapacityForPixels(objectData, lists.length, pixelCount);
                        objectData0 = objectData[0];
                        objectData1 = objectData[1];
                        objectData2 = objectData[2];
                        objectData3 = objectData[3];
                        objectData4 = objectData[4];
                    }
                    objectData0[pixelCount] = (float) data0[index];
                    objectData1[pixelCount] = (float) data1[index];
                    objectData2[pixelCount] = (float) data2[index];
                    objectData3[pixelCount] = (float) data3[index];
                    objectData4[pixelCount] = (float) data4[index];
                    pixelCount++;
                    index = lists[index];
                }
                if (label > 0) {
                    this.cardinalities[label - 1] = pixelCount;
                }
                this.processor.processPixels(label, objectData, pixelCount, threadIndex);
            }
        }
    }
    /*Repeat.AutoGeneratedEnd*/
}
