/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.statistics;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.opencv.common.UMatToNumbers;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class MinMaxInfo
extends UMatToNumbers
implements ReadOnlyExecutionInput {
    public static final String INPUT_MASK = "mask";
    public static final String OUTPUT_MIN_MAX = "min_max";

    public MinMaxInfo() {
        this.setDefaultOutputNumbers(OUTPUT_MIN_MAX);
    }

    @Override
    public SNumbers analyse(Mat source) {
        return SNumbers.valueOfArray((Object)MinMaxInfo.minMax(source, O2SMat.toMat(this.getInputMat(INPUT_MASK, true), true)));
    }

    @Override
    public SNumbers analyse(UMat source) {
        return SNumbers.valueOfArray((Object)MinMaxInfo.minMax(source, O2SMat.toUMat(this.getInputMat(INPUT_MASK, true), true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] minMax(UMat source, UMat mask) {
        UMat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            double[] min = new double[mat.channels()];
            double[] max = new double[mat.channels()];
            opencv_core.minMaxLoc((UMat)mat, (double[])min, (double[])max, null, null, (UMat)mask);
            double[] dArray = MinMaxInfo.joinMinMax(min, max);
            return dArray;
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] minMax(Mat source, Mat mask) {
        Mat mat = source;
        try {
            mat = OTools.toMonoIfNot(mat);
            double[] min = new double[mat.channels()];
            double[] max = new double[mat.channels()];
            opencv_core.minMaxLoc((Mat)mat, (double[])min, (double[])max, null, null, (Mat)mask);
            double[] dArray = MinMaxInfo.joinMinMax(min, max);
            return dArray;
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    private static double[] joinMinMax(double[] min, double[] max) {
        double[] result = new double[min.length + max.length];
        System.arraycopy(min, 0, result, 0, min.length);
        System.arraycopy(max, 0, result, min.length, max.length);
        return result;
    }
}

