/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.misc;

import java.util.stream.Stream;
import net.algart.arrays.Arrays;
import net.algart.executors.modules.opencv.common.VoidResultMatFilter;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.OGrabCutMode;
import net.algart.multimatrix.MultiMatrix;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Rect;

public final class GrabCut
extends VoidResultMatFilter {
    public static final String INPUT_MASK = "mask";
    public static final String INPUT_FIGURE = "figure";
    public static final String OUTPUT_MASK = "mask";
    public static final String OUTPUT_SUCCESS = "success";
    private boolean reset = true;
    private OGrabCutMode mode = OGrabCutMode.GC_INIT_WITH_RECT;
    private FigureKind figureKind = FigureKind.GC_FGD;
    private MaskPixelClass initialMaskFiller = MaskPixelClass.GC_PR_BGD;
    private boolean requireNonTrivialSamples = true;
    private boolean percents = false;
    private double startX = 0.0;
    private double startY = 0.0;
    private double sizeX = 1.0;
    private double sizeY = 1.0;
    private int iterCount = 1;
    private boolean packBits = true;
    private Mat storedMask = new Mat();
    private Mat storedBgdModel = new Mat();
    private Mat storedFgdModel = new Mat();

    public GrabCut() {
        this.addInputMat("mask");
        this.addInputMat(INPUT_FIGURE);
        this.setDefaultOutputMat("mask");
        for (MaskPixelClass maskPixelClass : MaskPixelClass.values()) {
            this.addOutputMat(maskPixelClass.outputPortName);
        }
        this.addOutputScalar(OUTPUT_SUCCESS);
    }

    public boolean isReset() {
        return this.reset;
    }

    public GrabCut setReset(boolean reset) {
        this.reset = reset;
        return this;
    }

    public OGrabCutMode getMode() {
        return this.mode;
    }

    public GrabCut setMode(OGrabCutMode mode) {
        this.mode = (OGrabCutMode)((Object)GrabCut.nonNull((Object)((Object)mode)));
        return this;
    }

    public FigureKind getFigureKind() {
        return this.figureKind;
    }

    public GrabCut setFigureKind(FigureKind figureKind) {
        this.figureKind = (FigureKind)((Object)GrabCut.nonNull((Object)((Object)figureKind)));
        return this;
    }

    public MaskPixelClass getInitialMaskFiller() {
        return this.initialMaskFiller;
    }

    public GrabCut setInitialMaskFiller(MaskPixelClass initialMaskFiller) {
        this.initialMaskFiller = (MaskPixelClass)((Object)GrabCut.nonNull((Object)((Object)initialMaskFiller)));
        return this;
    }

    public boolean isRequireNonTrivialSamples() {
        return this.requireNonTrivialSamples;
    }

    public GrabCut setRequireNonTrivialSamples(boolean requireNonTrivialSamples) {
        this.requireNonTrivialSamples = requireNonTrivialSamples;
        return this;
    }

    public boolean isPercents() {
        return this.percents;
    }

    public GrabCut setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getStartX() {
        return this.startX;
    }

    public GrabCut setStartX(double startX) {
        this.startX = startX;
        return this;
    }

    public double getStartY() {
        return this.startY;
    }

    public GrabCut setStartY(double startY) {
        this.startY = startY;
        return this;
    }

    public double getSizeX() {
        return this.sizeX;
    }

    public GrabCut setSizeX(double sizeX) {
        this.sizeX = GrabCut.nonNegative((double)sizeX);
        return this;
    }

    public double getSizeY() {
        return this.sizeY;
    }

    public GrabCut setSizeY(double sizeY) {
        this.sizeY = GrabCut.nonNegative((double)sizeY);
        return this;
    }

    public int getIterCount() {
        return this.iterCount;
    }

    public GrabCut setIterCount(int iterCount) {
        this.iterCount = GrabCut.nonNegative((int)iterCount);
        return this;
    }

    public boolean isPackBits() {
        return this.packBits;
    }

    public GrabCut setPackBits(boolean packBits) {
        this.packBits = packBits;
        return this;
    }

    @Override
    public void process(Mat result, Mat source) {
        this.process(result, source, O2SMat.toMat(this.getInputMat("mask", true)), O2SMat.toMat(this.getInputMat(INPUT_FIGURE, true), true));
    }

    public void process(Mat resultMask, Mat source, Mat initialMask, Mat correctingFigureMask) {
        boolean runGrabCut;
        this.getScalar(OUTPUT_SUCCESS).remove();
        boolean useFigure = correctingFigureMask != null && this.figureKind != FigureKind.NONE;
        OGrabCutMode mode = this.mode;
        if (this.reset) {
            if (!mode.initialization()) {
                throw new IllegalStateException("Reset flag is incompatible with the mode " + mode + ": you must specify GC_INIT_WITH_MASK or GC_INIT_WITH_RECT mode");
            }
            if (mode == OGrabCutMode.GC_INIT_WITH_MASK && initialMask == null && !useFigure) {
                throw new IllegalStateException("While resetting in the mode " + mode + ", you must specify some initial mask and/or the input figure, that will be drawn over the mask/mask filler; the mask (after adding the figure) must contain at least one GC_BGD/GC_PR_BGD and at least one GC_FGD/GC_PR_FGD element");
            }
            this.storedMask.close();
            this.storedMask = OTools.constantMonoMat8U(source.cols(), source.rows(), this.initialMaskFiller.maskPixelClass());
            this.storedBgdModel.close();
            this.storedBgdModel = new Mat();
            this.storedFgdModel.close();
            this.storedFgdModel = new Mat();
        }
        if (source.channels() == 1) {
            opencv_imgproc.cvtColor((Mat)source, (Mat)source, (int)8);
        }
        if (initialMask != null) {
            if (initialMask.type() != 0) {
                throw new IllegalArgumentException("Illegal initial mask type (must be CV_8U): " + initialMask);
            }
            if (mode == OGrabCutMode.GC_INIT_WITH_MASK) {
                initialMask.copyTo(this.storedMask);
            }
        }
        if (useFigure) {
            GrabCut.insertMask(this.storedMask, correctingFigureMask, this.figureKind.maskCode);
        }
        int nonTrivialSamples = GrabCut.nonTrivialSamples(this.storedMask);
        boolean bl = runGrabCut = mode != OGrabCutMode.GC_INIT_WITH_MASK || nonTrivialSamples > 0;
        if (runGrabCut) {
            try (Rect rect = this.createRect(source.cols(), source.rows());){
                opencv_imgproc.grabCut((Mat)source, (Mat)this.storedMask, (Rect)rect, (Mat)this.storedBgdModel, (Mat)this.storedFgdModel, (int)this.iterCount, (int)mode.code());
            }
        } else if (this.requireNonTrivialSamples) {
            throw new IllegalArgumentException("Illegal mask" + (useFigure ? " (after adding the figure)" : "") + ": all samples are " + (nonTrivialSamples == 0 ? "background or possible background" : "foreground or possible foreground") + ", but there must be both background and foreground samples");
        }
        this.getScalar(OUTPUT_SUCCESS).setTo((Object)runGrabCut);
        this.setEndProcessingTimeStamp();
        this.storedMask.copyTo(resultMask);
        this.makeBinaryMasks(this.storedMask);
    }

    @Override
    public void close() {
        this.storedMask.close();
        this.storedBgdModel.close();
        this.storedFgdModel.close();
        super.close();
    }

    private Rect createRect(int dimX, int dimY) {
        int width;
        int left = Arrays.round32((double)(this.percents ? this.startX / 100.0 * (double)Math.max(0, dimX - 1) : this.startX));
        int top = Arrays.round32((double)(this.percents ? this.startY / 100.0 * (double)Math.max(0, dimY - 1) : this.startY));
        int n = this.sizeX == 0.0 ? dimX - left : (width = Arrays.round32((double)(this.percents ? this.sizeX / 100.0 * (double)dimX : this.sizeX)));
        int height = this.sizeY == 0.0 ? dimY - top : Arrays.round32((double)(this.percents ? this.sizeY / 100.0 * (double)dimY : this.sizeY));
        return new Rect(left, top, width, height);
    }

    private void makeBinaryMasks(Mat maskMat) {
        MaskPixelClass[] maskPixelClasses = MaskPixelClass.values();
        if (Stream.of(maskPixelClasses).noneMatch(maskCode -> this.isOutputNecessary(maskCode.outputPortName()))) {
            return;
        }
        try (PointerScope scope = new PointerScope();){
            int k;
            Mat[] thresholds = new Mat[maskPixelClasses.length];
            for (k = 0; k < maskPixelClasses.length; ++k) {
                thresholds[k] = new Mat();
                opencv_imgproc.threshold((Mat)maskMat, (Mat)thresholds[k], (double)maskPixelClasses[k].maskPixelClass, (double)255.0, (int)1);
            }
            for (k = maskPixelClasses.length - 1; k > 0; --k) {
                opencv_core.bitwise_xor((Mat)thresholds[k - 1], (Mat)thresholds[k], (Mat)thresholds[k]);
            }
            for (k = 0; k < maskPixelClasses.length; ++k) {
                Mat resultMask = thresholds[k];
                if (this.packBits) {
                    this.getMat(maskPixelClasses[k].outputPortName()).setTo((MultiMatrix)O2SMat.toBinaryMatrix(resultMask));
                    continue;
                }
                O2SMat.setTo(this.getMat(maskPixelClasses[k].outputPortName()), resultMask);
                scope.detach((Pointer)resultMask);
            }
        }
    }

    private static int nonTrivialSamples(Mat mask) {
        assert (mask.type() == 0);
        byte[] bytes = OTools.toByteArray(mask);
        boolean hasBackground = false;
        boolean hasForeground = false;
        block4: for (byte b : bytes) {
            switch (b) {
                case 0: 
                case 2: {
                    hasBackground = true;
                    continue block4;
                }
                case 1: 
                case 3: {
                    hasForeground = true;
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid mask: it contains element " + (b & 0xFF) + ", differ from GC_BGD=0, GC_FGD=1, GC_PR_BGD=2 and GC_PR_FGD=3");
                }
            }
        }
        return hasBackground && hasForeground ? 1 : (hasBackground ? 0 : -1);
    }

    private static void insertMask(Mat result, Mat mask, int value) {
        try (PointerScope scope = new PointerScope();){
            mask = OTools.toMono8UIfNot(mask);
            Mat constant = OTools.constantMonoMat8U(mask.cols(), mask.rows(), value);
            opencv_core.copyTo((Mat)constant, (Mat)result, (Mat)mask);
        }
    }

    public static enum FigureKind {
        NONE(-1),
        GC_BGD(0),
        GC_FGD(1),
        GC_PR_BGD(2),
        GC_PR_FGD(3);

        private final int maskCode;

        private FigureKind(int maskCode) {
            this.maskCode = maskCode;
        }
    }

    public static enum MaskPixelClass {
        GC_BGD(0, "mask_bgd"),
        GC_FGD(1, "mask_fgd"),
        GC_PR_BGD(2, "mask_pr_bgd"),
        GC_PR_FGD(3, "mask_pr_fgd");

        private final int maskPixelClass;
        private final String outputPortName;

        public int maskPixelClass() {
            return this.maskPixelClass;
        }

        public String outputPortName() {
            return this.outputPortName;
        }

        private MaskPixelClass(int maskPixelClass, String outputPortName) {
            this.maskPixelClass = maskPixelClass;
            this.outputPortName = outputPortName;
        }
    }
}

