/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.util.opencv.enums.OBorderType;
import org.bytedeco.opencv.global.opencv_photo;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class NonLocalMeansDenoising
extends VoidResultUMatFilter {
    private Algorithm algorithm = Algorithm.CUDA_FAST_NL_MEANS;
    private double h = 3.0;
    private double hColor = 10.0;
    private int searchWindowSize = 21;
    private int blockSize = 7;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = (Algorithm)((Object)NonLocalMeansDenoising.nonNull((Object)((Object)algorithm)));
    }

    public double getH() {
        return this.h;
    }

    public void setH(double h) {
        this.h = h;
    }

    public double gethColor() {
        return this.hColor;
    }

    public void sethColor(double hColor) {
        this.hColor = hColor;
    }

    public int getSearchWindowSize() {
        return this.searchWindowSize;
    }

    public void setSearchWindowSize(int searchWindowSize) {
        this.searchWindowSize = NonLocalMeansDenoising.positive((int)searchWindowSize);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = NonLocalMeansDenoising.positive((int)blockSize);
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)NonLocalMeansDenoising.nonNull((Object)((Object)borderType)));
    }

    @Override
    public void process(Mat result, Mat source) {
        switch (this.algorithm) {
            case FAST_NL_MEANS: {
                opencv_photo.fastNlMeansDenoising((Mat)source, (Mat)result, (float)((float)this.h), (int)this.blockSize, (int)this.searchWindowSize);
                break;
            }
            case FAST_NL_MEANS_COLORED: {
                opencv_photo.fastNlMeansDenoisingColored((Mat)source, (Mat)result, (float)((float)this.h), (float)((float)this.hColor), (int)this.blockSize, (int)this.searchWindowSize);
                break;
            }
            case CUDA_NON_LOCAL_MEANS: {
                opencv_photo.nonLocalMeans((Mat)source, (Mat)result, (float)((float)this.h), (int)this.searchWindowSize, (int)this.blockSize, (int)this.borderType.code(), null);
                break;
            }
            case CUDA_FAST_NL_MEANS: {
                opencv_photo.fastNlMeansDenoising((Mat)source, (Mat)result, (float)((float)this.h), (int)this.searchWindowSize, (int)this.blockSize, null);
                break;
            }
            case CUDA_FAST_NL_MEANS_COLORED: {
                opencv_photo.fastNlMeansDenoisingColored((Mat)source, (Mat)result, (float)((float)this.h), (float)((float)this.hColor), (int)this.searchWindowSize, (int)this.blockSize, null);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown algorithm");
            }
        }
    }

    @Override
    public void process(UMat result, UMat source) {
        switch (this.algorithm) {
            case FAST_NL_MEANS: {
                opencv_photo.fastNlMeansDenoising((UMat)source, (UMat)result, (float)((float)this.h), (int)this.blockSize, (int)this.searchWindowSize);
                break;
            }
            case FAST_NL_MEANS_COLORED: {
                opencv_photo.fastNlMeansDenoisingColored((UMat)source, (UMat)result, (float)((float)this.h), (float)((float)this.hColor), (int)this.blockSize, (int)this.searchWindowSize);
                break;
            }
            case CUDA_NON_LOCAL_MEANS: {
                opencv_photo.nonLocalMeans((UMat)source, (UMat)result, (float)((float)this.h), (int)this.searchWindowSize, (int)this.blockSize, (int)this.borderType.code(), null);
                break;
            }
            case CUDA_FAST_NL_MEANS: {
                opencv_photo.fastNlMeansDenoising((UMat)source, (UMat)result, (float)((float)this.h), (int)this.searchWindowSize, (int)this.blockSize, null);
                break;
            }
            case CUDA_FAST_NL_MEANS_COLORED: {
                opencv_photo.fastNlMeansDenoisingColored((UMat)source, (UMat)result, (float)((float)this.h), (float)((float)this.hColor), (int)this.searchWindowSize, (int)this.blockSize, null);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown algorithm");
            }
        }
    }

    public static enum Algorithm {
        FAST_NL_MEANS,
        FAST_NL_MEANS_COLORED,
        CUDA_NON_LOCAL_MEANS,
        CUDA_FAST_NL_MEANS,
        CUDA_FAST_NL_MEANS_COLORED;

    }
}

