/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.matrices.filtering.AbstractFilterWithGuideImage;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class GuidedFilter
extends AbstractFilterWithGuideImage {
    private int radius = 10;
    private double eps = 0.05;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    @Override
    public void process(Mat result, Mat source, Mat guide) {
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.GuidedFilter filter = opencv_ximgproc.createGuidedFilter((Mat)guide, (int)this.radius, (double)this.eps);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.filter(source, result);
        }
    }

    @Override
    public void process(UMat result, UMat source, UMat guide) {
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.GuidedFilter filter = opencv_ximgproc.createGuidedFilter((UMat)guide, (int)this.radius, (double)this.eps);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.filter(source, result);
        }
    }
}

