/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import java.util.Locale;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.util.opencv.enums.OBorderType;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Blur
extends UMatFilter {
    private int kernelSizeX = 15;
    private int kernelSizeY = 0;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public int getKernelSizeX() {
        return this.kernelSizeX;
    }

    public Blur setKernelSizeX(int kernelSizeX) {
        this.kernelSizeX = Blur.nonNegative((int)kernelSizeX);
        return this;
    }

    public Blur setKernelSizeX(String kernelSizeX) {
        return this.setKernelSizeX(Blur.intOrDefault((String)kernelSizeX, (int)0));
    }

    public int getKernelSizeY() {
        return this.kernelSizeY;
    }

    public Blur setKernelSizeY(int kernelSizeY) {
        this.kernelSizeY = Blur.nonNegative((int)kernelSizeY);
        return this;
    }

    public Blur setKernelSizeY(String kernelSizeY) {
        return this.setKernelSizeY(Blur.intOrDefault((String)kernelSizeY, (int)0));
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public Blur setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)Blur.nonNull((Object)((Object)borderType)));
        return this;
    }

    @Override
    public Mat process(Mat source) {
        int sizeY;
        int sizeX = this.kernelSizeX > 0 ? this.kernelSizeX : this.kernelSizeY;
        int n = sizeY = this.kernelSizeY > 0 ? this.kernelSizeY : this.kernelSizeX;
        if (sizeX == 0 && sizeY == 0) {
            return source;
        }
        long t1 = Blur.debugTime();
        try (Point anchor = new Point(-1, -1);
             Size size = new Size(sizeX, sizeY);){
            opencv_imgproc.blur((Mat)source, (Mat)source, (Size)size, (Point)anchor, (int)this.getBorderType().code());
        }
        long t2 = Blur.debugTime();
        Blur.logDebug(() -> String.format(Locale.US, "Simple OpenCV blur of %s calculated in %.3f ms", source, (double)(t2 - t1) * 1.0E-6));
        return source;
    }

    @Override
    public UMat process(UMat source) {
        int sizeY;
        int sizeX = this.kernelSizeX > 0 ? this.kernelSizeX : this.kernelSizeY;
        int n = sizeY = this.kernelSizeY > 0 ? this.kernelSizeY : this.kernelSizeX;
        if (sizeX == 0 && sizeY == 0) {
            return source;
        }
        long t1 = Blur.debugTime();
        try (Point anchor = new Point(-1, -1);
             Size size = new Size(sizeX, sizeY);){
            opencv_imgproc.blur((UMat)source, (UMat)source, (Size)size, (Point)anchor, (int)this.getBorderType().code());
        }
        long t2 = Blur.debugTime();
        Blur.logDebug(() -> String.format(Locale.US, "Simple OpenCV blur of %s calculated in %.3f ms", source, (double)(t2 - t1) * 1.0E-6));
        return source;
    }
}

