/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.features;

import net.algart.executors.modules.opencv.common.VoidResultUMatFilter;
import net.algart.executors.modules.util.opencv.enums.OBorderType;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class CornerHarris
extends VoidResultUMatFilter {
    private int blockSize = 15;
    private int kernelSizeSobel = 5;
    private double k = 0.05;
    private OBorderType borderType = OBorderType.BORDER_DEFAULT;

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = CornerHarris.positive((int)blockSize);
    }

    public int getKernelSizeSobel() {
        return this.kernelSizeSobel;
    }

    public void setKernelSizeSobel(int kernelSizeSobel) {
        this.kernelSizeSobel = CornerHarris.positive((int)kernelSizeSobel);
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public OBorderType getBorderType() {
        return this.borderType;
    }

    public void setBorderType(OBorderType borderType) {
        this.borderType = (OBorderType)((Object)CornerHarris.nonNull((Object)((Object)borderType)));
    }

    @Override
    public void process(Mat result, Mat source) {
        if (source.channels() > 1) {
            opencv_imgproc.cvtColor((Mat)source, (Mat)source, (int)6);
        }
        opencv_imgproc.cornerHarris((Mat)source, (Mat)result, (int)this.blockSize, (int)(this.kernelSizeSobel | 1), (double)this.k, (int)this.borderType.code());
    }

    @Override
    public void process(UMat result, UMat source) {
        if (source.channels() > 1) {
            opencv_imgproc.cvtColor((UMat)source, (UMat)source, (int)6);
        }
        opencv_imgproc.cornerHarris((UMat)source, (UMat)result, (int)this.blockSize, (int)(this.kernelSizeSobel | 1), (double)this.k, (int)this.borderType.code());
    }
}

