/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.arithmetic;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultTwoUMatFilter;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.ODepthOrUnchanged;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class AddWeighted
extends VoidResultTwoUMatFilter
implements ReadOnlyExecutionInput {
    private ODepthOrUnchanged resultDepth = ODepthOrUnchanged.UNCHANGED;
    private double alpha = 0.5;
    private double beta = 0.5;
    private double gamma = 0.0;

    public AddWeighted() {
        super("x", "y");
    }

    public ODepthOrUnchanged getResultDepth() {
        return this.resultDepth;
    }

    public AddWeighted setResultDepth(ODepthOrUnchanged resultDepth) {
        this.resultDepth = (ODepthOrUnchanged)((Object)AddWeighted.nonNull((Object)((Object)resultDepth)));
        return this;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public AddWeighted setAlpha(double alpha) {
        this.alpha = alpha;
        return this;
    }

    public double getBeta() {
        return this.beta;
    }

    public AddWeighted setBeta(double beta) {
        this.beta = beta;
        return this;
    }

    public double getGamma() {
        return this.gamma;
    }

    public AddWeighted setGamma(double gamma) {
        this.gamma = gamma;
        return this;
    }

    @Override
    public void process(Mat result, Mat source, Mat secondMat) {
        double scaledGamma = this.gamma * OTools.maxPossibleValue(this.resultDepth.code(source.depth()));
        opencv_core.addWeighted((Mat)source, (double)this.alpha, (Mat)secondMat, (double)this.beta, (double)scaledGamma, (Mat)result, (int)this.resultDepth.code());
    }

    @Override
    public void process(UMat result, UMat source, UMat secondMat) {
        double scaledGamma = this.gamma * OTools.maxPossibleValue(this.resultDepth.code(source.depth()));
        opencv_core.addWeighted((UMat)source, (double)this.alpha, (UMat)secondMat, (double)this.beta, (double)scaledGamma, (UMat)result, (int)this.resultDepth.code());
    }
}

