/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.misc;

import java.util.Arrays;
import net.algart.arrays.ArraySorter;
import net.algart.arrays.IntArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.matrices.MultiMatrix2DFilter;
import net.algart.math.functions.AbstractFunc;
import net.algart.math.functions.Func;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class SimpleNearestCenters
extends MultiMatrix2DFilter {
    public static final String INPUT_SAMPLE_IMAGE = "sample_image";
    public static final String INPUT_POSITIONS = "positions";
    public static final String OUTPUT_LABELS = "labels";
    private static final boolean OPTIMIZED_VERSION = true;
    private long dimX = 100L;
    private long dimY = 100L;

    public SimpleNearestCenters() {
        this.setDefaultInputMat(INPUT_SAMPLE_IMAGE);
        this.addInputNumbers(INPUT_POSITIONS);
        this.setDefaultOutputMat(OUTPUT_LABELS);
    }

    public long getDimX() {
        return this.dimX;
    }

    public SimpleNearestCenters setDimX(long dimX) {
        this.dimX = SimpleNearestCenters.positive((long)dimX);
        return this;
    }

    public long getDimY() {
        return this.dimY;
    }

    public SimpleNearestCenters setDimY(long dimY) {
        this.dimY = SimpleNearestCenters.positive((long)dimY);
        return this;
    }

    public MultiMatrix2D process(MultiMatrix2D source) {
        return this.process(source, this.getInputNumbers(INPUT_POSITIONS));
    }

    public MultiMatrix2D process(MultiMatrix2D source, SNumbers positions) {
        long dimX = source == null ? this.dimX : source.dimX();
        long dimY = source == null ? this.dimY : source.dimY();
        return this.process(dimX, dimY, positions);
    }

    public MultiMatrix2D process(long dimX, long dimY, SNumbers positions) {
        float[] x = positions.column(0).toFloatArray();
        float[] y = positions.column(1).toFloatArray();
        Matrix result = net.algart.arrays.Arrays.SMM.newMatrix(UpdatablePArray.class, Integer.TYPE, new long[]{dimX, dimY});
        FindNearestPoint findingFunc = new FindNearestPoint(x, y);
        Matrices.copy(null, (Matrix)result, (Matrix)Matrices.asCoordFuncMatrix((Func)findingFunc, IntArray.class, (long[])new long[]{dimX, dimY}));
        return MultiMatrix.valueOf2DMono((Matrix)result);
    }

    protected boolean allowUninitializedInput() {
        return true;
    }

    private static class FindNearestPoint
    extends AbstractFunc {
        private final float[] x;
        private final float[] y;
        private final int n;

        FindNearestPoint(float[] x, float[] y) {
            assert (x != null);
            assert (y != null);
            assert (x.length == y.length);
            this.x = (float[])x.clone();
            this.y = (float[])y.clone();
            this.n = x.length;
            ArraySorter.getQuickSorter().sort(0, this.n, (firstIndex, secondIndex) -> {
                int i = firstIndex;
                int j = secondIndex;
                return this.y[i] < this.y[j] || this.y[i] == this.y[j] && this.x[i] < this.x[j];
            }, (firstIndex, secondIndex) -> {
                int i = firstIndex;
                int j = secondIndex;
                float temp = this.x[i];
                this.x[i] = this.x[j];
                this.x[j] = temp;
                temp = this.y[i];
                this.y[i] = this.y[j];
                this.y[j] = temp;
            });
        }

        public double get(double ... x) {
            return this.get(x[0], x[1]);
        }

        public double get(double x, double y) {
            double distanceSquare;
            double diffX;
            double diffYSquare;
            double diffY;
            int k;
            double minDistanceSquare = Double.POSITIVE_INFINITY;
            int index = -1;
            int insertionPoint = Arrays.binarySearch(this.y, (float)y);
            if (insertionPoint < 0) {
                insertionPoint = -insertionPoint - 1;
            }
            assert (insertionPoint >= 0 && insertionPoint <= this.n);
            assert (insertionPoint == 0 || this.y[insertionPoint - 1] <= (float)y);
            assert (insertionPoint == this.n || this.y[insertionPoint] >= (float)y);
            for (k = insertionPoint; k < this.n; ++k) {
                diffY = (double)this.y[k] - y;
                assert (diffY >= 0.0);
                diffYSquare = diffY * diffY;
                if (diffYSquare >= minDistanceSquare) break;
                diffX = (double)this.x[k] - x;
                distanceSquare = diffX * diffX + diffYSquare;
                if (!(distanceSquare < minDistanceSquare)) continue;
                minDistanceSquare = distanceSquare;
                index = k;
            }
            for (k = insertionPoint - 1; k >= 0; --k) {
                diffY = y - (double)this.y[k];
                assert (diffY >= 0.0);
                diffYSquare = diffY * diffY;
                if (diffYSquare > minDistanceSquare) break;
                diffX = (double)this.x[k] - x;
                distanceSquare = diffX * diffX + diffYSquare;
                if (!(distanceSquare <= minDistanceSquare)) continue;
                minDistanceSquare = distanceSquare;
                index = k;
            }
            return index + 1;
        }
    }
}

