/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import net.algart.executors.modules.core.common.awt.AWTDrawer;

public final class DrawText
extends AWTDrawer {
    private double x = 0.0;
    private double y = 0.0;
    private boolean renderHTML = false;
    private String text = "";

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public boolean isRenderHTML() {
        return this.renderHTML;
    }

    public void setRenderHTML(boolean renderHTML) {
        this.renderHTML = renderHTML;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = (String)DrawText.nonNull((Object)text);
    }

    public void process(Graphics2D g, int dimX, int dimY) {
        g.translate(this.x, this.y);
        if (this.renderHTML) {
            if (!this.text.startsWith("<html>")) {
                this.text = "<html>" + this.text;
            }
            JLabel label = new JLabel();
            label.setForeground(this.getColor());
            label.setText(this.text);
            Dimension size = label.getPreferredSize();
            label.setBounds(0, 0, size.width, size.height);
            label.paint(g);
        } else {
            int h = g.getFontMetrics().getHeight();
            g.drawString(this.text, 0, h);
        }
    }
}

