/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.drawing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.core.common.awt.AWTDrawer;
import net.algart.executors.modules.cv.matrices.drawing.PositionsAndColors;

public final class DrawEllipse
extends AWTDrawer {
    public static final String INPUT_POSITIONS = "positions";
    public static final String INPUT_COLORS = "colors";
    private boolean percents = false;
    private double x = 0.0;
    private double y = 0.0;
    private double width = 0.0;
    private double height = 0.0;
    private double arcStartInDegree = 0.0;
    private double arcExtentInDegree = 360.0;
    private double thickness = 0.0;

    public DrawEllipse() {
        this.addInputNumbers(INPUT_POSITIONS);
        this.addInputNumbers(INPUT_COLORS);
    }

    public boolean isPercents() {
        return this.percents;
    }

    public DrawEllipse setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getX() {
        return this.x;
    }

    public DrawEllipse setX(double x) {
        this.x = x;
        return this;
    }

    public double getY() {
        return this.y;
    }

    public DrawEllipse setY(double y) {
        this.y = y;
        return this;
    }

    public double getWidth() {
        return this.width;
    }

    public DrawEllipse setWidth(double width) {
        this.width = width;
        return this;
    }

    public double getHeight() {
        return this.height;
    }

    public DrawEllipse setHeight(double height) {
        this.height = height;
        return this;
    }

    public double getArcStartInDegree() {
        return this.arcStartInDegree;
    }

    public DrawEllipse setArcStartInDegree(double arcStartInDegree) {
        this.arcStartInDegree = arcStartInDegree;
        return this;
    }

    public double getArcExtentInDegree() {
        return this.arcExtentInDegree;
    }

    public DrawEllipse setArcExtentInDegree(double arcExtentInDegree) {
        this.arcExtentInDegree = DrawEllipse.nonNegative((double)arcExtentInDegree);
        return this;
    }

    public double getThickness() {
        return this.thickness;
    }

    public DrawEllipse setThickness(double thickness) {
        this.thickness = DrawEllipse.nonNegative((double)thickness);
        return this;
    }

    public void process(Graphics2D g, int dimX, int dimY) {
        SNumbers positions = this.getInputNumbers(INPUT_POSITIONS, true);
        SNumbers colors = this.getInputNumbers(INPUT_COLORS, true);
        double centerX = this.percents ? this.x / 100.0 * (double)(dimX - 1) : this.x;
        double centerY = this.percents ? this.y / 100.0 * (double)(dimY - 1) : this.y;
        double width = this.percents ? this.width / 100.0 * (double)dimX : this.width;
        double height = this.percents ? this.height / 100.0 * (double)dimY : this.height;
        PositionsAndColors positionsAndColors = new PositionsAndColors(positions, colors, new double[]{centerX, centerY}, Double.NaN, 2);
        for (int k = 0; k < positionsAndColors.n; ++k) {
            RectangularShape shape;
            double w;
            double[] xywh = positionsAndColors.xyAndOthers(k);
            float[] rgb = positionsAndColors.colorRGB(k);
            g.setColor(rgb == null ? this.getColor() : new Color(DrawEllipse.truncateColor01((float)rgb[0]), DrawEllipse.truncateColor01((float)rgb[1]), DrawEllipse.truncateColor01((float)rgb[2])));
            double d = w = xywh.length >= 3 ? xywh[2] : width;
            double h = xywh.length >= 4 ? xywh[3] : (xywh.length >= 3 ? xywh[2] : height);
            double x = xywh[0];
            double y = xywh[1];
            RectangularShape rectangularShape = shape = this.arcExtentInDegree >= 360.0 ? new Ellipse2D.Double(x - 0.5 * w, y - 0.5 * h, w, h) : new Arc2D.Double(x - 0.5 * w, y - 0.5 * h, w, h, this.arcStartInDegree, this.arcExtentInDegree, 2);
            if (this.thickness <= 0.0) {
                g.fill(shape);
                continue;
            }
            g.setStroke(new BasicStroke((float)this.thickness));
            g.draw(shape);
        }
    }
}

