/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.derivatives;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.algart.arrays.FloatArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.executors.modules.core.common.matrices.SeveralMultiMatricesOperation;
import net.algart.executors.modules.core.matrices.arithmetic.AngleDistanceMetric;
import net.algart.executors.modules.cv.matrices.derivatives.CombiningMatricesMetric;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class AngleGradient
extends SeveralMultiMatricesOperation {
    public static final String INPUT_VECTOR_X = "vx";
    public static final String INPUT_VECTOR_Y = "vy";
    public static final String OUTPUT_ANGLE_DX = "angle_dx";
    public static final String OUTPUT_ANGLE_DY = "angle_dy";
    private AngleDistanceMetric angleDistanceMetric = AngleDistanceMetric.R_SIN_COS;
    private CombiningMatricesMetric combiningDerivativesMetric = CombiningMatricesMetric.NORMALIZED_EUCLIDEAN;
    private double additionalMultiplier = 1.0;
    private MultiMatrix2D angleGradientDX = null;
    private MultiMatrix2D angleGradientDY = null;
    private MultiMatrix2D angleGradientMagnitude = null;

    public AngleGradient() {
        super(new String[]{INPUT_VECTOR_X, INPUT_VECTOR_Y});
        this.addOutputMat(OUTPUT_ANGLE_DX);
        this.addOutputMat(OUTPUT_ANGLE_DY);
    }

    public AngleDistanceMetric getAngleDistanceMetric() {
        return this.angleDistanceMetric;
    }

    public AngleGradient setAngleDistanceMetric(AngleDistanceMetric angleDistanceMetric) {
        this.angleDistanceMetric = (AngleDistanceMetric)AngleGradient.nonNull((Object)angleDistanceMetric);
        return this;
    }

    public CombiningMatricesMetric getCombiningDerivativesMetric() {
        return this.combiningDerivativesMetric;
    }

    public AngleGradient setCombiningDerivativesMetric(CombiningMatricesMetric combiningDerivativesMetric) {
        this.combiningDerivativesMetric = (CombiningMatricesMetric)((Object)AngleGradient.nonNull((Object)((Object)combiningDerivativesMetric)));
        return this;
    }

    public double getAdditionalMultiplier() {
        return this.additionalMultiplier;
    }

    public void setAdditionalMultiplier(double additionalMultiplier) {
        this.additionalMultiplier = additionalMultiplier;
    }

    public MultiMatrix2D angleGradientDX() {
        return this.angleGradientDX;
    }

    public MultiMatrix2D angleGradientDY() {
        return this.angleGradientDY;
    }

    public MultiMatrix2D angleGradientMagnitude() {
        return this.angleGradientMagnitude;
    }

    public MultiMatrix process(List<MultiMatrix> sources) {
        Objects.requireNonNull(sources, "Null sources");
        Matrix<? extends PArray> vx = AngleGradient.extend((Matrix<? extends PArray>)sources.get(0).asMultiMatrix2D().asFloatingPoint().intensityChannel());
        Matrix<? extends PArray> vy = AngleGradient.extend((Matrix<? extends PArray>)sources.get(1).asMultiMatrix2D().asFloatingPoint().intensityChannel());
        Matrix<? extends PArray> vxRight = AngleGradient.shift(vx, 1, 0);
        Matrix<? extends PArray> vyRight = AngleGradient.shift(vy, 1, 0);
        Matrix<? extends PArray> vxDown = AngleGradient.shift(vx, 0, 1);
        Matrix<? extends PArray> vyDown = AngleGradient.shift(vy, 0, 1);
        Matrix<? extends PArray> angleDX = AngleGradient.reduce((Matrix<? extends PArray>)this.angleDistanceMetric.asAngleDifference(vx, vy, vxRight, vyRight, FloatArray.class));
        Matrix<? extends PArray> angleDY = AngleGradient.reduce((Matrix<? extends PArray>)this.angleDistanceMetric.asAngleDifference(vx, vy, vxDown, vyDown, FloatArray.class));
        Matrix<FloatArray> magnitude = this.combiningDerivativesMetric.combine(FloatArray.class, Arrays.asList(angleDX, angleDY), new double[0], this.additionalMultiplier);
        this.angleGradientDX = MultiMatrix.valueOf2DMono(AngleGradient.multiply(angleDX, this.additionalMultiplier));
        this.angleGradientDY = MultiMatrix.valueOf2DMono(AngleGradient.multiply(angleDY, this.additionalMultiplier));
        this.angleGradientMagnitude = MultiMatrix.valueOf2DMono(magnitude);
        this.getMat(OUTPUT_ANGLE_DX).setTo((MultiMatrix)this.angleGradientDX);
        this.getMat(OUTPUT_ANGLE_DY).setTo((MultiMatrix)this.angleGradientDY);
        return this.angleGradientMagnitude;
    }

    private static Matrix<? extends PArray> extend(Matrix<? extends PArray> matrix) {
        return Matrices.clone((Matrix)matrix.subMatrix(0L, 0L, matrix.dimX() + 1L, matrix.dimY() + 1L, Matrix.ContinuationMode.MIRROR_CYCLIC));
    }

    private static Matrix<? extends PArray> reduce(Matrix<? extends PArray> matrix) {
        return Matrices.clone((Matrix)matrix.subMatrix(0L, 0L, matrix.dimX() - 1L, matrix.dimY() - 1L));
    }

    private static Matrix<? extends PArray> shift(Matrix<? extends PArray> matrix, int dx, int dy) {
        return Matrices.asShifted(matrix, (long[])new long[]{dx, dy}).cast(PArray.class);
    }

    private static Matrix<? extends PArray> multiply(Matrix<? extends PArray> matrix, double multiplier) {
        return multiplier == 1.0 ? matrix : Matrices.asFuncMatrix((Func)LinearFunc.getInstance((double)0.0, (double[])new double[]{multiplier}), FloatArray.class, matrix);
    }
}

