/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.cv.matrices.camera.reflectance;

import jakarta.json.JsonObject;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.algart.executors.modules.cv.matrices.camera.reflectance.ReflectanceSettings;

public enum ReflectanceTranslationType {
    LINEAR("linear", ReflectanceSettings.LinearTranslation::new, ReflectanceSettings.LinearTranslation::new),
    LOG_LINEAR("loglinear", ReflectanceSettings.LogLinearTranslation::new, ReflectanceSettings.LogLinearTranslation::new);

    private final String typeName;
    private final Supplier<ReflectanceSettings.Translation> factory;
    private final Function<JsonObject, ReflectanceSettings.Translation> jsonBasedFactory;
    private static final Map<String, ReflectanceTranslationType> ALL_TYPES;

    private ReflectanceTranslationType(String typeName, Supplier<ReflectanceSettings.Translation> factory, Function<JsonObject, ReflectanceSettings.Translation> jsonBasedFactory) {
        this.typeName = typeName;
        this.factory = factory;
        this.jsonBasedFactory = jsonBasedFactory;
    }

    public String typeName() {
        return this.typeName;
    }

    public ReflectanceSettings.Translation newSettings() {
        return this.factory.get();
    }

    public ReflectanceSettings.Translation newSettings(JsonObject json) {
        return this.jsonBasedFactory.apply(json);
    }

    public static ReflectanceTranslationType valueOfTypeNameOrNull(String typeName) {
        return ALL_TYPES.get(typeName);
    }

    static {
        ALL_TYPES = Stream.of(ReflectanceTranslationType.values()).collect(Collectors.toMap(ReflectanceTranslationType::typeName, e -> e));
    }
}

