/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.external.ExternalAlgorithmCaller;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.opencv_core.Mat;

public final class MatrixTypeConversionsTest {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.printf("Usage: %s source_image_file%n", MatrixTypeConversionsTest.class.getName());
            return;
        }
        File sourceFile = new File(args[0]);
        MultiMatrix2D multiMatrix = MultiMatrix.valueOf2DRGBA((List)ExternalAlgorithmCaller.readImage((File)sourceFile));
        System.out.printf("Loaded %s%n", multiMatrix);
        SMat m = SMat.valueOf((MultiMatrix)multiMatrix);
        multiMatrix = m.toMultiMatrix2D();
        System.out.printf("-> port -> multi-matrix: %s%n", multiMatrix);
        ExternalAlgorithmCaller.writeImage((File)new File(sourceFile + ".port2mm.png"), (List)multiMatrix.allChannelsInRGBAOrder());
        Mat mat = O2SMat.toMat((SMat)m);
        System.out.printf("-> port -> mat: %s%n", multiMatrix);
        opencv_imgcodecs.imwrite((String)(sourceFile + ".port2mat.png"), (Mat)mat);
        BufferedImage bufferedImage = m.toBufferedImage();
        System.out.printf("-> port -> BufferedImage: %s%n", multiMatrix);
        ImageIO.write((RenderedImage)bufferedImage, "png", new File(sourceFile + ".port2bb.png"));
        SMat tempPort = SMat.valueOf((BufferedImage)bufferedImage);
        multiMatrix = tempPort.toMultiMatrix2D();
        System.out.printf("-> port -> BufferedImage -> port -> multi-matrix: %s%n", multiMatrix);
        ExternalAlgorithmCaller.writeImage((File)new File(sourceFile + ".bb2port2mm.png"), (List)multiMatrix.allChannelsInRGBAOrder());
    }
}

