/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices;

import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_ximgproc.SuperpixelSEEDS;

public final class SuperpixelLittleMatBug {
    public static void main(String[] args) {
        opencv_core.setUseOpenCL((boolean)true);
        if (args.length < 4) {
            System.out.printf("Usage: %s source_image target_image width height%n", SuperpixelLittleMatBug.class.getName());
            return;
        }
        String sourceFile = args[0];
        String targetFile = args[1];
        int width = Integer.parseInt(args[2]);
        int height = Integer.parseInt(args[3]);
        Mat source = opencv_imgcodecs.imread((String)sourceFile);
        Size size = new Size(width, height);
        opencv_imgproc.resize((Mat)source, (Mat)source, (Size)size);
        Mat result = new Mat();
        System.out.println("Creating SuperpixelSEEDS...");
        SuperpixelSEEDS superpixelSEEDS = opencv_ximgproc.createSuperpixelSEEDS((int)source.cols(), (int)source.rows(), (int)source.channels(), (int)100, (int)4, (int)4, (int)5, (boolean)false);
        System.out.println("Iterating...");
        superpixelSEEDS.iterate(source, 4);
        System.out.println("Getting controur mask...");
        superpixelSEEDS.getLabelContourMask(result, true);
        System.out.println("Writing...");
        opencv_imgcodecs.imwrite((String)targetFile, (Mat)result);
    }
}

