/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import java.util.Locale;
import java.util.Objects;
import net.algart.executors.modules.core.matrices.geometry.ContinuationMode;
import net.algart.executors.modules.cv.matrices.misc.Selector;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyFilter;
import net.algart.executors.modules.cv.matrices.morphology.MorphologyOperation;
import net.algart.executors.modules.cv.matrices.morphology.StrictMorphology;
import net.algart.executors.modules.cv.matrices.thresholds.SimpleThreshold;
import net.algart.executors.modules.opencv.matrices.segmentation.AbstractSegmentationWithBoundaries;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.UMat;

public final class Watershed
extends AbstractSegmentationWithBoundaries {
    public static final String INPUT_LABELS = "labels";
    public static final String OUTPUT_LABELS = "labels";
    public static final String OUTPUT_SOURCE_LABELS = "source_labels";
    private static final Scalar zeroScalar = new Scalar(0.0, 0.0, 0.0, 0.0);
    private static final Scalar unitScalar = new Scalar(1.0);
    private SeedingMode seedingMode = SeedingMode.SEEDING_LABELS;
    private int autoLabellingForegroundErosionKernelSize = 0;
    private int autoLabellingBackgroundErosionKernelSize = 32;
    private ValuesOnBoundaries valuesOnBoundaries = ValuesOnBoundaries.MINUS_ONE;

    public Watershed() {
        this.addInputMat("labels");
        this.setDefaultOutputMat("labels");
        this.addOutputMat(OUTPUT_SOURCE_LABELS);
    }

    public SeedingMode getSeedingMode() {
        return this.seedingMode;
    }

    public Watershed setSeedingMode(SeedingMode seedingMode) {
        this.seedingMode = (SeedingMode)((Object)Watershed.nonNull((Object)((Object)seedingMode)));
        return this;
    }

    public int getAutoLabellingForegroundErosionKernelSize() {
        return this.autoLabellingForegroundErosionKernelSize;
    }

    public Watershed setAutoLabellingForegroundErosionKernelSize(int autoLabellingForegroundErosionKernelSize) {
        this.autoLabellingForegroundErosionKernelSize = Watershed.nonNegative((int)autoLabellingForegroundErosionKernelSize);
        return this;
    }

    public int getAutoLabellingBackgroundErosionKernelSize() {
        return this.autoLabellingBackgroundErosionKernelSize;
    }

    public Watershed setAutoLabellingBackgroundErosionKernelSize(int autoLabellingBackgroundErosionKernelSize) {
        this.autoLabellingBackgroundErosionKernelSize = Watershed.nonNegative((int)autoLabellingBackgroundErosionKernelSize);
        return this;
    }

    public ValuesOnBoundaries getValuesOnBoundaries() {
        return this.valuesOnBoundaries;
    }

    public Watershed setValuesOnBoundaries(ValuesOnBoundaries valuesOnBoundaries) {
        this.valuesOnBoundaries = (ValuesOnBoundaries)((Object)Watershed.nonNull((Object)((Object)valuesOnBoundaries)));
        return this;
    }

    @Override
    public Mat process(Mat source) {
        boolean labelsAreSpecifiedByUser = this.seedingMode == SeedingMode.SEEDING_LABELS;
        Mat labels = O2SMat.toMat(this.getInputMat("labels", !labelsAreSpecifiedByUser), true);
        if (source == null && labels == null) {
            throw new IllegalArgumentException("Source input or labels must be specified");
        }
        return this.process(source, labels);
    }

    @Override
    public UMat process(UMat source) {
        boolean labelsAreSpecifiedByUser = this.seedingMode == SeedingMode.SEEDING_LABELS;
        UMat labels = O2SMat.toUMat(this.getInputMat("labels", !labelsAreSpecifiedByUser), true);
        if (source == null && labels == null) {
            throw new IllegalArgumentException("Source input or labels must be specified");
        }
        return this.process(source, labels);
    }

    public Mat threshold(Mat mat, boolean matIsLabels) {
        Mat result = new Mat();
        if (mat.channels() == 1) {
            mat.copyTo(result);
        } else {
            opencv_imgproc.cvtColor((Mat)mat, (Mat)result, (int)6);
        }
        if (result.depth() != 0) {
            result.convertTo(result, 0);
        }
        opencv_imgproc.threshold((Mat)result, (Mat)result, (double)0.0, (double)255.0, (int)(matIsLabels ? 0 : 8));
        return result;
    }

    public UMat threshold(UMat mat, boolean matIsLabels) {
        UMat result = new UMat();
        if (mat.channels() == 1) {
            mat.copyTo(result);
        } else {
            opencv_imgproc.cvtColor((UMat)mat, (UMat)result, (int)6);
        }
        if (result.depth() != 0) {
            result.convertTo(result, 0);
        }
        opencv_imgproc.threshold((UMat)result, (UMat)result, (double)0.0, (double)255.0, (int)(matIsLabels ? 0 : 8));
        return result;
    }

    public Mat createLabels(Mat foreground) {
        try (Mat background = this.seedingMode.backgroundUsed ? new Mat() : null;){
            if (background != null) {
                opencv_core.bitwise_not((Mat)foreground, (Mat)background);
                OTools.morphology(background, 0, 0, this.autoLabellingBackgroundErosionKernelSize);
            }
            OTools.morphology(foreground, 0, 0, this.autoLabellingForegroundErosionKernelSize);
            Mat result = OTools.newCompatibleMat(foreground, 4);
            switch (this.seedingMode) {
                case ONE_FOREGROUND_AND_ONE_BACKGROUND: {
                    opencv_core.addWeighted((Mat)background, (double)0.00392156862745098, (Mat)foreground, (double)0.00784313725490196, (double)0.0, (Mat)result, (int)4);
                    Mat mat = result;
                    return mat;
                }
                case CONNECTED_COMPONENTS_ONLY: {
                    int n = opencv_imgproc.connectedComponents((Mat)foreground, (Mat)result, (int)8, (int)4);
                    Watershed.logDebug(() -> "Watershed: automatic creating " + (n - 1) + " foreground labels");
                    Mat mat = result;
                    return mat;
                }
                case CONNECTED_COMPONENTS_AND_ONE_BACKGROUND: {
                    int n = opencv_imgproc.connectedComponents((Mat)foreground, (Mat)result, (int)8, (int)4);
                    Watershed.logDebug(() -> "Watershed: automatic creating " + (n - 1) + " foreground + 1 background labels");
                    try (Mat constant1 = new Mat(result.rows(), result.cols(), result.type(), unitScalar);){
                        opencv_core.add((Mat)result, (Mat)constant1, (Mat)result, (Mat)foreground, (int)4);
                        opencv_core.add((Mat)result, (Mat)constant1, (Mat)result, (Mat)background, (int)4);
                    }
                    Mat mat = result;
                    return mat;
                }
            }
            throw new AssertionError((Object)("Unallowed mode " + this.seedingMode));
        }
    }

    public UMat createLabels(UMat foreground) {
        try (UMat background = this.seedingMode.backgroundUsed ? new UMat() : null;){
            if (background != null) {
                opencv_core.bitwise_not((UMat)foreground, (UMat)background);
                OTools.morphology(background, 0, 0, this.autoLabellingBackgroundErosionKernelSize);
            }
            OTools.morphology(foreground, 0, 0, this.autoLabellingForegroundErosionKernelSize);
            UMat result = OTools.newCompatibleUMat(foreground, 4);
            switch (this.seedingMode) {
                case ONE_FOREGROUND_AND_ONE_BACKGROUND: {
                    opencv_core.addWeighted((UMat)background, (double)0.00392156862745098, (UMat)foreground, (double)0.00784313725490196, (double)0.0, (UMat)result, (int)4);
                    UMat uMat = result;
                    return uMat;
                }
                case CONNECTED_COMPONENTS_ONLY: {
                    int n = opencv_imgproc.connectedComponents((UMat)foreground, (UMat)result, (int)8, (int)4);
                    Watershed.logDebug(() -> "Watershed: automatic creating " + (n - 1) + " foreground labels");
                    UMat uMat = result;
                    return uMat;
                }
                case CONNECTED_COMPONENTS_AND_ONE_BACKGROUND: {
                    int n = opencv_imgproc.connectedComponents((UMat)foreground, (UMat)result, (int)8, (int)4);
                    Watershed.logDebug(() -> "Watershed: automatic creating " + (n - 1) + " foreground + 1 background labels");
                    try (UMat constant1 = new UMat(result.rows(), result.cols(), result.type(), unitScalar);){
                        opencv_core.add((UMat)result, (UMat)constant1, (UMat)result, (UMat)foreground, (int)4);
                        opencv_core.add((UMat)result, (UMat)constant1, (UMat)result, (UMat)background, (int)4);
                    }
                    UMat uMat = result;
                    return uMat;
                }
            }
            throw new AssertionError((Object)("Unallowed mode " + this.seedingMode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mat process(Mat source, Mat labelsAndResult) {
        long t2;
        long t1 = Watershed.debugTime();
        boolean labelsAreSpecifiedByUser = this.seedingMode == SeedingMode.SEEDING_LABELS;
        Mat labelsAndResultOriginal = labelsAndResult;
        if (labelsAreSpecifiedByUser) {
            Objects.requireNonNull(labelsAndResult, "Null labels");
            Watershed.logDebug(() -> "Watershed for given labels (source: " + OTools.toString(source) + ")");
            t2 = t1;
        } else {
            long tStart = System.nanoTime();
            try (Mat bitMat = this.threshold(labelsAndResult != null ? labelsAndResult : source, labelsAndResult != null);){
                t2 = Watershed.debugTime();
                Watershed.logDebug(() -> "Watershed, automatic threshold of " + (labelsAndResultOriginal == null ? "source (" + OTools.toString(source) + ")" : "labels (" + OTools.toString(labelsAndResultOriginal) + ")"));
                labelsAndResult = this.createLabels(bitMat);
                this.addServiceTime(System.nanoTime() - tStart);
            }
        }
        if (labelsAndResult.depth() != 4) {
            throw new IllegalArgumentException("Watershed labels must be 32-bit integers (CV_32S)");
        }
        long t3 = Watershed.debugTime();
        Mat mat = source;
        try {
            boolean outputSourceLabelsNecessary;
            Mat labelsClone;
            if (mat == null) {
                mat = new Mat(labelsAndResult.rows(), labelsAndResult.cols(), opencv_core.CV_8UC3, zeroScalar);
            }
            Mat mat2 = labelsClone = (outputSourceLabelsNecessary = this.isOutputNecessary(OUTPUT_SOURCE_LABELS)) ? labelsAndResult.clone() : null;
            if (mat.channels() == 1) {
                opencv_imgproc.cvtColor((Mat)mat, (Mat)mat, (int)8);
            }
            long t4 = Watershed.debugTime();
            opencv_imgproc.watershed((Mat)mat, (Mat)labelsAndResult);
            long t5 = Watershed.debugTime();
            this.setEndProcessingTimeStamp();
            if (outputSourceLabelsNecessary) {
                O2SMat.setTo(this.getMat(OUTPUT_SOURCE_LABELS), labelsClone);
            }
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> {
                labels.convertTo(boundaries, 5);
                opencv_imgproc.threshold((Mat)boundaries, (Mat)boundaries, (double)-1.0, (double)255.0, (int)1);
            }, mat, labelsAndResult);
            long t6 = Watershed.debugTime();
            switch (this.valuesOnBoundaries) {
                case ZERO: {
                    opencv_core.max((Mat)labelsAndResult, (double)0.0).asMat().copyTo(labelsAndResult);
                    break;
                }
                case NEAREST_LABEL: {
                    MultiMatrix2D resultMatrix = O2SMat.toMultiMatrix(labelsAndResult).asMono();
                    for (int iteration = 0; iteration < 2; ++iteration) {
                        MultiMatrix2D binaryBoundaries = new SimpleThreshold().setMin(Double.NEGATIVE_INFINITY).setMax(0.0).process(resultMatrix).clone();
                        MultiMatrix2D dilated = new StrictMorphology().setOperation(MorphologyOperation.DILATION).setPattern(MorphologyFilter.Shape.CUBE, 3).setContinuationMode(ContinuationMode.NEGATIVE_INFINITY).process((MultiMatrix)resultMatrix).asMultiMatrix2D();
                        resultMatrix = new Selector().process(new MultiMatrix[]{binaryBoundaries, resultMatrix, dilated}).asMultiMatrix2D();
                    }
                    labelsAndResult.close();
                    labelsAndResult = O2SMat.toMat(resultMatrix);
                    break;
                }
            }
            long t7 = Watershed.debugTime();
            if (LOGGABLE_DEBUG) {
                Watershed.logDebug((String)String.format(Locale.US, "Watershed for %d-bit Mat %dx%dx%d, %s: %.3f ms preprocess = %.3f threshold + %.3f ms finding components;  %.3f ms preparing, %.3f OpenCV watershed; %.3f postprocessing: %.3f boundaries + %.3f correcting result", new Object[]{8L * mat.elemSize1(), mat.channels(), mat.cols(), mat.rows(), this.seedingMode, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t7 - t5) * 1.0E-6, (double)(t6 - t5) * 1.0E-6, (double)(t7 - t6) * 1.0E-6}));
            }
            Mat mat3 = labelsAndResult;
            return mat3;
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMat process(UMat source, UMat labelsAndResult) {
        long t2;
        long t1 = Watershed.debugTime();
        boolean labelsAreSpecifiedByUser = this.seedingMode == SeedingMode.SEEDING_LABELS;
        UMat labelsAndResultOriginal = labelsAndResult;
        if (labelsAreSpecifiedByUser) {
            Objects.requireNonNull(labelsAndResult, "Null labels");
            Watershed.logDebug(() -> "Watershed for given labels (source: " + OTools.toString(source) + ")");
            t2 = t1;
        } else {
            long tStart = System.nanoTime();
            try (UMat bitMat = this.threshold(labelsAndResult != null ? labelsAndResult : source, labelsAndResult != null);){
                t2 = Watershed.debugTime();
                Watershed.logDebug(() -> "Watershed, automatic threshold of " + (labelsAndResultOriginal == null ? "source (" + OTools.toString(source) + ")" : "labels (" + OTools.toString(labelsAndResultOriginal) + ")"));
                labelsAndResult = this.createLabels(bitMat);
                this.addServiceTime(System.nanoTime() - tStart);
            }
        }
        if (labelsAndResult.depth() != 4) {
            throw new IllegalArgumentException("Watershed labels must be 32-bit integers (CV_32S)");
        }
        long t3 = Watershed.debugTime();
        UMat mat = source;
        try {
            boolean outputSourceLabelsNecessary;
            UMat labelsClone;
            if (mat == null) {
                mat = new UMat(labelsAndResult.rows(), labelsAndResult.cols(), opencv_core.CV_8UC3, zeroScalar);
            }
            UMat uMat = labelsClone = (outputSourceLabelsNecessary = this.isOutputNecessary(OUTPUT_SOURCE_LABELS)) ? labelsAndResult.clone() : null;
            if (mat.channels() == 1) {
                opencv_imgproc.cvtColor((UMat)mat, (UMat)mat, (int)8);
            }
            long t4 = Watershed.debugTime();
            opencv_imgproc.watershed((UMat)mat, (UMat)labelsAndResult);
            long t5 = Watershed.debugTime();
            this.setEndProcessingTimeStamp();
            if (outputSourceLabelsNecessary) {
                O2SMat.setTo(this.getMat(OUTPUT_SOURCE_LABELS), labelsClone);
            }
            this.setToOutputBoundaries((Mat boundaries, Mat labels, boolean needThick) -> {
                labels.convertTo(boundaries, 5);
                opencv_imgproc.threshold((Mat)boundaries, (Mat)boundaries, (double)-1.0, (double)255.0, (int)1);
            }, mat, labelsAndResult);
            long t6 = Watershed.debugTime();
            switch (this.valuesOnBoundaries) {
                case ZERO: {
                    try (UMat constant0 = OTools.newCompatibleZeros(labelsAndResult);){
                        opencv_core.max((UMat)labelsAndResult, (UMat)constant0, (UMat)labelsAndResult);
                        break;
                    }
                }
                case NEAREST_LABEL: {
                    MultiMatrix2D resultMatrix = O2SMat.toMultiMatrix(labelsAndResult).asMono();
                    for (int iteration = 0; iteration < 2; ++iteration) {
                        MultiMatrix2D binaryBoundaries = new SimpleThreshold().setMin(Double.NEGATIVE_INFINITY).setMax(0.0).process(resultMatrix).clone();
                        MultiMatrix2D dilated = new StrictMorphology().setOperation(MorphologyOperation.DILATION).setPattern(MorphologyFilter.Shape.CUBE, 3).setContinuationMode(ContinuationMode.NEGATIVE_INFINITY).process((MultiMatrix)resultMatrix).asMultiMatrix2D();
                        resultMatrix = new Selector().process(new MultiMatrix[]{binaryBoundaries, resultMatrix, dilated}).asMultiMatrix2D();
                    }
                    labelsAndResult.close();
                    labelsAndResult = O2SMat.toUMat(resultMatrix);
                    break;
                }
            }
            long t7 = Watershed.debugTime();
            if (LOGGABLE_DEBUG) {
                Watershed.logDebug((String)String.format(Locale.US, "Watershed for %d-bit UMat %dx%dx%d (GPU), %s: %.3f ms preprocess = %.3f threshold + %.3f ms finding components;  %.3f ms preparing, %.3f OpenCV watershed; %.3f postprocessing: %.3f boundaries + %.3f correcting result", new Object[]{8L * mat.elemSize1(), mat.channels(), mat.cols(), mat.rows(), this.seedingMode, (double)(t3 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t7 - t5) * 1.0E-6, (double)(t6 - t5) * 1.0E-6, (double)(t7 - t6) * 1.0E-6}));
            }
            UMat uMat2 = labelsAndResult;
            return uMat2;
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }

    public static enum SeedingMode {
        SEEDING_LABELS(false),
        ONE_FOREGROUND_AND_ONE_BACKGROUND(true),
        CONNECTED_COMPONENTS_ONLY(false),
        CONNECTED_COMPONENTS_AND_ONE_BACKGROUND(true);

        private final boolean backgroundUsed;

        private SeedingMode(boolean backgroundUsed) {
            this.backgroundUsed = backgroundUsed;
        }
    }

    public static enum ValuesOnBoundaries {
        MINUS_ONE,
        ZERO,
        NEAREST_LABEL;

    }
}

