/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.segmentation;

import java.awt.Color;
import net.algart.executors.modules.util.opencv.OTools;
import org.bytedeco.opencv.opencv_core.Mat;

public enum DrawingBoundariesStyle {
    BOUNDARIES(true, false, false),
    THICK_BOUNDARIES(true, true, false),
    BOUNDARIES_ON_SOURCE(false, false, true),
    THICK_BOUNDARIES_ON_SOURCE(false, true, true);

    final boolean binary;
    final boolean thickBoundaries;
    final boolean drawOnSource;

    private DrawingBoundariesStyle(boolean binary, boolean thickBoundaries, boolean drawOnSource) {
        this.binary = binary;
        this.thickBoundaries = thickBoundaries;
        this.drawOnSource = drawOnSource;
    }

    public boolean isThickBoundaries() {
        return this.thickBoundaries;
    }

    public Mat drawOnSourceIfRequested(Mat boundaries, Mat source, Color color) {
        if (this.drawOnSource) {
            return OTools.drawBitMaskOnMat(source, boundaries, color);
        }
        return boundaries;
    }
}

