/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.ml.training;

import java.util.Locale;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.opencv.matrices.ml.AbstractMLTrain;
import net.algart.executors.modules.opencv.matrices.ml.MLSamplesType;
import net.algart.executors.modules.util.opencv.O2SMat;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_ml.DTrees;

abstract class MLTrainDTrees
extends AbstractMLTrain {
    private int cvFolds = 10;
    private int maxCategories = 10;
    private Integer maxDepth = null;
    private int minSampleCount = 10;
    private float[] priors = new float[0];
    private double regressionAccuracy = 0.01;
    private boolean truncatePrunedTree = true;
    private boolean use1SERule = true;
    private boolean useSurrogates = false;

    MLTrainDTrees(MLSamplesType inputType) {
        super(inputType);
    }

    public int getCvFolds() {
        return this.cvFolds;
    }

    public MLTrainDTrees setCvFolds(int cvFolds) {
        this.cvFolds = cvFolds;
        return this;
    }

    public int getMaxCategories() {
        return this.maxCategories;
    }

    public MLTrainDTrees setMaxCategories(int maxCategories) {
        this.maxCategories = maxCategories;
        return this;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public MLTrainDTrees setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public int getMinSampleCount() {
        return this.minSampleCount;
    }

    public MLTrainDTrees setMinSampleCount(int minSampleCount) {
        this.minSampleCount = minSampleCount;
        return this;
    }

    public float[] getPriors() {
        return (float[])this.priors.clone();
    }

    public MLTrainDTrees setPriors(float[] priors) {
        this.priors = (float[])((float[])MLTrainDTrees.nonNull((Object)priors)).clone();
        return this;
    }

    public MLTrainDTrees setPriors(String priors) {
        double[] values = new SScalar((String)MLTrainDTrees.nonNull((Object)priors)).toDoubles();
        this.priors = new float[values.length];
        for (int k = 0; k < values.length; ++k) {
            this.priors[k] = (float)values[k];
        }
        return this;
    }

    public double getRegressionAccuracy() {
        return this.regressionAccuracy;
    }

    public MLTrainDTrees setRegressionAccuracy(double regressionAccuracy) {
        this.regressionAccuracy = regressionAccuracy;
        return this;
    }

    public boolean isTruncatePrunedTree() {
        return this.truncatePrunedTree;
    }

    public MLTrainDTrees setTruncatePrunedTree(boolean truncatePrunedTree) {
        this.truncatePrunedTree = truncatePrunedTree;
        return this;
    }

    public boolean isUse1SERule() {
        return this.use1SERule;
    }

    public MLTrainDTrees setUse1SERule(boolean use1SERule) {
        this.use1SERule = use1SERule;
        return this;
    }

    public boolean isUseSurrogates() {
        return this.useSurrogates;
    }

    public MLTrainDTrees setUseSurrogates(boolean useSurrogates) {
        this.useSurrogates = useSurrogates;
        return this;
    }

    void customizeDTrees(DTrees model, Mat priors) {
        model.setCVFolds(this.cvFolds);
        model.setMaxCategories(this.maxCategories);
        if (this.maxDepth != null) {
            model.setMaxDepth(this.maxDepth.intValue());
        }
        model.setMinSampleCount(this.minSampleCount);
        if (priors != null) {
            model.setPriors(priors);
        }
        model.setRegressionAccuracy((float)this.regressionAccuracy);
        model.setTruncatePrunedTree(this.truncatePrunedTree);
        model.setUse1SERule(this.use1SERule);
        model.setUseSurrogates(this.useSurrogates);
    }

    void customizeRTrees(DTrees model, Mat priors) {
        model.setMaxCategories(this.maxCategories);
        if (this.maxDepth != null) {
            model.setMaxDepth(this.maxDepth.intValue());
        }
        model.setMinSampleCount(this.minSampleCount);
        if (priors != null) {
            model.setPriors(priors);
        }
    }

    Mat priors() {
        if (this.priors.length == 0) {
            return null;
        }
        SNumbers result = SNumbers.valueOfArray((Object)this.priors, (int)1);
        return O2SMat.numbersToMulticolumn32BitMat(result, false);
    }

    public static String toString(DTrees model) {
        return String.format(Locale.US, "cvFolds=%s, maxCategories=%s, maxDepth=%s, minSampleCount=%s, regressionAccuracy=%s, truncatePrunedTree=%s, use1SERule=%s, useSurrogates=%s", model.getCVFolds(), model.getMaxCategories(), model.getMaxDepth(), model.getMinSampleCount(), Float.valueOf(model.getRegressionAccuracy()), model.getTruncatePrunedTree(), model.getUse1SERule(), model.getUseSurrogates());
    }
}

