/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.filtering;

import net.algart.executors.modules.opencv.matrices.filtering.AbstractFilterWithGuideImage;
import net.algart.executors.modules.util.opencv.OTools;
import org.bytedeco.opencv.global.opencv_ximgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class FastGlobalSmootherFilter
extends AbstractFilterWithGuideImage {
    private double lambda = 1.0;
    private double sigmaColor = 0.3;
    private double lambdaAttenuation = 0.25;
    private int numberOfIterations = 3;

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double getSigmaColor() {
        return this.sigmaColor;
    }

    public void setSigmaColor(double sigmaColor) {
        this.sigmaColor = FastGlobalSmootherFilter.nonNegative((double)sigmaColor);
    }

    public double getLambdaAttenuation() {
        return this.lambdaAttenuation;
    }

    public void setLambdaAttenuation(double lambdaAttenuation) {
        this.lambdaAttenuation = lambdaAttenuation;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setNumberOfIterations(int numberOfIterations) {
        this.numberOfIterations = FastGlobalSmootherFilter.nonNegative((int)numberOfIterations);
    }

    @Override
    public void process(Mat result, Mat source, Mat guide) {
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.FastGlobalSmootherFilter filter = opencv_ximgproc.createFastGlobalSmootherFilter((Mat)guide, (double)this.lambda, (double)(this.sigmaColor * OTools.maxPossibleValue(source)), (double)this.lambdaAttenuation, (int)this.numberOfIterations);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.filter(source, result);
        }
    }

    @Override
    public void process(UMat result, UMat source, UMat guide) {
        long tStart = System.nanoTime();
        try (org.bytedeco.opencv.opencv_ximgproc.FastGlobalSmootherFilter filter = opencv_ximgproc.createFastGlobalSmootherFilter((UMat)guide, (double)this.lambda, (double)(this.sigmaColor * OTools.maxPossibleValue(source)), (double)this.lambdaAttenuation, (int)this.numberOfIterations);){
            this.addServiceTime(System.nanoTime() - tStart);
            filter.filter(source, result);
        }
    }
}

