/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.conversions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.algart.executors.modules.opencv.common.UMatFilter;
import net.algart.executors.modules.util.opencv.O2SMat;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.OColorConversion;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.UMat;

public final class ConvertColor
extends UMatFilter {
    public static final String CHANNEL_1 = "channel_1";
    public static final String CHANNEL_2 = "channel_2";
    public static final String CHANNEL_3 = "channel_3";
    public static final String CHANNEL_4 = "channel_4";
    public static final String RAW_0 = "raw_0";
    public static final String RAW_1 = "raw_1";
    public static final String RAW_2 = "raw_2";
    public static final String RAW_3 = "raw_3";
    public static final List<String> CHANNEL_PORTS = Collections.unmodifiableList(Arrays.asList("channel_1", "channel_2", "channel_3", "channel_4"));
    public static final List<String> RAW_CHANNEL_PORTS = Collections.unmodifiableList(Arrays.asList("raw_0", "raw_1", "raw_2", "raw_3"));
    private OColorConversion colorConversion = OColorConversion.BGR2Lab;
    private boolean floatResult = true;
    private boolean rgbOrder = true;
    private boolean autoConvertGrayscaleToColor = true;
    private double scale = 1.0;

    public ConvertColor() {
        this.useVisibleResultParameter();
        for (String port : CHANNEL_PORTS) {
            this.addOutputMat(port);
        }
        for (String port : RAW_CHANNEL_PORTS) {
            this.addOutputMat(port);
        }
    }

    public OColorConversion getColorConversion() {
        return this.colorConversion;
    }

    public ConvertColor setColorConversion(OColorConversion colorConversion) {
        this.colorConversion = (OColorConversion)((Object)ConvertColor.nonNull((Object)((Object)colorConversion)));
        return this;
    }

    public boolean isFloatResult() {
        return this.floatResult;
    }

    public ConvertColor setFloatResult(boolean floatResult) {
        this.floatResult = floatResult;
        return this;
    }

    public boolean isRgbOrder() {
        return this.rgbOrder;
    }

    public ConvertColor setRgbOrder(boolean rgbOrder) {
        this.rgbOrder = rgbOrder;
        return this;
    }

    public boolean isAutoConvertGrayscaleToColor() {
        return this.autoConvertGrayscaleToColor;
    }

    public ConvertColor setAutoConvertGrayscaleToColor(boolean autoConvertGrayscaleToColor) {
        this.autoConvertGrayscaleToColor = autoConvertGrayscaleToColor;
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public ConvertColor setScale(double scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public Mat process(Mat source) {
        ConvertColor.logDebug(() -> "Convert color: " + this.colorConversion + " conversion");
        if (this.colorConversion != OColorConversion.NONE) {
            if (this.autoConvertGrayscaleToColor && !this.colorConversion.isSingleChannelGrayScaleSource() && source.channels() == 1) {
                opencv_imgproc.cvtColor((Mat)source, (Mat)source, (int)8);
            }
            if (this.floatResult) {
                OTools.make32FIfNot(source);
            }
            if (this.rgbOrder) {
                OTools.flipRBChannels(source);
            }
            opencv_imgproc.cvtColor((Mat)source, (Mat)source, (int)this.colorConversion.code());
            if (this.rgbOrder) {
                OTools.flipRBChannels(source);
            }
            if (this.scale != 1.0) {
                source.convertTo(source, -1, this.scale, 0.0);
            }
        }
        int n = Math.min(RAW_CHANNEL_PORTS.size(), source.channels());
        for (int c = 0; c < n; ++c) {
            int channel = this.flipIndex(c, source.channels(), true);
            int rawChannel = this.flipIndex(c, source.channels(), false);
            boolean needChannelForOpenCV = this.isOutputNecessary(CHANNEL_PORTS.get(channel));
            boolean needRawChannel = this.isOutputNecessary(RAW_CHANNEL_PORTS.get(rawChannel));
            if (!needChannelForOpenCV && !needRawChannel) continue;
            Mat m = new Mat();
            opencv_core.extractChannel((Mat)source, (Mat)m, (int)c);
            if (needChannelForOpenCV) {
                O2SMat.setTo(this.getMat(CHANNEL_PORTS.get(channel)), m);
            }
            if (!needRawChannel) continue;
            O2SMat.setTo(this.getMat(RAW_CHANNEL_PORTS.get(rawChannel)), m);
        }
        return source;
    }

    @Override
    public UMat process(UMat source) {
        ConvertColor.logDebug(() -> "Convert color: " + this.colorConversion + " conversion");
        if (this.colorConversion != OColorConversion.NONE) {
            if (this.autoConvertGrayscaleToColor && !this.colorConversion.isSingleChannelGrayScaleSource() && source.channels() == 1) {
                opencv_imgproc.cvtColor((UMat)source, (UMat)source, (int)8);
            }
            if (this.floatResult) {
                OTools.make32FIfNot(source);
            }
            if (this.rgbOrder) {
                OTools.flipRBChannels(source);
            }
            opencv_imgproc.cvtColor((UMat)source, (UMat)source, (int)this.colorConversion.code());
            if (this.rgbOrder) {
                OTools.flipRBChannels(source);
            }
            if (this.scale != 1.0) {
                source.convertTo(source, -1, this.scale, 0.0);
            }
        }
        int n = Math.min(RAW_CHANNEL_PORTS.size(), source.channels());
        for (int c = 0; c < n; ++c) {
            int channel = this.flipIndex(c, source.channels(), true);
            int rawChannel = this.flipIndex(c, source.channels(), false);
            boolean needChannelForOpenCV = this.isOutputNecessary(CHANNEL_PORTS.get(channel));
            boolean needRawChannel = this.isOutputNecessary(RAW_CHANNEL_PORTS.get(rawChannel));
            if (!needChannelForOpenCV && !needRawChannel) continue;
            UMat m = new UMat();
            opencv_core.extractChannel((UMat)source, (UMat)m, (int)c);
            if (needChannelForOpenCV) {
                O2SMat.setTo(this.getMat(CHANNEL_PORTS.get(channel)), m);
            }
            if (!needRawChannel) continue;
            O2SMat.setTo(this.getMat(RAW_CHANNEL_PORTS.get(rawChannel)), m);
        }
        return source;
    }

    private int flipIndex(int c, int numberOfChannels, boolean always) {
        if ((always || this.rgbOrder) && (numberOfChannels == 3 || numberOfChannels == 4)) {
            return c == 0 || c == 2 ? 2 - c : c;
        }
        return c;
    }
}

