/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.opencv.matrices.conversions;

import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.opencv.common.VoidResultMatFilter;
import net.algart.executors.modules.util.opencv.OTools;
import net.algart.executors.modules.util.opencv.enums.OColorMap;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;

public final class ApplyColorMap
extends VoidResultMatFilter
implements ReadOnlyExecutionInput {
    private OColorMap colorMap = OColorMap.COLORMAP_HSV;

    public OColorMap getColorMap() {
        return this.colorMap;
    }

    public void setColorMap(OColorMap colorMap) {
        this.colorMap = (OColorMap)((Object)ApplyColorMap.nonNull((Object)((Object)colorMap)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Mat result, Mat source) {
        Mat mat = source;
        try {
            mat = OTools.to8UIfNot(mat);
            opencv_imgproc.applyColorMap((Mat)mat, (Mat)result, (int)this.colorMap.code());
        }
        finally {
            OTools.closeFirstIfDiffersFromSecond(mat, source);
        }
    }
}

